/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.selfmanagement.reconfig;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.selfmanagement.ManagementRuleEvent;
import com.sun.enterprise.admin.event.selfmanagement.ManagementRuleEventListener;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigDelete;
import com.sun.enterprise.config.ConfigSet;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.serverbeans.Action;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ManagementRule;
import com.sun.enterprise.config.serverbeans.ManagementRules;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.management.selfmanagement.SelfManagementService;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ManagementRuleReconfig
implements ManagementRuleEventListener {
    private static final SelfManagementService service = SelfManagementService.getService();
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");

    public synchronized void handleCreate(ManagementRuleEvent event) throws AdminEventListenerException {
        _logger.log(Level.FINE, "sgmt.reconfig_handlecreatereceived");
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            Object configAdd = null;
            ConfigChange configChange = null;
            ArrayList configChangeList = event.getConfigChangeList();
            ManagementRule rule = null;
            String xpath = null;
            String pXPath = null;
            Object ruleName = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                configChange = (ConfigChange)configChangeList.get(i);
                if (configChange instanceof ConfigAdd) {
                    _logger.log(Level.INFO, "sgmt.reconfig_handlecreaterulereceived");
                    xpath = configChange.getXPath();
                    if (xpath == null) continue;
                    _logger.log(Level.INFO, "sgmt.reconfig_handlexpath", xpath);
                    rule = (ManagementRule)configContext.exactLookup(xpath);
                    if (rule.isEnabled()) {
                        service.addRule(rule, configContext);
                        continue;
                    }
                    service.addDisabledRule(rule);
                    continue;
                }
                if (!(configChange instanceof ConfigSet)) continue;
                pXPath = configChange.getParentXPath();
                String name = configChange.getName();
                if (!name.equals("Action")) continue;
                _logger.log(Level.INFO, "smgt.handleactionadd", pXPath);
                rule = (ManagementRule)configContext.exactLookup(pXPath);
                service.handleActionAdd(rule, configContext);
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public synchronized void handleUpdate(ManagementRuleEvent event) throws AdminEventListenerException {
        _logger.log(Level.INFO, "sgmt.reconfig_handleupdatereceived");
        try {
            ConfigContext configContext = event.getConfigContext();
            ConfigContext adminConfigCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            ConfigUpdate configUp = null;
            ArrayList configChangeList = event.getConfigChangeList();
            String xPath = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                ManagementRule rule;
                if (configChangeList.get(i) instanceof ConfigAdd || configChangeList.get(i) instanceof ConfigSet || configChangeList.get(i) instanceof ConfigDelete) {
                    ConfigChange change = (ConfigChange)configChangeList.get(i);
                    xPath = change.getXPath();
                } else {
                    configUp = (ConfigUpdate)configChangeList.get(i);
                    xPath = configUp.getXPath();
                }
                if (xPath == null) continue;
                _logger.log(Level.INFO, "sgmt.handleupdatexpath", xPath);
                ConfigBean object = configContext.exactLookup(xPath);
                if (object instanceof ManagementRules) {
                    ManagementRules rules = (ManagementRules)object;
                    service.handleRulesUpdate(configContext, configUp);
                    continue;
                }
                if (object instanceof ManagementRule) {
                    ManagementRule rule2 = (ManagementRule)configContext.exactLookup(xPath);
                    service.handleRuleUpdate(rule2, configUp, configContext);
                    continue;
                }
                String pXPath = null;
                if (object instanceof ElementProperty || xPath.lastIndexOf("element-property") >= 0) {
                    pXPath = xPath.substring(0, xPath.lastIndexOf("/"));
                    if (pXPath != null) {
                        pXPath = pXPath.substring(0, pXPath.lastIndexOf("/"));
                    }
                } else {
                    pXPath = xPath.substring(0, xPath.lastIndexOf("/"));
                }
                if (pXPath != null && (rule = (ManagementRule)configContext.exactLookup(pXPath)) != null) {
                    String ruleName = rule.getName();
                    service.deleteRule(ruleName);
                    if (rule.isEnabled()) {
                        service.addRule(rule, adminConfigCtx);
                    } else {
                        service.addDisabledRule(rule);
                    }
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public synchronized void handleDelete(ManagementRuleEvent event) throws AdminEventListenerException {
        _logger.log(Level.INFO, "sgmt.reconfig_handledeletereceived");
        try {
            ConfigContext oldConfigContext = event.getOldConfigContext();
            ConfigContext configContext = event.getConfigContext();
            ConfigContext adminConfigCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            Config config = ServerBeansFactory.getConfigBean(adminConfigCtx);
            ConfigDelete configDel = null;
            ArrayList configChangeList = event.getConfigChangeList();
            ManagementRule rule = null;
            String xpath = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                String ruleName;
                String realXPath;
                configDel = (ConfigDelete)configChangeList.get(i);
                xpath = configDel.getXPath();
                if (xpath == null) continue;
                _logger.log(Level.INFO, "sgmt.reconfig_handledelxpath", xpath);
                ConfigBean object = oldConfigContext.exactLookup(xpath);
                if (object instanceof Action) {
                    realXPath = xpath.substring(0, xpath.lastIndexOf("/"));
                    rule = (ManagementRule)adminConfigCtx.exactLookup(realXPath);
                    ruleName = rule.getName();
                    service.deleteAction(ruleName);
                    continue;
                }
                if (object instanceof ManagementRule) {
                    rule = (ManagementRule)object;
                    String ruleName2 = rule.getName();
                    service.deleteRule(ruleName2);
                    continue;
                }
                realXPath = xpath.substring(0, xpath.lastIndexOf("/"));
                rule = (ManagementRule)adminConfigCtx.exactLookup(realXPath);
                ruleName = rule.getName();
                service.deleteAction(ruleName);
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }
}

