/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.model;

import com.sun.enterprise.management.agent.MEJBUtility;
import com.sun.enterprise.management.util.J2EEModuleUtil;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import javax.management.j2ee.ManagementHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public abstract class J2EEManagedObjectMdl
implements MBeanRegistration {
    private final String name;
    private final boolean stateManageable;
    private final boolean statisticsProvider;
    private final boolean eventProvider;
    private final String serverName;
    private volatile MBeanServer mServer;
    private volatile ObjectName mSelfObjectName;
    protected final Logger mLogger;

    J2EEManagedObjectMdl(String name, boolean state, boolean statistics, boolean events) {
        this(name, null, state, statistics, events);
    }

    J2EEManagedObjectMdl(String name, String serverName, boolean state, boolean statistics, boolean events) {
        this.name = name;
        this.stateManageable = state;
        this.statisticsProvider = statistics;
        this.eventProvider = events;
        this.serverName = serverName;
        this.mLogger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    }

    public final ObjectName preRegister(MBeanServer server, ObjectName nameIn) throws Exception {
        assert (nameIn != null);
        this.mServer = server;
        this.mSelfObjectName = nameIn;
        return this.mSelfObjectName;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public final void preDeregister() throws Exception {
    }

    public final void postDeregister() {
        this.mServer = null;
        this.mSelfObjectName = null;
    }

    protected final MBeanServer getMBeanServer() {
        ArrayList servers = (ArrayList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MBeanServerFactory.findMBeanServer(null);
            }
        });
        if (servers.isEmpty()) {
            return (MBeanServer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return MBeanServerFactory.createMBeanServer();
                }
            });
        }
        return (MBeanServer)servers.get(0);
    }

    protected final MEJBUtility getMEJBUtility() {
        return MEJBUtility.getMEJBUtility();
    }

    protected final Management getMEJB() {
        Management mejb = null;
        try {
            InitialContext ic = new InitialContext();
            String ejbName = System.getProperty("mejb.name", "ejb/mgmt/MEJB");
            Object objref = ic.lookup(ejbName);
            ManagementHome home = (ManagementHome)PortableRemoteObject.narrow(objref, ManagementHome.class);
            mejb = home.create();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mejb;
    }

    public final Set findNames(String keys) {
        return J2EEModuleUtil.findNames(keys);
    }

    public abstract String getj2eeType();

    protected final ObjectName getObjectName() {
        return this.mSelfObjectName;
    }

    public abstract String getobjectName();

    public boolean isstateManageable() {
        return this.stateManageable;
    }

    public final boolean isstatisticsProvider() {
        return this.statisticsProvider;
    }

    public boolean iseventProvider() {
        return this.eventProvider;
    }

    public final String getJ2EEServer() {
        if (this.serverName != null) {
            return this.serverName;
        }
        return "no-server";
    }

    public final String getname() {
        return this.name;
    }

    protected final long now() {
        return System.currentTimeMillis();
    }
}

