/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.model;

import com.sun.enterprise.management.model.J2EEEventProviderMOMdl;
import com.sun.enterprise.management.util.J2EEModuleCallBack;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;

public abstract class J2EEDeployedObjectMdl
extends J2EEEventProviderMOMdl {
    public static final int STARTING_STATE = 0;
    public static final int RUNNING_STATE = 1;
    public static final int STOPPING_STATE = 2;
    public static final int STOPPED_STATE = 3;
    public static final int FAILED_STATE = 4;
    private J2EEModuleCallBack module;
    private int state = 1;
    private long startTime = System.currentTimeMillis();
    private long sequenceNo = 0L;
    private String[] eventTypes = new String[]{"j2ee.state.starting", "j2ee.state.running", "j2ee.state.stopping", "j2ee.state.stopped", "j2ee.state.failed"};

    J2EEDeployedObjectMdl(J2EEModuleCallBack m) {
        super(m.getName(), m.getServerName(), false, false);
        this.module = m;
    }

    public String getdeploymentDescriptor() {
        return this.module.getDeploymentDescriptor();
    }

    public String getserver() {
        String qs = "name=" + this.getJ2EEServer() + ",j2eeType=J2EEServer";
        Set s = this.findNames(qs);
        ObjectName[] sa = s.toArray(new ObjectName[s.size()]);
        if (sa.length > 0) {
            return sa[0].toString();
        }
        return "Failed to find the server ObjectName";
    }

    public String[] geteventTypes() {
        return this.eventTypes;
    }

    public int getstate() {
        return this.state;
    }

    public void setstate(int st) {
        this.state = st;
        this.stateChanged(this.eventTypes[st]);
    }

    public long getstartTime() {
        return this.startTime;
    }

    public void start() {
        block7: {
            block6: {
                if (this.state == 0) break block6;
                if (this.state == 1) break block6;
                if (this.state != 2) break block7;
            }
            throw new RuntimeException(new Exception("cannot start because the current state is " + this.state));
        }
        try {
            this.state = 0;
            this.stateChanged("j2ee.state.starting");
            this.module.start(this);
            this.state = 1;
            this.startTime = System.currentTimeMillis();
            this.stateChanged("j2ee.state.running");
        }
        catch (Exception ex) {
            this.state = 4;
            this.stateChanged("j2ee.state.failed");
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public void stop() throws MBeanException {
        block7: {
            block6: {
                if (this.state == 3) break block6;
                if (this.state != 2) break block7;
            }
            throw new RuntimeException(new Exception("cannot stop because the current state is " + this.state));
        }
        try {
            this.state = 2;
            this.stateChanged("j2ee.state.stopping");
            this.module.stop(this);
            this.state = 3;
            this.stateChanged("j2ee.state.stopped");
        }
        catch (Exception ex) {
            this.state = 4;
            this.stateChanged("j2ee.state.failed");
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public void startRecursive() throws MBeanException {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChanged(String state) {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(this.getobjectName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (objectName != null) {
            Notification notification = null;
            J2EEDeployedObjectMdl j2EEDeployedObjectMdl = this;
            synchronized (j2EEDeployedObjectMdl) {
                notification = new Notification(state, objectName, this.sequenceNo);
                ++this.sequenceNo;
            }
            this.sendNotification(notification);
        }
    }
}

