/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.ConnectorArchivist;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.instance.ExceptionType;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.Localizer;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.instance.ModulesManager;
import com.sun.enterprise.instance.SerializedDescriptorHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.enterprise.deploy.shared.ModuleType;

public class ConnectorModulesManager
extends ModulesManager {
    public ConnectorModulesManager(InstanceEnvironment env) throws ConfigException {
        super(env, true);
    }

    public ConnectorModulesManager(InstanceEnvironment env, boolean useBackupServerXml) throws ConfigException {
        super(env, useBackupServerXml);
        ConnectorModule[] jArray = ((Applications)this.configBean).getConnectorModule();
        if (jArray != null) {
            for (int i = 0; i < jArray.length; ++i) {
                jArray[i].setConfigContext(this.configContext);
                jArray[i].setXPath(ServerXPathHelper.getConnectorModuleIdXpathExpression(jArray[i].getName()));
            }
        }
    }

    public ModuleType getModuleType() {
        return ModuleType.RAR;
    }

    public ConnectorModule[] listConnectorModules() {
        ConnectorModule[] mods = ((Applications)this.configBean).getConnectorModule();
        if (mods == null) {
            return new ConnectorModule[0];
        }
        ArrayList<ConnectorModule> list = new ArrayList<ConnectorModule>();
        for (int i = 0; i < mods.length; ++i) {
            if (!this.isReferenced(mods[i].getName())) continue;
            list.add(mods[i]);
        }
        ConnectorModule[] refList = new ConnectorModule[list.size()];
        return list.toArray(refList);
    }

    public List listIds() {
        ArrayList<String> arr = new ArrayList<String>();
        ConnectorModule[] mods = ((Applications)this.configBean).getConnectorModule();
        if (mods == null) {
            return arr;
        }
        for (int i = 0; i < mods.length; ++i) {
            String name = mods[i].getName();
            if (!this.isReferenced(name)) continue;
            arr.add(name);
        }
        return arr;
    }

    private ConnectorModule getConnectorModule(String modId) throws ConfigException {
        ConnectorModule mod = ((Applications)this.configBean).getConnectorModuleByName(modId);
        if (mod == null) {
            throw new ConfigException(Localizer.getValue(ExceptionType.NO_SUCH_CON_MOD));
        }
        return mod;
    }

    public String getGeneratedXMLLocation(String name) {
        ModuleEnvironment menv = this.instanceEnvironment.getModuleEnvironment(name, DeployableObjectType.CONN);
        return menv.getModuleGeneratedXMLPath();
    }

    public void remove(String modId) throws ConfigException {
        ConnectorModule backEm = ((Applications)this.configBean).getConnectorModuleByName(modId);
        ((Applications)this.configBean).removeConnectorModule(backEm);
    }

    protected boolean isRegistered(String modId, ConfigBean bean) {
        ConnectorModule cb = null;
        try {
            cb = ((Applications)bean).getConnectorModuleByName(modId);
        }
        catch (Exception cn) {
            // empty catch block
        }
        return cb != null;
    }

    public boolean isEnabled(String modId) throws ConfigException {
        return this.getConnectorModule(modId).isEnabled();
    }

    public boolean isSystem(String modId) throws ConfigException {
        ConnectorModule cm = this.getConnectorModule(modId);
        String resourceType = cm.getObjectType();
        return resourceType.startsWith("system-");
    }

    public boolean isSystemPredeployed(String modId) throws ConfigException {
        ConnectorModule cm = this.getConnectorModule(modId);
        String resourceType = cm.getObjectType();
        boolean isDirectoryDeployed = cm.isDirectoryDeployed();
        return resourceType.startsWith("system-") && isDirectoryDeployed;
    }

    public boolean isSystemAdmin(String modId) throws ConfigException {
        ConnectorModule cm = this.getConnectorModule(modId);
        String resourceType = cm.getObjectType();
        return resourceType.startsWith("system-admin");
    }

    public void setEnable(String modId, boolean enable) throws ConfigException {
        this.getConnectorModule(modId).setEnabled(enable);
    }

    public void setOptionalAttributes(String modId, Properties optionalAttributes) throws ConfigException {
        if (optionalAttributes != null) {
            ConnectorModule cm = this.getConnectorModule(modId);
            Enumeration<Object> tags = optionalAttributes.keys();
            while (tags.hasMoreElements()) {
                String tag = (String)tags.nextElement();
                String value = optionalAttributes.getProperty(tag);
                cm.setAttributeValue(tag, value);
            }
        }
    }

    public String getLocation(String name) {
        String location = null;
        if (ResourcesUtil.createInstance().belongToSystemRar(name)) {
            location = Switch.getSwitch().getResourceInstaller().getSystemModuleLocation(name);
        } else {
            ConnectorModule connectorModule = ((Applications)this.configBean).getConnectorModuleByName(name);
            location = connectorModule.getLocation();
        }
        return this.resolvePath(location);
    }

    public void setLocation(String modId, String location) throws ConfigException {
        ConnectorModule connectorModule = ((Applications)this.configBean).getConnectorModuleByName(modId);
        connectorModule.setLocation(location);
    }

    public String getDescription(String modId) throws ConfigException {
        return this.getConnectorModule(modId).getDescription();
    }

    public void setDescription(String modId, String desc) throws ConfigException {
        this.getConnectorModule(modId).setDescription(desc);
    }

    public Application getDescriptor(String modId, ClassLoader cl, String modDir, boolean validateXml) throws ConfigException {
        Application application = this.getRegisteredDescriptor(modId);
        if (application != null) {
            application.setClassLoader(cl);
            return application;
        }
        try {
            ConnectorArchivist connectorArchivist = new ConnectorArchivist();
            connectorArchivist.setXMLValidation(validateXml);
            connectorArchivist.setClassLoader(cl);
            FileArchive archive = new FileArchive();
            archive.open(modDir);
            SerializedDescriptorHelper.Loader sdLoader = SerializedDescriptorHelper.load(modId, this);
            Application deserializedApplication = sdLoader.getApplication();
            application = deserializedApplication != null ? deserializedApplication : ApplicationArchivist.openArchive(modId, connectorArchivist, archive, true);
            application.setClassLoader(cl);
            application.setGeneratedXMLDirectory(this.getGeneratedXMLLocation(modId));
            this.registerDescriptor(modId, application);
            sdLoader.store(application);
            return application;
        }
        catch (IOException ioe) {
            throw new ConfigException(Localizer.getValue(ExceptionType.IO_ERROR_LOADING_DD, modId), ioe);
        }
        catch (Throwable t) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FAIL_DD_LOAD, modId), t);
        }
    }
}

