/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.util;

import com.sun.enterprise.diagnostics.DiagnosticException;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogNameFilter
implements FilenameFilter {
    private Date startDate;
    private Date endDate;
    private String fileNamePrefix;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public LogNameFilter(String fileName, Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.fileNamePrefix = fileName;
    }

    public boolean accept(File aDir, String fileName) {
        if (aDir == null || fileName == null) {
            return false;
        }
        if (fileName.indexOf(this.fileNamePrefix) < 0) {
            return false;
        }
        int datePatternIndex = fileName.indexOf(95);
        if (datePatternIndex > 0) {
            try {
                Date fileDate = dateFormat.parse(fileName.substring(datePatternIndex + 1, datePatternIndex + 11));
                if (this.isValidEntry(fileDate, this.startDate, this.endDate)) {
                    return true;
                }
                Date firstLogEntry = this.getDateOfFirstLogEntry(aDir, fileName);
                return this.isValidEntry(firstLogEntry, this.startDate, this.endDate);
            }
            catch (Exception e) {
                return false;
            }
        }
        try {
            Date date = this.getDateOfFirstLogEntry(aDir, fileName);
            return this.isValidEntry(date, this.startDate, this.endDate);
        }
        catch (DiagnosticException de) {
            return false;
        }
    }

    private boolean isValidEntry(Date firstLogEntry, Date startDate, Date endDate) {
        if (firstLogEntry == null) {
            return false;
        }
        if (endDate != null) {
            return firstLogEntry.compareTo(startDate) >= 0 && firstLogEntry.compareTo(endDate) <= 0;
        }
        return firstLogEntry.compareTo(startDate) >= 0;
    }

    /*
     * Exception decompiling
     */
    private Date getDateOfFirstLogEntry(File aDir, String fileName) throws DiagnosticException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

