/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.report.html;

import com.sun.enterprise.diagnostics.report.html.Attribute;
import com.sun.enterprise.diagnostics.report.html.Element;
import com.sun.enterprise.diagnostics.report.html.Escape;
import com.sun.enterprise.diagnostics.report.html.HTMLAttribute;
import com.sun.enterprise.diagnostics.report.html.HTMLComment;
import com.sun.enterprise.diagnostics.report.html.HTMLComponent;
import com.sun.enterprise.diagnostics.report.html.HTMLText;
import com.sun.enterprise.diagnostics.report.html.Text;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLElement
implements Element {
    private String name = null;
    private List<HTMLComponent> children = new LinkedList<HTMLComponent>();
    private List<Attribute> attributes = new LinkedList<Attribute>();
    private static final char TAG_MARKER_BEGIN = '<';
    private static final char TAG_MARKER_END = '>';
    private static final String SLASH_BEGIN = "/>";
    private static final String SLASH_END = "</";

    public HTMLElement(String name) {
        this.setName(name);
    }

    @Override
    public void add(HTMLComponent child) {
        if (child == null) {
            throw new NullPointerException("Child node is null.");
        }
        if (child == this) {
            throw new IllegalArgumentException("Attempt to add a node to itself.  Node is " + this.toString() + ".");
        }
        if (child instanceof Attribute) {
            this.attributes.add((Attribute)child);
        } else {
            this.children.add(child);
        }
    }

    @Override
    public Element addElement(String name) {
        if (name == null) {
            throw new NullPointerException("Element name is null.");
        }
        HTMLElement newElement = new HTMLElement(name);
        this.add(newElement);
        return newElement;
    }

    @Override
    public Text addComment(String content) {
        HTMLComment comment = new HTMLComment(content);
        this.add(comment);
        return comment;
    }

    @Override
    public Text addText(String text) {
        if (text != null) {
            HTMLText textNode = new HTMLText(text);
            this.add(textNode);
            return textNode;
        }
        return null;
    }

    public void addText(Iterator<String> textValues) {
        while (textValues.hasNext()) {
            HTMLText textNode = new HTMLText(textValues.next());
            this.add(textNode);
        }
    }

    @Override
    public Attribute addAttribute(String id, String value) {
        HTMLAttribute att = new HTMLAttribute(id, value);
        this.add(att);
        return att;
    }

    @Override
    public List<Element> getElements() {
        LinkedList<Element> retval = new LinkedList<Element>();
        for (HTMLComponent node : this.children) {
            if (!(node instanceof Element)) continue;
            retval.add((Element)node);
        }
        return retval;
    }

    @Override
    public List<Element> getElements(String name) {
        LinkedList<Element> list = new LinkedList<Element>();
        for (HTMLComponent node : this.children) {
            Element element;
            if (!(node instanceof Element) || !(element = (Element)node).getName().equalsIgnoreCase(name)) continue;
            list.add((Element)node);
        }
        return list;
    }

    @Override
    public List<Text> getComments() {
        LinkedList<Text> list = new LinkedList<Text>();
        for (HTMLComponent node : this.children) {
            if (!(node instanceof HTMLComment)) continue;
            list.add((HTMLComment)node);
        }
        return list;
    }

    @Override
    public List<Text> getTexts() {
        LinkedList<Text> retval = new LinkedList<Text>();
        for (HTMLComponent node : this.children) {
            if (!(node instanceof Text)) continue;
            retval.add((Text)node);
        }
        return retval;
    }

    @Override
    public List<Attribute> getAttributes() {
        LinkedList<Attribute> retval = new LinkedList<Attribute>();
        retval.addAll(this.attributes);
        return retval;
    }

    @Override
    public List<Attribute> getAttributes(String name) {
        LinkedList<Attribute> retval = new LinkedList<Attribute>();
        for (Attribute node : this.getAttributes()) {
            Attribute att;
            if (!(node instanceof Attribute) || !(att = node).getName().equalsIgnoreCase(name)) continue;
            retval.add(node);
        }
        return retval;
    }

    @Override
    public List<HTMLComponent> children() {
        LinkedList<HTMLComponent> childrenList = new LinkedList<HTMLComponent>();
        childrenList.addAll(this.children);
        childrenList.addAll(this.attributes);
        return childrenList;
    }

    @Override
    public void delete(HTMLComponent child) {
        if (child instanceof Attribute) {
            this.attributes.remove(child);
        } else {
            this.children.remove(child);
        }
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        String eName = Escape.getInstance().encodeEntities(this.name, " \t\r\n");
        buf.append('<').append(eName);
        for (Attribute att : this.attributes) {
            buf.append(" ").append(att.toString());
        }
        if (this.children.size() == 0) {
            buf.append(SLASH_BEGIN);
        } else {
            buf.append('>');
            for (HTMLComponent node : this.children) {
                buf.append(((Object)node).toString());
            }
            buf.append(SLASH_END).append(eName).append('>');
        }
        return buf.toString();
    }

    @Override
    public void write(Writer output) throws IOException {
        output.append(this.toString());
        output.flush();
    }

    @Override
    public void write(File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        this.write(fileWriter);
        fileWriter.close();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Element name is null.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Element name is empty.");
        }
        this.name = name;
    }

    @Override
    public <T extends HTMLComponent> List<T> get(Class<T> type) {
        LinkedList<HTMLComponent> list = new LinkedList<HTMLComponent>();
        for (HTMLComponent child : this.children()) {
            if (!type.isInstance(child)) continue;
            list.add(child);
        }
        return list;
    }
}

