/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.Defaults;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.FileData;
import com.sun.enterprise.diagnostics.collect.ProcessExecutor;
import com.sun.enterprise.diagnostics.collect.ProcessExecutorException;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SolarisSystemInfoCollector
implements Collector {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    private static final String HARD_DISK_INFO_CMD = "df -k | grep /dev | grep -v /dev/fd | awk '{print $1, $2, $6}'";
    private static final String MEMORY_INFO_CMD = "/usr/sbin/prtconf | grep 'Memory size'";
    private static final String NETWORK_SETTINGS_CMD = "ifconfig -a | egrep '^hme|^qfe' | awk '{print $1, $2, $6}'";
    private static final String TCP_SETTINGS_CMD = "ndd /dev/tcp tcp_time_wait_interval";
    private static final String IP_ADDRESS_INFO_CMD = "netstat -in | /usr/xpg4/bin/grep -Ev 'Name|lo0' | awk '{print $4}'";
    private static final String OS_LEVEL_PATCH_INFO_CMD = "showrev -p";
    private static final String HOST_NAME_CMD = "hostname";
    private static final String DOMAIN_NAME_CMD = "domainname";
    private static final String SOFT_FILE_DESC_LIMIT_CMD = "ulimit -n";
    private static final String HARD_FILE_DESC_LIMIT_CMD = "ulimit -Hn";
    private static final String PROCESSOR_INFO_CMD = "psrinfo -v | grep 'processor operates at'";
    private static final String SWAP_INFO_CMD = "swap -s";
    private String destFolder = null;

    public SolarisSystemInfoCollector(String destFolder) {
        this.destFolder = destFolder;
    }

    public Data capture() {
        FileData data = null;
        String outputFileName = this.destFolder + File.separator + Defaults.SYSTEM_INFO_FILE;
        String ALL_CMDS = "(  echo 'HOST NAME' ; hostname ; echo 'DOMAIN NAME' ; domainname ; echo 'HARD DISK INFO ' ; df -k | grep /dev | grep -v /dev/fd | awk '{print $1, $2, $6}' ; echo 'NETWORK CONFIGURATION ' ; ifconfig -a | egrep '^hme|^qfe' | awk '{print $1, $2, $6}' ; echo 'IP ADDRESS ' ; netstat -in | /usr/xpg4/bin/grep -Ev 'Name|lo0' | awk '{print $4}' ; echo 'OS LEVEL PATCH INFO' ; showrev -p ; echo 'SOFT FILE DESCRIPTOR LIMIT ' ; ulimit -n ; echo 'HARD FILE DESCRIPTOR LIMIT ' ; ulimit -Hn ; echo 'PROCESSOR INFO' ; psrinfo -v | grep 'processor operates at' ; echo 'SWAP SPACE' ; swap -s ; echo 'MEMORY INFO ' ; /usr/sbin/prtconf | grep 'Memory size'  ) >> " + outputFileName;
        String[] cmd = new String[]{"sh", "-c", ALL_CMDS};
        ProcessExecutor executor = new ProcessExecutor(cmd, 0L);
        try {
            executor.execute();
            File outputFile = new File(outputFileName);
            data = new FileData(outputFile.getName(), "system Info");
        }
        catch (ProcessExecutorException pee) {
            logger.log(Level.WARNING, "Exception while capturing system info : " + pee.getMessage());
        }
        return data;
    }
}

