/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ExecutionContext;
import com.sun.enterprise.diagnostics.TargetResolver;
import com.sun.enterprise.diagnostics.TargetType;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import java.io.File;
import java.util.logging.Level;

public class PERemoteTargetResolver
extends TargetResolver {
    private static final String REPOSITORY_CONFIG_CLASS_NAME = "com.sun.enterprise.admin.servermgmt.DomainConfig";
    private static final String GET_REP_ROOT_METHOD = "getRepositoryRoot";
    private static final String GET_REP_NAME = "getRepositoryName";

    public PERemoteTargetResolver(String target, String repositoryDir, boolean local) {
        super(target, repositoryDir, local);
    }

    public boolean validateTarget() throws DiagnosticException {
        ConfigContext configContext = this.getServerContext().getConfigContext();
        try {
            String domainName = ServerHelper.getAdministrativeDomainName(configContext, null);
            if (domainName != null) {
                return domainName.equals(this.target);
            }
        }
        catch (ConfigException ce) {
            throw new DiagnosticException("Couldn't determine domain name");
        }
        throw new DiagnosticException("Couldn't determine domain name");
    }

    protected ServerContext getServerContext() {
        return ApplicationServer.getServerContext();
    }

    protected void setExecutionContext() {
        this.context = ExecutionContext.REMOTE_EC;
    }

    protected void determineRepositoryDetails() {
        File instanceRoot = new File(this.getServerContext().getInstanceEnvironment().getInstancesRoot());
        this.repositoryDir = instanceRoot.getParentFile().getAbsolutePath();
        this.repositoryName = instanceRoot.getName();
        this.logger.log(Level.FINE, "diagnostic-service.resolver_repositoryDetails", new Object[]{this.repositoryDir, this.repositoryName});
    }

    protected void determineTargetType() {
        if (this.type == null) {
            this.setTargetType(TargetType.DAS);
        }
    }

    protected void determineInstances() {
        this.addInstance(TargetType.DAS.getType());
    }
}

