/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.appserv.management.deploy.DeploymentProgressImpl;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeployerFactory;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.phasing.ApplicationConfigHelper;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhase;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.management.deploy.DeploymentCallback;
import com.sun.enterprise.resource.Resource;
import com.sun.enterprise.resource.ResourceUtilities;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;

public class J2EECPhase
extends DeploymentPhase {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(J2EECPhase.class);

    public J2EECPhase(DeploymentContext deploymentCtx) {
        this.deploymentCtx = deploymentCtx;
        this.name = "J2EEC";
    }

    public void runPhase(DeploymentPhaseContext phaseCtx) {
        boolean wasUnRegistered = false;
        String type = null;
        boolean isApp = false;
        boolean isRedeploy = false;
        int actionCode = -1;
        String targetName = null;
        DeploymentTarget target = null;
        DeploymentRequest req = phaseCtx.getDeploymentRequest();
        DeploymentStatus status = phaseCtx.getDeploymentStatus();
        Deployer deployer = null;
        try {
            int percent;
            DeploymentCallback callback = req.getDeploymentCallback();
            if (callback != null) {
                percent = 0;
                DeploymentProgressImpl progress = new DeploymentProgressImpl((byte)percent, "deployment started", null);
                callback.deploymentProgress(progress);
            }
            req.setCurrentDeploymentStatus(status);
            req.setDescriptor(this.deploymentCtx.getApplication(req.getName()));
            deployer = DeployerFactory.getDeployer(req);
            if (req.isApplication()) {
                isApp = true;
            }
            deployer.doRequestPrepare();
            if (req.isReDeploy()) {
                isRedeploy = true;
                if (AppVerification.doInstrument()) {
                    AppVerification.getInstrumentLogger().handleChangeInDeployment();
                }
            }
            if (isRedeploy) {
                this.deploymentCtx.removeApplication(req.getName());
                req.setDescriptor(null);
                target = (DeploymentTarget)req.getTarget();
                if (target != null && !target.getName().equals("domain")) {
                    targetName = target.getName();
                    if (isApp) {
                        type = null;
                        actionCode = 2;
                    } else {
                        type = DeploymentServiceUtils.getModuleTypeString(req.getType());
                        actionCode = 5;
                    }
                    DeploymentServiceUtils.multicastEvent(actionCode, req.getName(), type, req.getCascade(), req.isForced(), targetName);
                    wasUnRegistered = true;
                }
            }
            deployer.doRequestFinish();
            this.deploymentCtx.addApplication(req.getName(), req.getDescriptor());
            this.parseAndValidateSunResourcesXMLFiles(req);
            DeploymentServiceUtils.checkAbort(req.getName());
            if (isRedeploy) {
                DeploymentServiceUtils.updateConfig(req);
            } else {
                DeploymentServiceUtils.addToConfig(req);
            }
            ApplicationConfigHelper.resetAppContextRoots(DeploymentServiceUtils.getConfigContext(), req.getName(), true);
            wasUnRegistered = false;
            deployer.cleanup();
            status.setStageStatus(2);
            sLogger.log(Level.INFO, "deployed with moduleid = " + req.getName());
            this.populateStatusProperties(status, req);
            if (callback != null) {
                percent = 100;
                DeploymentProgressImpl progress2 = new DeploymentProgressImpl((byte)percent, "deployment finished", null);
                callback.deploymentProgress(progress2);
            }
        }
        catch (Throwable t) {
            String msg = localStrings.getString("enterprise.deployment.phasing.j2eec.error");
            if (t.getCause() != null) {
                msg = msg + t.getCause().toString();
            }
            try {
                if (target == null) {
                    if (deployer != null) {
                        deployer.removePolicy();
                    }
                    DeploymentServiceUtils.removeFromConfig(req.getName(), req.getType());
                }
            }
            catch (Exception eee) {
                // empty catch block
            }
            if (isRedeploy && wasUnRegistered && t instanceof IASDeploymentException && req.getReRegisterOnFailure()) {
                actionCode = isApp ? 1 : 4;
                try {
                    DeploymentServiceUtils.multicastEvent(actionCode, req.getName(), type, req.getCascade(), req.isForced(), targetName);
                }
                catch (Throwable t2) {
                    msg = msg + t2;
                }
            }
            sLogger.log(Level.SEVERE, msg, t);
            status.setStageStatus(0);
            if (t instanceof Serializable) {
                status.setStageException(t);
            } else {
                sLogger.severe(localStrings.getString("enterprise.deployment.phasing.exception_notserializable", t.getClass()));
                sLogger.severe(localStrings.getString("enterprise.deployment.phasing.exception_notforwarded", t.getMessage()));
            }
            status.setStageStatusMessage(t.getMessage());
        }
    }

    protected DeploymentEvent getPrePhaseEvent(DeploymentEventInfo info) {
        return new DeploymentEvent(1, info);
    }

    protected DeploymentEvent getPostPhaseEvent(DeploymentEventInfo info) {
        return new DeploymentEvent(2, info);
    }

    private void populateStatusProperties(DeploymentStatus status, DeploymentRequest request) throws IOException, IASDeploymentException {
        DeploymentStatus mainStatus = status.getMainStatus();
        this.populateModuleIDs(mainStatus, request);
        if (request.getDescriptor() != null) {
            this.populateWsdlFilesForPublish(mainStatus, request);
        }
    }

    private void populateModuleIDs(DeploymentStatus status, DeploymentRequest request) {
        String sep = "_";
        String key = "moduleid";
        String moduleID = request.getName();
        status.addProperty(key, moduleID);
        key = "ModuleID";
        status.addProperty(key, moduleID);
        key = moduleID + sep + "ModuleType";
        ModuleType moduleType = request.getType().getModuleType();
        status.addProperty(key, String.valueOf(moduleType.getValue()));
        Application app = request.getDescriptor();
        if (app != null) {
            if (!app.isVirtual()) {
                int counter = 0;
                Iterator it = app.getModules();
                while (it.hasNext()) {
                    ModuleDescriptor md = (ModuleDescriptor)it.next();
                    key = moduleID + sep + "moduleid" + sep + String.valueOf(counter);
                    String subModuleID = moduleID + "#" + md.getArchiveUri();
                    status.addProperty(key, subModuleID);
                    key = subModuleID + sep + "ModuleType";
                    status.addProperty(key, String.valueOf(md.getModuleType().getValue()));
                    if (ModuleType.WAR.equals(md.getModuleType())) {
                        WebBundleDescriptor wbd = (WebBundleDescriptor)md.getDescriptor();
                        key = subModuleID + sep + "ContextRoot";
                        status.addProperty(key, this.getContextRoot(wbd));
                    }
                    ++counter;
                }
                key = moduleID + sep + "NumberOfSubModules";
                status.addProperty(key, String.valueOf(counter));
            } else {
                BundleDescriptor bd = app.getStandaloneBundleDescriptor();
                if (ModuleType.WAR.equals(bd.getModuleType())) {
                    WebBundleDescriptor wbd = (WebBundleDescriptor)bd;
                    key = moduleID + sep + "ContextRoot";
                    status.addProperty(key, this.getContextRoot(wbd));
                }
            }
        }
    }

    private void populateWsdlFilesForPublish(DeploymentStatus status, DeploymentRequest request) throws IOException, IASDeploymentException {
        ModuleType moduleType = request.getType().getModuleType();
        if (!(ModuleType.EAR.equals(moduleType) || ModuleType.WAR.equals(moduleType) || ModuleType.EJB.equals(moduleType))) {
            return;
        }
        String sep = "_";
        Application app = request.getDescriptor();
        String moduleID = request.getName();
        AbstractArchive moduleArchive = null;
        String key = null;
        String keyPrefix = null;
        FileArchive archive = new FileArchive();
        archive.open(RelativePathResolver.resolvePath(this.getGeneratedAppLocation(request)));
        for (WebService webService : app.getWebServiceDescriptors()) {
            if (!webService.hasFilePublishing()) continue;
            String clientPublishURL = webService.getClientPublishUrl().toExternalForm();
            if (app.isVirtual()) {
                keyPrefix = moduleID;
                moduleArchive = archive;
            } else {
                ModuleDescriptor md = webService.getBundleDescriptor().getModuleDescriptor();
                keyPrefix = moduleID + "#" + md.getArchiveUri();
                moduleArchive = archive.getEmbeddedArchive(md.getArchiveUri());
            }
            key = keyPrefix + sep + "ClientPublishURL";
            status.addProperty(key, clientPublishURL);
            BundleDescriptor bundle = webService.getBundleDescriptor();
            Enumeration entries = moduleArchive.entries(bundle.getWsdlDir());
            int counter = 0;
            while (entries.hasMoreElements()) {
                String name = (String)entries.nextElement();
                key = keyPrefix + sep + "WsdlFileEntries" + sep + String.valueOf(counter);
                status.addProperty(key, this.stripWsdlDir(name, bundle));
                String wsdlFileLocation = moduleArchive.getArchiveUri() + File.separator + name.replace('/', File.separatorChar);
                key = key + sep + "WsdlFileLocation";
                status.addProperty(key, wsdlFileLocation);
                ++counter;
            }
            key = keyPrefix + sep + "WsdlFileEntries" + sep + "NumberOfEntries";
            status.addProperty(key, String.valueOf(counter));
        }
    }

    private String getContextRoot(WebBundleDescriptor wbd) {
        String contextRoot = wbd.getContextRoot();
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        return contextRoot;
    }

    private String getGeneratedAppLocation(DeploymentRequest request) throws IASDeploymentException {
        String xmlDir = request.getDescriptor().getGeneratedXMLDirectory();
        if (xmlDir == null || !FileUtils.safeIsDirectory(xmlDir)) {
            xmlDir = DeploymentServiceUtils.getLocation(request.getName(), request.getType());
        }
        return xmlDir;
    }

    private String stripWsdlDir(String entry, BundleDescriptor bundle) {
        String wsdlDir = bundle.getWsdlDir();
        return entry.substring(wsdlDir.length() + 1);
    }

    private void parseAndValidateSunResourcesXMLFiles(DeploymentRequest req) throws Exception {
        List<Resource> resourceList = DeploymentServiceUtils.getResourceList(req, true, this.deploymentCtx);
        ResourceUtilities.getResourceConflictsWithDomainXML(resourceList, DeploymentServiceUtils.getConfigContext());
    }
}

