/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.AppDeployer;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentEventManager;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileSource;
import java.io.File;

public class AppReDeployer
extends AppDeployer {
    private String failureMessage = "\n*********************\n****Redeployment Failed -- rolled back redeployment";
    private String successMessage = "\n*********************\n****Redeployment Successful for ";
    private File originalAppDir = null;
    private boolean appWasUnregistered = false;
    private Application app = null;
    private static StringManager localStrings = StringManager.getManager(AppReDeployer.class);

    AppReDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    protected void begin() throws IASDeploymentException {
        super.begin();
        try {
            this.app = this.getManager().getDescriptor(this.getAppName());
            if (this.app == null) {
                this.app = this.request.getDescriptor();
            }
            this.originalAppDir = new File(DeploymentServiceUtils.getLocation(this.getAppName(), this.request.getType()));
            this.getManager().unregisterDescriptor(this.getAppName());
            this.removePolicy();
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.backend.error_getting_app_location", this.getAppName());
            throw new IASDeploymentException(msg, e);
        }
    }

    protected final void predeploy() throws IASDeploymentException {
        this.appWasUnregistered = true;
        super.predeploy();
        DeploymentEventInfo info = new DeploymentEventInfo(this.getAppDir(), this.getStubsDir(), this.app, this.getRequest());
        DeploymentEvent ev = new DeploymentEvent(1, info);
        DeploymentEventManager.notifyDeploymentEvent(ev);
        this.liquidate();
        this.getAppDir().mkdirs();
    }

    protected final File setAppDir() throws IASDeploymentException {
        File newAppDir = null;
        if (this.isArchive()) {
            newAppDir = this.setAppDirArchive();
        } else if (this.isDirectory()) {
            newAppDir = this.setAppDirDirectory();
        } else {
            String msg = localStrings.getString("enterprise.deployment.backend.redeployment_not_dir_or_archive");
            throw new IASDeploymentException(msg);
        }
        return newAppDir;
    }

    protected String whatAreYou() {
        return "Redeployment";
    }

    private final File setAppDirDirectory() throws IASDeploymentException {
        FileSource fileSource = this.request.getFileSource();
        if (!fileSource.exists()) {
            String msg = localStrings.getString("enterprise.deployment.backend.file_source_does_not_exist", fileSource);
            throw new IASDeploymentException(msg);
        }
        assert (fileSource.isDirectory());
        File appDirectory = fileSource.getFile();
        return appDirectory;
    }

    private final File setAppDirArchive() throws IASDeploymentException {
        assert (this.originalAppDir != null);
        return this.originalAppDir;
    }
}

