/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.autodeploy;

import com.sun.enterprise.deployment.autodeploy.AutoDeployControllerImpl;
import com.sun.enterprise.deployment.autodeploy.AutoDeployedFilesManager;
import com.sun.enterprise.deployment.autodeploy.AutoDeployer;
import com.sun.enterprise.deployment.autodeploy.AutoDeploymentException;
import com.sun.enterprise.deployment.autodeploy.JBIDeployer;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.xml.sax.InputSource;

public class JBIAutoDeployer {
    private static final JBIAutoDeployer jad = new JBIAutoDeployer();
    private static final String JBI_STATUS_DIR = ".jbi";
    private static final String DELIMITER = "__";
    private static final String SA_NAME_PATH = "jbi:jbi/jbi:service-assembly/jbi:identification/jbi:name";
    private String JBIXML = "META-INF/jbi.xml";
    private final JBIDeployer deployer = new JBIDeployer();
    private static final Logger sLogger = AutoDeployControllerImpl.sLogger;
    private static final StringManager localStrings = StringManager.getManager(AutoDeployer.class);

    private JBIAutoDeployer() {
    }

    static JBIAutoDeployer getInstance() {
        return jad;
    }

    JBIDeployer getDeployer() {
        return this.deployer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isJbiArchive(File file) throws AutoDeploymentException {
        ZipFile jf = null;
        try {
            String name = file.getName();
            String fileType = name.substring(name.lastIndexOf(".") + 1);
            if ("class".equals(fileType)) {
                boolean bl = false;
                return bl;
            }
            jf = new JarFile(file);
            boolean bl = ((JarFile)jf).getEntry(this.JBIXML) != null;
            return bl;
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.autodeploy.sa_invalid", file);
            sLogger.log(Level.FINE, msg, e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (jf != null) {
                    jf.close();
                }
            }
            catch (Exception e) {
                e.hashCode();
            }
        }
    }

    String getServiceAssemblyName(File file) throws AutoDeploymentException {
        JarFile jf = null;
        try {
            String saName;
            jf = new JarFile(file);
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setNamespaceContext(this.getJbiNSContext());
            String string = saName = xPath.evaluate(SA_NAME_PATH, new InputSource(jf.getInputStream(jf.getEntry(this.JBIXML))));
            return string;
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.autodeploy.sa_invalid", file);
            sLogger.log(Level.INFO, msg, e);
            throw new AutoDeploymentException(msg, e);
        }
        finally {
            try {
                jf.close();
            }
            catch (Exception e) {}
        }
    }

    private NamespaceContext getJbiNSContext() {
        return new NamespaceContext(){

            public String getNamespaceURI(String prefix) {
                if (prefix.equals("jbi")) {
                    return "http://java.sun.com/xml/ns/jbi";
                }
                return null;
            }

            public String getPrefix(String uri) {
                return null;
            }

            public Iterator getPrefixes(String uri) {
                return null;
            }
        };
    }

    File getStatusFile(File file, File statDir) {
        File jbiStatDir = new File(statDir, JBI_STATUS_DIR);
        File fStatDir = AutoDeployedFilesManager.obtainFileStatusDir(file, jbiStatDir, statDir.getParentFile());
        String saName = null;
        if (file.exists()) {
            try {
                if (this.isJbiArchive(file)) {
                    saName = this.getServiceAssemblyName(file);
                }
            }
            catch (Exception e) {
                sLogger.log(Level.FINE, e.getMessage(), e);
            }
        } else {
            saName = this.__getServiceAssemblyName(fStatDir, file);
        }
        if (saName == null) {
            return null;
        }
        return new File(fStatDir, file.getName() + DELIMITER + saName);
    }

    String getServiceAssemblyName(File file, File autodeployDir) {
        try {
            File statDir = new File(autodeployDir, ".autodeploystatus");
            if (statDir.getParentFile() == null) {
                return null;
            }
            File jbiStatDir = new File(statDir, JBI_STATUS_DIR);
            File fStatDir = AutoDeployedFilesManager.obtainFileStatusDir(file, jbiStatDir, statDir.getParentFile());
            return this.__getServiceAssemblyName(fStatDir, file);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String __getServiceAssemblyName(File fStatDir, File file) {
        File[] stFiles = fStatDir.listFiles(new ServiceAssemblyFinder(file));
        if (stFiles == null || stFiles.length == 0) {
            return null;
        }
        String[] splitNames = stFiles[0].getName().split(file.getName() + DELIMITER, 2);
        return splitNames[1];
    }

    class ServiceAssemblyFinder
    implements FilenameFilter {
        File saFile = null;

        ServiceAssemblyFinder(File f) {
            this.saFile = f;
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(this.saFile.getName() + JBIAutoDeployer.DELIMITER);
        }
    }
}

