/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.MdbContainer;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.inflow.MdbContainerProps;
import com.sun.enterprise.connectors.system.MQAddressList;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.zip.ZipFile;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmsRaUtil {
    private final String MQ_RAR = "imqjmsra.rar";
    private final String SYSTEM_APP_DIR = "lib" + File.separator + "install" + File.separator + "applications";
    private final String MQ_RAR_MANIFEST = "jmsra" + File.separator + "META-INF" + File.separator + "MANIFEST.MF";
    private final String MANIFEST_TAG = "Implementation-Version";
    private static final String propName_reconnect_delay_in_seconds = "reconnect-delay-in-seconds";
    private static final String propName_reconnect_max_retries = "reconnect-max-retries";
    private static final String propName_reconnect_enabled = "reconnect-enabled";
    private static final int DEFAULT_RECONNECT_DELAY = 60;
    private static final int DEFAULT_RECONNECT_RETRIES = 60;
    private static final String propName_cmt_max_runtime_exceptions = "cmt-max-runtime-exceptions";
    private static final int DEFAULT_CMT_MAX_RUNTIME_EXCEPTIONS = 1;
    private static final String ENABLE_AUTO_CLUSTERING = "com.sun.enterprise.connectors.system.enableAutoClustering";
    private int cmtMaxRuntimeExceptions = 1;
    private int reconnectDelayInSeconds = 60;
    private int reconnectMaxRetries = 60;
    private boolean reconnectEnabled = false;
    ServerContext sc = null;
    ConfigContext ctx = null;
    JmsService js = null;
    MQAddressList list = null;
    static Logger _mdblogger = LogDomains.getLogger("javax.enterprise.system.container.ejb.mdb");
    static Logger _rarlogger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public JmsRaUtil() throws ConnectorRuntimeException {
        this(null);
    }

    public JmsRaUtil(JmsService js) throws ConnectorRuntimeException {
        try {
            if (js != null) {
                this.js = js;
            } else {
                this.sc = ApplicationServer.getServerContext();
                this.ctx = this.sc.getConfigContext();
                this.js = ServerBeansFactory.getJmsServiceBean(this.ctx);
            }
            this.list = new MQAddressList(this.js);
        }
        catch (ConfigException ce) {
            throw JmsRaUtil.handleException(ce);
        }
    }

    public void setupAddressList() throws ConnectorRuntimeException {
        try {
            this.list.setup();
        }
        catch (Exception e) {
            throw JmsRaUtil.handleException(e);
        }
    }

    public String getUrl() {
        try {
            return this.list.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isClustered() throws ConnectorRuntimeException {
        try {
            ConfigContext ctxt = ApplicationServer.getServerContext().getConfigContext();
            return JmsRaUtil.enableClustering() && ServerHelper.isServerClustered(ctxt, ApplicationServer.getServerContext().getInstanceName());
        }
        catch (Exception e) {
            throw JmsRaUtil.handleException(e);
        }
    }

    private static boolean enableClustering() {
        try {
            String enablecluster = System.getProperty(ENABLE_AUTO_CLUSTERING);
            _rarlogger.log(Level.FINE, "Sun MQ Auto cluster system property" + enablecluster);
            if (enablecluster != null && enablecluster.trim().equals("false")) {
                _rarlogger.log(Level.FINE, "Disabling Sun MQ Auto Clustering");
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        _rarlogger.log(Level.FINE, "Enabling Sun MQ Auto Clustering");
        return true;
    }

    public String getJMSServiceType() {
        return this.js.getType();
    }

    public MQAddressList getUrlList() {
        return this.list;
    }

    public boolean getReconnectEnabled() {
        return this.js.isReconnectEnabled();
    }

    public String getReconnectInterval() {
        return this.js.getReconnectIntervalInSeconds();
    }

    public String getReconnectAttempts() {
        return this.js.getReconnectAttempts();
    }

    public String getAddressListIterations() {
        return this.js.getAddresslistIterations();
    }

    public String getAddressListBehaviour() {
        return this.js.getAddresslistBehavior();
    }

    public void setMdbContainerProperties() {
        ElementProperty[] props;
        MdbContainer mdbc;
        block18: {
            mdbc = null;
            try {
                ServerContext sc = ApplicationServer.getServerContext();
                mdbc = ServerBeansFactory.getMdbContainerBean(sc.getConfigContext());
            }
            catch (Exception e) {
                _mdblogger.log(Level.WARNING, "containers.mdb.config_exception", new Object[]{e.getMessage()});
                if (!_mdblogger.isLoggable(Level.FINE)) break block18;
                _mdblogger.log(Level.FINE, e.getClass().getName(), e);
            }
        }
        if (mdbc != null && (props = mdbc.getElementProperty()) != null) {
            for (int i = 0; i < props.length; ++i) {
                String name;
                ElementProperty p = props[i];
                if (p == null || (name = p.getName()) == null) continue;
                try {
                    if (name.equals(propName_reconnect_enabled)) {
                        if (p.getValue() == null) continue;
                        this.reconnectEnabled = Boolean.valueOf(p.getValue());
                        continue;
                    }
                    if (name.equals(propName_reconnect_delay_in_seconds)) {
                        try {
                            this.reconnectDelayInSeconds = Integer.parseInt(p.getValue());
                        }
                        catch (Exception e) {
                            _mdblogger.log(Level.WARNING, "containers.mdb.config_exception", new Object[]{e.getMessage()});
                        }
                        continue;
                    }
                    if (name.equals(propName_reconnect_max_retries)) {
                        try {
                            this.reconnectMaxRetries = Integer.parseInt(p.getValue());
                        }
                        catch (Exception e) {
                            _mdblogger.log(Level.WARNING, "containers.mdb.config_exception", new Object[]{e.getMessage()});
                        }
                        continue;
                    }
                    if (!name.equals(propName_cmt_max_runtime_exceptions)) continue;
                    try {
                        this.cmtMaxRuntimeExceptions = Integer.parseInt(p.getValue());
                    }
                    catch (Exception e) {
                        _mdblogger.log(Level.WARNING, "containers.mdb.config_exception", new Object[]{e.getMessage()});
                    }
                    continue;
                }
                catch (Exception e) {
                    _mdblogger.log(Level.WARNING, "containers.mdb.config_exception", new Object[]{e.getMessage()});
                    if (!_mdblogger.isLoggable(Level.FINE)) continue;
                    _mdblogger.log(Level.FINE, e.getClass().getName(), e);
                }
            }
        }
        if (this.reconnectDelayInSeconds < 0) {
            this.reconnectDelayInSeconds = 60;
        }
        if (this.reconnectMaxRetries < 0) {
            this.reconnectMaxRetries = 60;
        }
        if (_mdblogger.isLoggable(Level.FINE)) {
            _mdblogger.log(Level.FINE, "reconnect-delay-in-seconds=" + this.reconnectDelayInSeconds + ", " + propName_reconnect_max_retries + "=" + this.reconnectMaxRetries + ", " + propName_reconnect_enabled + "=" + this.reconnectEnabled);
        }
        MdbContainerProps.setReconnectDelay(this.reconnectDelayInSeconds);
        MdbContainerProps.setReconnectMaxRetries(this.reconnectMaxRetries);
        MdbContainerProps.setReconnectEnabled(this.reconnectEnabled);
        MdbContainerProps.setMaxRuntimeExceptions(this.cmtMaxRuntimeExceptions);
    }

    public void configureDescriptor(ConnectorDescriptor cd) {
        Object[] envProps = cd.getConfigProperties().toArray();
        for (int i = 0; i < envProps.length; ++i) {
            String userValue;
            EnvironmentProperty envProp = (EnvironmentProperty)envProps[i];
            String name = envProp.getName();
            if (!name.equals("ConnectionURL") || (userValue = this.getUrl()) == null) continue;
            cd.removeConfigProperty(envProp);
            cd.addConfigProperty(new EnvironmentProperty(name, userValue, userValue, envProp.getType()));
        }
    }

    public void upgradeIfNecessary() {
        String installedMqVersion = null;
        String deployedMqVersion = null;
        try {
            installedMqVersion = this.getInstalledMqVersion();
            _rarlogger.log(Level.FINE, "installedMQVersion :: " + installedMqVersion);
            deployedMqVersion = this.getDeployedMqVersion();
            _rarlogger.log(Level.FINE, "deployedMQVersion :: " + deployedMqVersion);
        }
        catch (Exception e) {
            return;
        }
        String deployed_dir = System.getProperty("com.sun.aas.installRoot") + File.separator + this.SYSTEM_APP_DIR + File.separator + "jmsra";
        if (!installedMqVersion.equals(deployedMqVersion)) {
            try {
                _rarlogger.log(Level.INFO, "jmsra.upgrade_started");
                ZipFile rarFile = new ZipFile(System.getProperty("com.sun.aas.imqLib") + File.separator + "imqjmsra.rar", deployed_dir);
                rarFile.explode();
                _rarlogger.log(Level.INFO, "jmsra.upgrade_completed");
            }
            catch (ZipFileException ze) {
                _rarlogger.log(Level.SEVERE, "jmsra.upgrade_failed", ze.getMessage());
            }
        }
    }

    private String getInstalledMqVersion() throws Exception {
        String ver = null;
        String installed_dir = System.getProperty("com.sun.aas.imqLib");
        String jarFile = installed_dir + File.separator + "imqjmsra.rar";
        _rarlogger.log(Level.FINE, "Installed MQ JAR " + jarFile);
        JarFile jFile = null;
        try {
            jFile = new File(jarFile).exists() ? new JarFile(jarFile) : new JarFile(installed_dir + File.separator + ".." + File.separator + "imqjmsra.rar");
            Manifest mf = jFile.getManifest();
            ver = mf.getMainAttributes().getValue("Implementation-Version");
            return ver;
        }
        catch (Exception e) {
            _rarlogger.log(Level.WARNING, "jmsra.upgrade_check_failed", e.getMessage() + ":" + jarFile);
            throw e;
        }
    }

    private String getDeployedMqVersion() throws Exception {
        String ver = null;
        String deployed_dir = System.getProperty("com.sun.aas.installRoot") + File.separator + this.SYSTEM_APP_DIR;
        String manifestFile = deployed_dir + File.separator + this.MQ_RAR_MANIFEST;
        _rarlogger.log(Level.FINE, "Deployed MQ version Manifest file" + manifestFile);
        try {
            Manifest mf = new Manifest(new FileInputStream(manifestFile));
            ver = mf.getMainAttributes().getValue("Implementation-Version");
            return ver;
        }
        catch (Exception e) {
            _rarlogger.log(Level.WARNING, "jmsra.upgrade_check_failed", e.getMessage() + ":" + manifestFile);
            throw e;
        }
    }

    private static ConnectorRuntimeException handleException(Exception e) {
        ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
        cre.initCause(e);
        return cre;
    }
}

