/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.system;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JmsAvailability;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.connectors.ActiveInboundResourceAdapter;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.inflow.MdbContainerProps;
import com.sun.enterprise.connectors.system.MQAddressList;
import com.sun.enterprise.connectors.system.MQAdministrator;
import com.sun.enterprise.connectors.util.JmsRaUtil;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.instance.ServerManager;
import com.sun.enterprise.jms.IASJmsUtil;
import com.sun.enterprise.jms.JmsProviderLifecycle;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.Naming;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;

public class ActiveJmsResourceAdapter
extends ActiveInboundResourceAdapter {
    static Logger logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private final String SETTER = "setProperty";
    private static final String SEPARATOR = "#";
    private static final String MQ_PASS_FILE_PREFIX = "asmq";
    private static final String MQ_PASS_FILE_KEY = "imq.imqcmd.password=";
    public static final String CONNECTION_URL = "ConnectionURL";
    private final String RECONNECTENABLED = "ReconnectEnabled";
    private final String RECONNECTINTERVAL = "ReconnectInterval";
    private final String RECONNECTATTEMPTS = "ReconnectAttempts";
    private static final String GROUPNAME = "GroupName";
    private static final String CLUSTERCONTAINER = "InClusteredContainer";
    public static final String BROKERTYPE = "BrokerType";
    private static final String BROKERINSTANCENAME = "BrokerInstanceName";
    private static final String BROKERBINDADDRESS = "BrokerBindAddress";
    private static final String BROKERPORT = "BrokerPort";
    private static final String BROKERARGS = "BrokerArgs";
    private static final String BROKERHOMEDIR = "BrokerHomeDir";
    private static final String BROKERLIBDIR = "BrokerLibDir";
    private static final String BROKERVARDIR = "BrokerVarDir";
    private static final String BROKERJAVADIR = "BrokerJavaDir";
    private static final String BROKERSTARTTIMEOUT = "BrokerStartTimeOut";
    public static final String ADMINUSERNAME = "AdminUsername";
    public static final String ADMINPASSWORD = "AdminPassword";
    private static final String ADMINPASSFILE = "AdminPassFile";
    private static final String USERNAME = "UserName";
    private static final String PASSWORD = "Password";
    private static final String MASTERBROKER = "MasterBroker";
    private static final String JMXSERVICEURL = "JMXServiceURL";
    private static final String JMXSERVICEURLLIST = "JMXServiceURLList";
    private static final String JMXCONNECTORENV = "JMXConnectorEnv";
    private static final String USEJNDIRMISERVICEURL = "useJNDIRMIServiceURL";
    private static final String RMIREGISTRYPORT = "RmiRegistryPort";
    private static final String USEEXTERNALRMIREGISTRY = "startRMIRegistry";
    private static final int DEFAULTRMIREGISTRYPORT = 7776;
    private static final int BROKERRMIPORTOFFSET = 100;
    private static final String SSLJMXCONNECTOR = "SslJMXConnector";
    private static final String HAREQUIRED = "HARequired";
    private static final String CLUSTERID = "ClusterId";
    private static final String BROKERID = "BrokerId";
    private static final String PINGINTERVAL = "PingInterval";
    private static final String DBTYPE = "DBType";
    private static final String DBTYPE_HADB = "hadb";
    private static final String BROKERENABLEHA = "BrokerEnableHA";
    private static final String DB_HADB_PROPS = "DBProps";
    private static final String DB_HADB_USER = "hadb.user";
    private static final String DB_HADB_PASSWORD = "hadb.password";
    private static final String DB_HADB_DRIVERCLASS = "hadb.driverClass";
    private static final String DS_HADB_PROPS = "DSProps";
    private static final String DS_HADB_SERVERLIST = "hadb.serverList";
    private final String CONTAINER = "InAppClientContainer";
    public static final String DESTINATION = "Destination";
    public static final String DESTINATION_TYPE = "DestinationType";
    private static String SUBSCRIPTION_NAME = "SubscriptionName";
    private static String CLIENT_ID = "ClientID";
    public static final String PHYSICAL_DESTINATION = "Name";
    private static String MAXPOOLSIZE = "EndpointPoolMaxSize";
    private static String MINPOOLSIZE = "EndpointPoolSteadySize";
    private static String RESIZECOUNT = "EndpointPoolResizeCount";
    private static String RESIZETIMEOUT = "EndpointPoolResizeTimeout";
    private static String REDELIVERYCOUNT = "EndpointExceptionRedeliveryAttempts";
    private static String LOWERCASE_REDELIVERYCOUNT = "endpointExceptionRedeliveryAttempts";
    public static final String ADDRESSLIST = "AddressList";
    private static String ADRLIST_BEHAVIOUR = "AddressListBehavior";
    private static String ADRLIST_ITERATIONS = "AddressListIterations";
    private static final String MDBIDENTIFIER = "MdbName";
    private static final String MCFADDRESSLIST = "MessageServiceAddressList";
    private StringManager sm = StringManager.getManager(ActiveJmsResourceAdapter.class);
    private MQAddressList urlList = null;
    private String addressList;
    private String brkrPort;
    private static final String DUSERNAME = "User";
    private static final String DPASSWORD = "Password";
    private static final String DSERVERLIST = "ServerList";
    private static final String HADB_CONNECTION_URL_PREFIX = "jdbc:sun:hadb:";
    public static final String EMBEDDED = "EMBEDDED";
    public static final String LOCAL = "LOCAL";
    public static final String REMOTE = "REMOTE";
    public static final String DIRECT = "DIRECT";
    private final String DEFAULT_STORE_POOL_JNDI_NAME = "jdbc/hastore";
    private static String MQRmiPort = System.getProperty("com.sun.enterprise.connectors.system.MQRmiPort");
    private static final String DASRMIPORT = "31099";
    private static final String REVERT_TO_EMBEDDED_PROPERTY = "com.sun.enterprise.connectors.system.RevertToEmbedded";
    private static final String BROKER_RMI_PORT = "com.sun.enterprise.connectors.system.mq.rmiport";
    private Properties dbProps = null;
    private Properties dsProps = null;
    private String brokerInstanceName = null;
    private File mqPassFile = null;

    public ActiveJmsResourceAdapter(ResourceAdapter ra, ConnectorDescriptor desc, String moduleName, ClassLoader jcl) throws ConnectorRuntimeException {
        super(ra, desc, moduleName, jcl);
        if (this.mqPassFile != null) {
            this.mqPassFile.delete();
        }
    }

    protected void loadRAConfiguration() throws ConnectorRuntimeException {
        if (ConnectorRuntime.getRuntime().getEnviron() == 1) {
            try {
                if (!JmsProviderLifecycle.shouldUseMQRAForLifecycleControl()) {
                    JmsProviderLifecycle.checkProviderStartup();
                } else {
                    this.setLifecycleProperties();
                }
            }
            catch (Exception e) {
                ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
                throw (ConnectorRuntimeException)cre.initCause(e);
            }
            this.setMdbContainerProperties();
            this.setJmsServiceProperties(null);
            this.setClusterRABeanProperties();
            this.setAvailabilityProperties();
        } else {
            this.setAppClientRABeanProperties();
        }
        super.loadRAConfiguration();
        this.postRAConfiguration();
    }

    private void setAvailabilityProperties() throws ConnectorRuntimeException {
        try {
            ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
            AvailabilityService as = ServerBeansFactory.getConfigBean(ctx).getAvailabilityService();
            if (as == null) {
                ActiveJmsResourceAdapter.logFine("Availability Service is null. Not setting HA attributes");
                return;
            }
            if (this.isJMSAvailabilityOn(as)) {
                ConnectorDescriptor cd = this.getDescriptor();
                EnvironmentProperty envProp1 = new EnvironmentProperty(HAREQUIRED, "true", "HA Required", "java.lang.String");
                this.setProperty(cd, envProp1);
                JmsService jmsService = ServerBeansFactory.getConfigBean(ctx).getJmsService();
                if (ActiveJmsResourceAdapter.isClustered()) {
                    if (jmsService.getType().equals(REMOTE)) {
                        return;
                    }
                    String clusterName = this.getMQClusterName();
                    EnvironmentProperty envProp2 = new EnvironmentProperty(CLUSTERID, clusterName, "Cluster Id", "java.lang.String");
                    this.setProperty(cd, envProp2);
                    if (this.brokerInstanceName == null) {
                        this.brokerInstanceName = ActiveJmsResourceAdapter.getBrokerInstanceName(jmsService);
                    }
                    EnvironmentProperty envProp3 = new EnvironmentProperty(BROKERID, this.brokerInstanceName, "Broker Id", "java.lang.String");
                    this.setProperty(cd, envProp3);
                    EnvironmentProperty envProp4 = new EnvironmentProperty(DBTYPE, DBTYPE_HADB, DBTYPE, "java.lang.String");
                    this.setProperty(cd, envProp4);
                    EnvironmentProperty envProp5 = new EnvironmentProperty(BROKERENABLEHA, "true", "BrokerEnableHA flag", "java.lang.Boolean");
                    this.setProperty(cd, envProp5);
                    String poolJNDIName = as.getJmsAvailability().getMqStorePoolName();
                    if (poolJNDIName == null || poolJNDIName == "") {
                        poolJNDIName = as.getWebContainerAvailability().getHttpSessionStorePoolName();
                        ActiveJmsResourceAdapter.logFine("HTTP Session store pool jndi name is " + poolJNDIName);
                    }
                    JdbcConnectionPool jdbcConPool = this.getJDBCConnectionPoolInfo(poolJNDIName);
                    String userName = this.getPropertyFromPool(jdbcConPool, DUSERNAME);
                    ActiveJmsResourceAdapter.logFine("HA username is " + userName);
                    String password = this.getPropertyFromPool(jdbcConPool, "Password");
                    ActiveJmsResourceAdapter.logFine("HA Password is " + password);
                    String driverClass = jdbcConPool.getDatasourceClassname();
                    ActiveJmsResourceAdapter.logFine("HA driverclass" + driverClass);
                    this.dbProps = new Properties();
                    this.dbProps.setProperty(DB_HADB_USER, userName);
                    this.dbProps.setProperty(DB_HADB_PASSWORD, password);
                    this.dbProps.setProperty(DB_HADB_DRIVERCLASS, driverClass);
                    String serverList = this.getPropertyFromPool(jdbcConPool, DSERVERLIST);
                    ActiveJmsResourceAdapter.logFine("HADB server list is " + serverList);
                    this.dsProps = new Properties();
                    if (serverList != null) {
                        this.dsProps.setProperty(DS_HADB_SERVERLIST, serverList);
                    } else {
                        logger.warning("ajra.incorrect_hadb_server_list");
                    }
                    Properties p = this.getDSPropertiesFromThePool(jdbcConPool);
                    for (String string : p.keySet()) {
                        String val = (String)p.get(string);
                        this.dsProps.setProperty(string, val);
                    }
                } else {
                    ActiveJmsResourceAdapter.logFine("Instance not clustered. Not setting HA attributes");
                }
            }
        }
        catch (ConfigException e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause(e);
        }
    }

    private Properties getDSPropertiesFromThePool(JdbcConnectionPool jdbcConPool) {
        Properties p = new Properties();
        ElementProperty[] elemProp = jdbcConPool.getElementProperty();
        HashSet<String> excludeList = new HashSet<String>();
        excludeList.add(DUSERNAME);
        excludeList.add("Password");
        excludeList.add(DSERVERLIST);
        for (ElementProperty e : elemProp) {
            String propName = e.getAttributeValue("name");
            if (excludeList.contains(propName)) continue;
            p.setProperty(propName, e.getAttributeValue("value"));
        }
        ActiveJmsResourceAdapter.logFine("Additional DataSource properties from pool " + jdbcConPool.getName() + " are " + p);
        return p;
    }

    protected void postRAConfiguration() throws ConnectorRuntimeException {
        try {
            if (this.dbProps != null) {
                Method[] mthds = this.resourceadapter_.getClass().getMethods();
                for (int i = 0; i < mthds.length; ++i) {
                    if (mthds[i].getName().equalsIgnoreCase("setDBProps")) {
                        ActiveJmsResourceAdapter.logFine("Setting property:DBProps=" + this.dbProps.toString());
                        mthds[i].invoke((Object)this.resourceadapter_, this.dbProps);
                        continue;
                    }
                    if (!mthds[i].getName().equalsIgnoreCase("setDSProps")) continue;
                    ActiveJmsResourceAdapter.logFine("Setting property:DSProps=" + this.dsProps.toString());
                    mthds[i].invoke((Object)this.resourceadapter_, this.dsProps);
                }
            }
        }
        catch (Exception e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause(e);
        }
    }

    private String getPropertyFromPool(JdbcConnectionPool jdbcConPool, String poolPropertyName) {
        String poolPropertyValue = null;
        if (jdbcConPool == null) {
            return null;
        }
        ElementProperty[] props = jdbcConPool.getElementProperty();
        for (int i = 0; i < props.length; ++i) {
            String name = props[i].getAttributeValue("name");
            String value = props[i].getAttributeValue("value");
            if (!name.equalsIgnoreCase(poolPropertyName)) continue;
            poolPropertyValue = value;
        }
        ActiveJmsResourceAdapter.logFine("ActiveJMSResourceAdapter :: got property " + poolPropertyName + "=" + poolPropertyValue);
        return poolPropertyValue;
    }

    private JdbcConnectionPool getJDBCConnectionPoolInfo(String poolJndiName) throws ConfigException {
        return ResourcesUtil.createInstance().getJDBCPoolForResource(poolJndiName);
    }

    private boolean isJMSAvailabilityOn(AvailabilityService as) {
        if (as == null) {
            return false;
        }
        boolean asAvailability = as.isAvailabilityEnabled();
        JmsAvailability ja = as.getJmsAvailability();
        boolean jmsAvailability = false;
        if (ja != null) {
            jmsAvailability = ja.isAvailabilityEnabled();
        }
        ActiveJmsResourceAdapter.logFine("JMS availability :: " + (jmsAvailability && asAvailability));
        return jmsAvailability && asAvailability;
    }

    private void setLifecycleProperties() throws ConfigException, ConnectorRuntimeException {
        ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
        JmsService jmsService = ServerBeansFactory.getJmsServiceBean(ctx);
        String defaultJmsHost = jmsService.getDefaultJmsHost();
        ActiveJmsResourceAdapter.logFine("Default JMS Host :: " + defaultJmsHost);
        JmsHost jmsHost = null;
        jmsHost = defaultJmsHost == null || defaultJmsHost.equals("") ? ServerBeansFactory.getJmsHostBean(ctx) : jmsService.getJmsHostByName(defaultJmsHost);
        if (jmsHost != null && jmsHost.isEnabled()) {
            String adminPassFilePath;
            String brokerPort;
            JavaConfig javaConfig = ServerBeansFactory.getJavaConfigBean(ctx);
            String java_home = javaConfig.getJavaHome();
            String brokerType = this.adjustForDirectMode(jmsService.getType());
            this.brkrPort = brokerPort = jmsHost.getPort();
            String adminUserName = jmsHost.getAdminUserName();
            String adminPassword = jmsHost.getAdminPassword();
            ElementProperty[] jmsHostProps = jmsService.getElementProperty();
            String username = null;
            String password = null;
            if (jmsHostProps != null) {
                for (int i = 0; i < jmsHostProps.length; ++i) {
                    String propName = jmsHostProps[i].getName();
                    String propValue = jmsHostProps[i].getValue();
                    if ("user-name".equals(propName)) {
                        username = propValue;
                        continue;
                    }
                    if (!"password".equals(propName)) continue;
                    password = propValue;
                }
            }
            ActiveJmsResourceAdapter.logFine("Broker UserName = " + username);
            this.createMQVarDirectoryIfNecessary();
            String brokerVarDir = this.getMQVarDir();
            String tmpString = jmsService.getStartArgs();
            if (tmpString == null) {
                tmpString = "";
            }
            String brokerArgs = tmpString;
            ElementProperty[] jmsProperties = jmsService.getElementProperty();
            String brokerHomeDir = this.getBrokerHomeDir();
            String brokerLibDir = this.getBrokerLibDir();
            if (this.brokerInstanceName == null) {
                this.brokerInstanceName = ActiveJmsResourceAdapter.getBrokerInstanceName(jmsService);
            }
            long brokerTimeOut = this.getBrokerTimeOut(jmsService);
            ConnectorDescriptor cd = this.getDescriptor();
            EnvironmentProperty envProp1 = new EnvironmentProperty(BROKERTYPE, brokerType, "Broker Type", "java.lang.String");
            this.setProperty(cd, envProp1);
            EnvironmentProperty envProp2 = new EnvironmentProperty(BROKERINSTANCENAME, this.brokerInstanceName, "Broker Instance Name", "java.lang.String");
            this.setProperty(cd, envProp2);
            EnvironmentProperty envProp3 = new EnvironmentProperty(BROKERPORT, brokerPort, "Broker Port", "java.lang.String");
            this.setProperty(cd, envProp3);
            EnvironmentProperty envProp4 = new EnvironmentProperty(BROKERARGS, brokerArgs, "Broker Args", "java.lang.String");
            this.setProperty(cd, envProp4);
            EnvironmentProperty envProp5 = new EnvironmentProperty(BROKERHOMEDIR, brokerHomeDir, "Broker Home Dir", "java.lang.String");
            this.setProperty(cd, envProp5);
            EnvironmentProperty envProp14 = new EnvironmentProperty(BROKERLIBDIR, brokerLibDir, "Broker Lib Dir", "java.lang.String");
            this.setProperty(cd, envProp14);
            EnvironmentProperty envProp6 = new EnvironmentProperty(BROKERJAVADIR, java_home, "Broker Java Dir", "java.lang.String");
            this.setProperty(cd, envProp6);
            EnvironmentProperty envProp7 = new EnvironmentProperty(BROKERVARDIR, brokerVarDir, "Broker Var Dir", "java.lang.String");
            this.setProperty(cd, envProp7);
            EnvironmentProperty envProp8 = new EnvironmentProperty(BROKERSTARTTIMEOUT, "" + brokerTimeOut, "Broker Start Timeout", "java.lang.String");
            this.setProperty(cd, envProp8);
            EnvironmentProperty envProp9 = new EnvironmentProperty(ADMINUSERNAME, adminUserName, "Broker admin username", "java.lang.String");
            this.setProperty(cd, envProp9);
            EnvironmentProperty envProp10 = new EnvironmentProperty(ADMINPASSWORD, adminPassword, "Broker admin password", "java.lang.String");
            this.setProperty(cd, envProp10);
            EnvironmentProperty envProp11 = new EnvironmentProperty(USERNAME, username, "Broker username", "java.lang.String");
            this.setProperty(cd, envProp11);
            EnvironmentProperty envProp12 = new EnvironmentProperty("Password", password, "Broker password", "java.lang.String");
            this.setProperty(cd, envProp12);
            if (!jmsService.getType().equals(REMOTE) && (adminPassFilePath = this.getAdminPassFilePath(adminPassword)) != null) {
                EnvironmentProperty envProp13 = new EnvironmentProperty(ADMINPASSFILE, adminPassFilePath, "Broker admin password", "java.lang.String");
                this.setProperty(cd, envProp13);
            }
        }
    }

    private String getAdminPassFilePath(String adminPassword) {
        try {
            this.mqPassFile = File.createTempFile(MQ_PASS_FILE_PREFIX, null);
            BufferedWriter out = new BufferedWriter(new FileWriter(this.mqPassFile));
            out.write(MQ_PASS_FILE_KEY + adminPassword);
            out.newLine();
            out.flush();
            out.close();
            return this.mqPassFile.getCanonicalPath();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException while creating MQ admin pass file" + e.getMessage());
            return null;
        }
    }

    private String adjustForDirectMode(String brokerType) {
        if (brokerType.equals(EMBEDDED)) {
            String revertToEmbedded = System.getProperty(REVERT_TO_EMBEDDED_PROPERTY);
            if (revertToEmbedded != null && revertToEmbedded.equals("true")) {
                return EMBEDDED;
            }
            return DIRECT;
        }
        return brokerType;
    }

    private long getBrokerTimeOut(JmsService jmsService) {
        long defaultTimeout;
        long timeout = defaultTimeout = 30000L;
        String specifiedTimeOut = jmsService.getInitTimeoutInSeconds();
        if (specifiedTimeOut != null) {
            timeout = Integer.parseInt(specifiedTimeOut) * 1000;
        }
        return timeout;
    }

    public static String getBrokerInstanceName(JmsService js) throws ConfigException, ConnectorRuntimeException {
        String asInstance = ApplicationServer.getServerContext().getInstanceName();
        String domainName = null;
        domainName = ActiveJmsResourceAdapter.isClustered() ? ClusterHelper.getClusterForInstance(ApplicationServer.getServerContext().getConfigContext(), asInstance).getName() : ServerManager.instance().getDomainName();
        String s = IASJmsUtil.getBrokerInstanceName(domainName, asInstance, js);
        ActiveJmsResourceAdapter.logFine("IASJMSUtil gave broker Instancename as " + s);
        String converted = ActiveJmsResourceAdapter.convertStringToValidMQIdentifier(s);
        ActiveJmsResourceAdapter.logFine("converted instance name " + converted);
        return converted;
    }

    private void createMQVarDirectoryIfNecessary() {
        String asInstanceRoot = ApplicationServer.getServerContext().getInstanceEnvironment().getInstancesRoot();
        String mqInstanceDir = asInstanceRoot + File.separator + "imq";
        File instanceDir = new File(mqInstanceDir);
        if (!instanceDir.exists() || !instanceDir.isDirectory()) {
            instanceDir.mkdirs();
        }
    }

    private String getMQVarDir() {
        String asInstanceRoot = ApplicationServer.getServerContext().getInstanceEnvironment().getInstancesRoot();
        String mqInstanceDir = asInstanceRoot + File.separator + "imq";
        return mqInstanceDir;
    }

    private String getBrokerLibDir() {
        String brokerLibDir = System.getProperty("com.sun.aas.imqLib");
        ActiveJmsResourceAdapter.logFine("broker lib dir from system property " + brokerLibDir);
        return brokerLibDir;
    }

    private String getBrokerHomeDir() {
        String brokerHomeDir = System.getProperty("com.sun.aas.imqBin");
        ActiveJmsResourceAdapter.logFine("broker home dir from system property " + brokerHomeDir);
        if (brokerHomeDir == null) {
            String IMQ_INSTALL_SUBDIR = File.separator + ".." + File.separator + ".." + File.separator + "imq";
            brokerHomeDir = ApplicationServer.getServerContext().getInstallRoot() + IMQ_INSTALL_SUBDIR;
        } else {
            brokerHomeDir = brokerHomeDir + File.separator + "..";
        }
        ActiveJmsResourceAdapter.logFine("Broker Home Directory :: " + brokerHomeDir);
        ActiveJmsResourceAdapter.logFine("broker home dir finally" + brokerHomeDir);
        return brokerHomeDir;
    }

    private void setClusterRABeanProperties() throws ConnectorRuntimeException {
        ConnectorDescriptor cd = super.getDescriptor();
        try {
            if (ActiveJmsResourceAdapter.isClustered()) {
                ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
                JmsService jmsService = ServerBeansFactory.getConfigBean(ctx).getJmsService();
                String val = this.getGroupName();
                EnvironmentProperty envProp = new EnvironmentProperty(GROUPNAME, val, "Group Name", "java.lang.String");
                this.setProperty(cd, envProp);
                EnvironmentProperty envProp1 = new EnvironmentProperty(CLUSTERCONTAINER, "true", "Cluster container flag", "java.lang.Boolean");
                this.setProperty(cd, envProp1);
                ActiveJmsResourceAdapter.logFine("CLUSTERED instance - setting groupname as" + val);
                if (jmsService.getType().equals(REMOTE)) {
                    return;
                }
                String masterbrkr = this.getMasterBroker();
                EnvironmentProperty envProp2 = new EnvironmentProperty(MASTERBROKER, masterbrkr, "Master  Broker", "java.lang.String");
                this.setProperty(cd, envProp2);
                ActiveJmsResourceAdapter.logFine("MASTERBROKER - setting master broker val" + masterbrkr);
            } else {
                ActiveJmsResourceAdapter.logFine("Instance not Clustered and hence not setting groupname");
            }
        }
        catch (ConfigException e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause(e);
        }
    }

    private void setAppClientRABeanProperties() throws ConnectorRuntimeException {
        ActiveJmsResourceAdapter.logFine("In Appclient container!!!");
        ConnectorDescriptor cd = super.getDescriptor();
        EnvironmentProperty envProp1 = new EnvironmentProperty(BROKERTYPE, REMOTE, "Broker Type", "java.lang.String");
        this.setProperty(cd, envProp1);
        EnvironmentProperty envProp2 = new EnvironmentProperty(GROUPNAME, "", "Group Name", "java.lang.String");
        cd.removeConfigProperty(envProp2);
        EnvironmentProperty envProp3 = new EnvironmentProperty(CLUSTERCONTAINER, "false", "Cluster flag", "java.lang.Boolean");
        this.setProperty(cd, envProp3);
    }

    private static boolean isClustered() throws ConnectorRuntimeException {
        return JmsRaUtil.isClustered();
    }

    private String getGroupName() throws ConfigException {
        return this.getDomainName() + SEPARATOR + this.getClusterName();
    }

    private String getClusterName() throws ConfigException {
        return ClusterHelper.getClusterForInstance(ApplicationServer.getServerContext().getConfigContext(), ApplicationServer.getServerContext().getInstanceName()).getName();
    }

    private String getMQClusterName() throws ConfigException {
        return ActiveJmsResourceAdapter.convertStringToValidMQIdentifier(this.getClusterName()) + "_MQ";
    }

    private String getMasterBroker() throws ConfigException {
        return this.urlList.getMasterBroker(this.getClusterName());
    }

    private static String convertStringToValidMQIdentifier(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isLetterOrDigit(s.charAt(i))) continue;
            buf.append(s.charAt(i));
        }
        return buf.toString();
    }

    private String getDomainName() throws ConfigException {
        ConfigContext ctxt = ApplicationServer.getServerContext().getConfigContext();
        return "";
    }

    public void reloadRA(JmsService js) throws ConnectorRuntimeException {
        this.setMdbContainerProperties();
        this.setJmsServiceProperties(js);
        super.loadRAConfiguration();
        this.rebindDescriptor();
    }

    public void addJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.addMQUrl(host);
        this.setAddressList();
    }

    public void deleteJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.removeMQUrl(host);
        this.setAddressList();
    }

    public void updateJmsHost(JmsHost host) throws ConnectorRuntimeException {
        this.urlList.updateMQUrl(host);
        this.setAddressList();
    }

    private void setMdbContainerProperties() throws ConnectorRuntimeException {
        JmsRaUtil raUtil = new JmsRaUtil(null);
        ConnectorDescriptor cd = super.getDescriptor();
        raUtil.setMdbContainerProperties();
        String val = "" + MdbContainerProps.getReconnectEnabled();
        EnvironmentProperty envProp2 = new EnvironmentProperty("ReconnectEnabled", val, val, "java.lang.Boolean");
        this.setProperty(cd, envProp2);
        val = "" + MdbContainerProps.getReconnectDelay();
        EnvironmentProperty envProp3 = new EnvironmentProperty("ReconnectInterval", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp3);
        val = "" + MdbContainerProps.getReconnectMaxRetries();
        EnvironmentProperty envProp4 = new EnvironmentProperty("ReconnectAttempts", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp4);
    }

    private void setAddressList() throws ConnectorRuntimeException {
        try {
            ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
            JmsService jmsService = ServerBeansFactory.getJmsServiceBean(ctx);
            this.setConnectionURL(jmsService, this.urlList);
        }
        catch (ConfigException e) {
            e.printStackTrace();
        }
        super.loadRAConfiguration();
    }

    private void setConnectionURL(JmsService jmsService, MQAddressList urlList) {
        ConnectorDescriptor cd = super.getDescriptor();
        String val = urlList.toString();
        if (val != null) {
            logger.info("JMS Service Connection URL is :" + val);
            EnvironmentProperty envProp1 = new EnvironmentProperty(CONNECTION_URL, val, val, "java.lang.String");
            this.setProperty(cd, envProp1);
        }
    }

    private void setJmsServiceProperties(JmsService service) throws ConnectorRuntimeException {
        JmsRaUtil jmsraUtil = new JmsRaUtil(service);
        jmsraUtil.setupAddressList();
        this.urlList = jmsraUtil.getUrlList();
        this.addressList = this.urlList.toString();
        ConnectorDescriptor cd = super.getDescriptor();
        this.setConnectionURL(service, this.urlList);
        String val = "" + jmsraUtil.getReconnectEnabled();
        EnvironmentProperty envProp2 = new EnvironmentProperty("ReconnectEnabled", val, val, "java.lang.Boolean");
        this.setProperty(cd, envProp2);
        int newval = new Integer(jmsraUtil.getReconnectInterval()) * 1000;
        val = "" + newval;
        EnvironmentProperty envProp3 = new EnvironmentProperty("ReconnectInterval", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp3);
        val = "" + jmsraUtil.getReconnectAttempts();
        EnvironmentProperty envProp4 = new EnvironmentProperty("ReconnectAttempts", val, val, "java.lang.Integer");
        this.setProperty(cd, envProp4);
        val = "" + jmsraUtil.getAddressListBehaviour();
        EnvironmentProperty envProp5 = new EnvironmentProperty(ADRLIST_BEHAVIOUR, val, val, "java.lang.String");
        this.setProperty(cd, envProp5);
        val = "" + jmsraUtil.getAddressListIterations();
        EnvironmentProperty envProp6 = new EnvironmentProperty(ADRLIST_ITERATIONS, val, val, "java.lang.Integer");
        this.setProperty(cd, envProp6);
        boolean useExternal = this.shouldUseExternalRmiRegistry(jmsraUtil);
        val = new Boolean(useExternal).toString();
        EnvironmentProperty envProp7 = new EnvironmentProperty(USEEXTERNALRMIREGISTRY, val, val, "java.lang.Boolean");
        this.setProperty(cd, envProp7);
        logger.log(Level.FINE, "Start RMI registry set as " + val);
        String configuredRmiRegistryPort = null;
        configuredRmiRegistryPort = !useExternal ? this.getRmiRegistryPort() : this.getUniqueRmiRegistryPort();
        val = configuredRmiRegistryPort;
        if (val != null) {
            EnvironmentProperty envProp8 = new EnvironmentProperty(RMIREGISTRYPORT, val, val, "java.lang.Integer");
            this.setProperty(cd, envProp8);
            logger.log(Level.FINE, "RMI registry port set as " + val);
        } else {
            logger.log(Level.WARNING, "Invalid RMI registry port");
        }
    }

    private boolean shouldUseExternalRmiRegistry(JmsRaUtil jmsraUtil) {
        boolean useExternalRmiRegistry = !this.isASRmiRegistryPortAvailable(jmsraUtil);
        return useExternalRmiRegistry;
    }

    private String getUniqueRmiRegistryPort() {
        int mqrmiport = 7776;
        try {
            String configuredport = System.getProperty(BROKER_RMI_PORT);
            mqrmiport = configuredport != null ? Integer.parseInt(configuredport) : Integer.parseInt(this.brkrPort) + 100;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "" + mqrmiport;
    }

    private String getRmiRegistryPort() {
        String val = null;
        if (MQRmiPort != null && !MQRmiPort.trim().equals("")) {
            return MQRmiPort;
        }
        String configuredPort = null;
        try {
            configuredPort = this.getConfiguredRmiRegistryPort();
        }
        catch (ConfigException ex) {
            logger.log(Level.WARNING, ex.getMessage());
            logger.log(Level.FINE, "Exception while getting configured rmi registry port", ex);
        }
        if (configuredPort != null) {
            return configuredPort;
        }
        if (ResourcesUtil.isDAS()) {
            return DASRMIPORT;
        }
        return val;
    }

    private String getConfiguredRmiRegistryHost() throws ConfigException {
        return this.getJmxConnector().getAddress();
    }

    private String getConfiguredRmiRegistryPort() throws ConfigException {
        return this.getJmxConnector().getPort();
    }

    private JmxConnector getJmxConnector() throws ConfigException {
        AdminService as = ServerBeansFactory.getConfigBean(ApplicationServer.getServerContext().getConfigContext()).getAdminService();
        return as.getJmxConnectorByName(as.getSystemJmxConnectorName());
    }

    private boolean isASRmiRegistryPortAvailable(JmsRaUtil jmsraUtil) {
        ActiveJmsResourceAdapter.logFine("isASRmiRegistryPortAvailable - JMSService Type:" + jmsraUtil.getJMSServiceType());
        if (jmsraUtil.getJMSServiceType().equals(REMOTE) || jmsraUtil.getJMSServiceType().equals(LOCAL)) {
            return false;
        }
        String name = null;
        try {
            name = "rmi://" + this.getConfiguredRmiRegistryHost() + ":" + this.getConfiguredRmiRegistryPort();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Attempting to list " + name);
            }
            String[] ss = Naming.list(name);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("List on " + name + " succeeded");
            }
            return true;
        }
        catch (Exception e) {
            logger.fine(e.getMessage() + " " + name);
            return false;
        }
    }

    private void setProperty(ConnectorDescriptor cd, EnvironmentProperty envProp) {
        cd.removeConfigProperty(envProp);
        cd.addConfigProperty(envProp);
    }

    private void rebindDescriptor() throws ConnectorRuntimeException {
        try {
            String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(super.getModuleName());
            Switch.getSwitch().getNamingManager().publishObject(descriptorJNDIName, (Object)super.getDescriptor(), true);
        }
        catch (NamingException ne) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(ne.getMessage());
            throw (ConnectorRuntimeException)cre.initCause(ne);
        }
    }

    public ManagedConnectionFactory[] createManagedConnectionFactories(ConnectorConnectionPool cpr, ClassLoader loader) {
        logger.log(Level.FINE, "RECOVERY : Entering createMCFS in AJMSRA");
        ArrayList<ManagedConnectionFactory> mcfs = new ArrayList<ManagedConnectionFactory>();
        if (this.getAddressListCount() < 2) {
            mcfs.add(this.createManagedConnectionFactory(cpr, loader));
            logger.log(Level.FINE, "Brokers are not clustered,So doing normal recovery");
        } else {
            ArrayList al = new ArrayList();
            String addlist = null;
            Set s = cpr.getConnectorDescriptorInfo().getMCFConfigProperties();
            for (EnvironmentProperty prop : s) {
                String propName = prop.getName();
                if (!propName.equalsIgnoreCase("imqAddressList") && !propName.equalsIgnoreCase("Addresslist")) continue;
                addlist = prop.getValue();
            }
            StringTokenizer tokenizer = null;
            tokenizer = addlist == null || addlist.trim().equalsIgnoreCase("localhost") ? new StringTokenizer(this.addressList, ",") : new StringTokenizer(addlist, ",");
            logger.log(Level.FINE, "No of addresses found " + tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                String brokerurl = tokenizer.nextToken();
                ManagedConnectionFactory mcf = super.createManagedConnectionFactory(cpr, loader);
                for (EnvironmentProperty prop : s) {
                    String propName = prop.getName();
                    String propValue = prop.getValue();
                    if (!propName.startsWith("imq") || propValue == "") continue;
                    try {
                        Method meth = mcf.getClass().getMethod("setProperty", String.class, String.class);
                        if (propName.trim().equalsIgnoreCase("imqAddressList")) {
                            meth.invoke((Object)mcf, prop.getName(), brokerurl);
                            continue;
                        }
                        meth.invoke((Object)mcf, prop.getName(), prop.getValueObject());
                    }
                    catch (NoSuchMethodException ex) {
                        logger.log(Level.WARNING, "no.such.method", new Object[]{"setProperty", mcf.getClass().getName()});
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "error.execute.method", new Object[]{"setProperty", mcf.getClass().getName()});
                    }
                }
                EnvironmentProperty addressProp3 = new EnvironmentProperty(ADDRESSLIST, brokerurl, "Address List", "java.lang.String");
                HashSet<EnvironmentProperty> addressProp = new HashSet<EnvironmentProperty>();
                addressProp.add(addressProp3);
                SetMethodAction setMethodAction = new SetMethodAction(mcf, addressProp);
                try {
                    setMethodAction.run();
                }
                catch (Exception e) {
                    // empty catch block
                }
                mcfs.add(mcf);
            }
        }
        return mcfs.toArray(new ManagedConnectionFactory[0]);
    }

    public ManagedConnectionFactory createManagedConnectionFactory(ConnectorConnectionPool cpr, ClassLoader loader) {
        ManagedConnectionFactory mcf = super.createManagedConnectionFactory(cpr, loader);
        if (mcf != null) {
            Set s = cpr.getConnectorDescriptorInfo().getMCFConfigProperties();
            for (EnvironmentProperty prop : s) {
                String propName = prop.getName();
                if (!propName.startsWith("imq") || prop.getValue() == "") continue;
                try {
                    Method meth = mcf.getClass().getMethod("setProperty", String.class, String.class);
                    meth.invoke((Object)mcf, prop.getName(), prop.getValueObject());
                }
                catch (NoSuchMethodException ex) {
                    logger.log(Level.WARNING, "no.such.method", new Object[]{"setProperty", mcf.getClass().getName()});
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "error.execute.method", new Object[]{"setProperty", mcf.getClass().getName()});
                }
            }
        }
        return mcf;
    }

    public void updateMDBRuntimeInfo(EjbMessageBeanDescriptor descriptor_, BeanPoolDescriptor poolDescriptor) throws ConnectorRuntimeException {
        String jndiName = descriptor_.getJndiName();
        if (jndiName == null) {
            logger.log(Level.SEVERE, "Missing Destination JNDI Name");
            String msg = this.sm.getString("ajra.error_in_dd");
            throw new RuntimeException(msg);
        }
        String resourceAdapterMid = "jmsra";
        descriptor_.setResourceAdapterMid(resourceAdapterMid);
        String destName = this.getPhysicalDestinationFromConfiguration(jndiName);
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION, destName, null));
        if (descriptor_.getDestinationType() != null && !"".equals(descriptor_.getDestinationType())) {
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION_TYPE, descriptor_.getDestinationType(), null));
        } else {
            try {
                ConfigBean[] cb = ResourcesUtil.createInstance().getEnabledAdminObjectResources("jmsra");
                for (int i = 0; i < cb.length; ++i) {
                    AdminObjectResource aor = (AdminObjectResource)cb[i];
                    if (!aor.getJndiName().equals(jndiName)) continue;
                    descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(DESTINATION_TYPE, aor.getResType(), null));
                    logger.log(Level.INFO, "endpoint.determine.destinationtype", new Object[]{aor.getResType(), aor.getJndiName(), descriptor_.getName()});
                }
            }
            catch (ConfigException e) {
                // empty catch block
            }
        }
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(SUBSCRIPTION_NAME, descriptor_.getDurableSubscriptionName(), null));
        String mdbCF = null;
        try {
            mdbCF = descriptor_.getIASEjbExtraDescriptors().getMdbConnectionFactory().getJndiName();
        }
        catch (NullPointerException ne) {
            // empty catch block
        }
        if (mdbCF != null && mdbCF != "") {
            this.setValuesFromConfiguration(mdbCF, descriptor_);
        }
        if (poolDescriptor != null) {
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(MAXPOOLSIZE, "" + poolDescriptor.getMaxPoolSize(), "", "java.lang.Integer"));
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(MINPOOLSIZE, "" + poolDescriptor.getSteadyPoolSize(), "", "java.lang.Integer"));
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(RESIZECOUNT, "" + poolDescriptor.getPoolResizeQuantity(), "", "java.lang.Integer"));
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(RESIZETIMEOUT, "" + poolDescriptor.getPoolIdleTimeoutInSeconds(), "", "java.lang.Integer"));
            if (descriptor_.getActivationConfigValue(REDELIVERYCOUNT) == null && descriptor_.getActivationConfigValue(LOWERCASE_REDELIVERYCOUNT) == null) {
                descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(REDELIVERYCOUNT, "" + MdbContainerProps.getMaxRuntimeExceptions(), "", "java.lang.Integer"));
            }
        }
        try {
            boolean clustered = ActiveJmsResourceAdapter.isClustered();
            ActiveJmsResourceAdapter.logFine("Are we in a Clustered contained ? " + clustered);
            if (clustered) {
                this.setClusterActivationSpecProperties(descriptor_);
                ActiveJmsResourceAdapter.logFine("Creating physical destination " + destName);
                ActiveJmsResourceAdapter.logFine("Destination is Queue? " + descriptor_.hasQueueDest());
                if (descriptor_.hasQueueDest()) {
                    this.autoCreatePhysicalDest(destName, true);
                } else {
                    this.autoCreatePhysicalDest(destName, false);
                }
            }
        }
        catch (ConfigException e) {
            ConnectorRuntimeException crex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)crex.initCause(e);
        }
    }

    void autoCreatePhysicalDest(String destName, boolean isQueue) throws ConnectorRuntimeException {
        MQAdministrator mqAdmin = new MQAdministrator();
        mqAdmin.createPhysicalDestination(destName, isQueue);
    }

    private void setClusterActivationSpecProperties(EjbMessageBeanDescriptor descriptor_) throws ConfigException {
        descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(MDBIDENTIFIER, "" + this.getMDBIdentifier(descriptor_), "MDB Identifier", "java.lang.String"));
        ActiveJmsResourceAdapter.logFine("CLUSTERED instance - setting MDB identifier as" + this.getMDBIdentifier(descriptor_));
    }

    private String getMDBIdentifier(EjbMessageBeanDescriptor descriptor_) throws ConfigException {
        return this.getDomainName() + SEPARATOR + this.getClusterName() + SEPARATOR + descriptor_.getUniqueId();
    }

    private String getPhysicalDestinationFromConfiguration(String logicalDest) throws ConnectorRuntimeException {
        ElementProperty ep = null;
        try {
            ServerContext sc = ApplicationServer.getServerContext();
            ConfigContext ctx = sc.getConfigContext();
            Resources rbeans = ServerBeansFactory.getDomainBean(ctx).getResources();
            AdminObjectResource res = rbeans.getAdminObjectResourceByJndiName(logicalDest);
            if (res == null) {
                String msg = this.sm.getString("ajra.err_getting_dest", logicalDest);
                throw new ConnectorRuntimeException(msg);
            }
            ep = res.getElementPropertyByName(PHYSICAL_DESTINATION);
        }
        catch (ConfigException ce) {
            String msg = this.sm.getString("ajra.err_getting_dest", logicalDest);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(msg);
            cre.initCause(ce);
            throw cre;
        }
        if (ep == null) {
            String msg = this.sm.getString("ajra.cannot_find_phy_dest", ep);
            throw new ConnectorRuntimeException(msg);
        }
        return ep.getValue();
    }

    private void setValuesFromConfiguration(String cfName, EjbMessageBeanDescriptor descriptor_) throws ConnectorRuntimeException {
        ElementProperty[] ep = null;
        try {
            ServerContext sc = ApplicationServer.getServerContext();
            ConfigContext ctx = sc.getConfigContext();
            Resources rbeans = ServerBeansFactory.getDomainBean(ctx).getResources();
            ConnectorResource res = rbeans.getConnectorResourceByJndiName(cfName);
            if (res == null) {
                String msg = this.sm.getString("ajra.mdb_cf_not_created", cfName);
                throw new ConnectorRuntimeException(msg);
            }
            com.sun.enterprise.config.serverbeans.ConnectorConnectionPool ccp = rbeans.getConnectorConnectionPoolByName(res.getPoolName());
            ep = ccp.getElementProperty();
        }
        catch (ConfigException ce) {
            String msg = this.sm.getString("ajra.mdb_cf_not_created", cfName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(msg);
            ce.initCause(ce);
            throw cre;
        }
        if (ep == null) {
            String msg = this.sm.getString("ajra.cannot_find_phy_dest");
            throw new ConnectorRuntimeException(msg);
        }
        for (int i = 0; i < ep.length; ++i) {
            String val;
            ElementProperty prop = ep[i];
            String name = prop.getName();
            if (name.equals(MCFADDRESSLIST)) {
                name = ADDRESSLIST;
            }
            if ((val = prop.getValue()) == null || val.equals("")) continue;
            descriptor_.putRuntimeActivationConfigProperty(new EnvironmentProperty(name, val, null));
        }
    }

    private static void logFine(String s) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(s);
        }
    }

    public int getAddressListCount() {
        StringTokenizer tokenizer = null;
        int count = 1;
        if (this.addressList != null) {
            tokenizer = new StringTokenizer(this.addressList, ",");
            count = tokenizer.countTokens();
        }
        ActiveJmsResourceAdapter.logFine("Address list count is " + count);
        return count;
    }
}

