/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.admin.verifier.ServerXmlTest;
import com.sun.enterprise.admin.verifier.tests.StaticTest;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VirtualServerTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext context) {
        Result result = super.getInitializedResult();
        return result;
    }

    public Result check(ConfigContextEvent ccce) {
        Result result = new Result();
        Object value = ccce.getObject();
        ConfigContext context = ccce.getConfigContext();
        String beanName = ccce.getBeanName();
        result.passed("Passed ***");
        String choice = ccce.getChoice();
        if (choice.equals("DELETE")) {
            return result;
        }
        if (beanName != null) {
            String name = ccce.getName();
            result = this.testSave(name, (String)value, context);
            return result;
        }
        VirtualServer virtual = (VirtualServer)value;
        String id = virtual.getId();
        if (!StaticTest.checkObjectName(id, result)) {
            result.failed("Virtual Server ID Invalid ");
            return result;
        }
        result.passed("Valid Object Name");
        boolean isNumber = false;
        for (int i = 0; i < 10; ++i) {
            if (!virtual.getId().startsWith(String.valueOf(i))) continue;
            isNumber = true;
        }
        if (isNumber) {
            result.failed("ID cannot start with a number");
        }
        return result;
    }

    public Result testSave(String name, String value, ConfigContext context) {
        File f;
        Result result = new Result();
        result.passed("passed ****");
        if (name.equals("log-file") && value != null && !(f = new File(value)).exists()) {
            result.failed("Log File does not exist");
        }
        if (name.equals("http-listeners") && value != null) {
            Vector https = this.tokens(value);
            for (int i = 0; i < https.size(); ++i) {
                if (this.isHttpListenerAvailable((String)https.get(i), context)) continue;
                result.failed("Http Listener not available");
                return result;
            }
        }
        return result;
    }

    public boolean isMimeAvailable(String value, ConfigContext context) {
        return false;
    }

    public boolean isAclAvailable(String value, ConfigContext context) {
        return false;
    }

    public boolean isHttpListenerAvailable(String value, ConfigContext context) {
        try {
            Config config = StaticTest.getConfig(context);
            if (config != null) {
                HttpListener[] http = config.getHttpService().getHttpListener();
                for (int i = 0; i < http.length; ++i) {
                    if (!value.equals(http[i].getId())) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", ex);
        }
        return false;
    }

    public Vector tokens(String value) {
        StringTokenizer token = new StringTokenizer(value, ",");
        Vector<String> test = new Vector<String>();
        while (token.hasMoreTokens()) {
            test.add(token.nextToken());
        }
        return test;
    }
}

