/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.admin.verifier.ServerXmlTest;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Logger;

public class TransactionServiceTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext context) {
        Result result = super.getInitializedResult();
        return result;
    }

    public Result check(ConfigContextEvent ccce) {
        Result result = new Result();
        Object value = ccce.getObject();
        String beanName = ccce.getBeanName();
        if (beanName != null) {
            String name = ccce.getName();
            return this.testSave(name, (String)value);
        }
        TransactionService txn = (TransactionService)value;
        String file = txn.getTxLogDir();
        if (file == null || file.equals("")) {
            result.failed("File Name cannot be Null");
            return result;
        }
        File f = new File(txn.getTxLogDir());
        if (f.exists()) {
            result.passed("Transaction Log Dir valid");
        } else {
            result.failed("Invalid Transaction Log Directory");
        }
        String heuDecision = txn.getHeuristicDecision();
        if (heuDecision.equals("rollback") || heuDecision.equals("commit")) {
            result.passed("Heurisitic Decision Valid");
        } else {
            result.failed("Invalid Heuristic Decision");
        }
        return result;
    }

    public Result testSave(String name, String value) {
        Result result;
        block19: {
            result = new Result();
            result.passed("Passed **");
            if (name.equals("tx-log-dir")) {
                if (value == null || value.equals("")) {
                    result.failed("File Name cannot be Null");
                    return result;
                }
                File f = new File(value);
                if (f.exists()) {
                    result.passed("Transaction Log Dir valid");
                } else {
                    result.failed("Invalid Transaction Log Directory");
                }
            } else if (name.equals("heuristic-decision")) {
                if (value.equals("rollback") || value.equals("commit")) {
                    result.passed("Heurisitic Decision Valid");
                } else {
                    result.failed("Invalid Heuristic Decision");
                }
            } else if (name.equals("timeout-in-seconds")) {
                try {
                    if (Integer.parseInt(value) < 0) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".resTimeoutNegative", "Response Timeout cannot be negative number"));
                        break block19;
                    }
                    result.passed("Passed ***");
                }
                catch (NumberFormatException e) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".resTimeoutInvalid", "Response Timeout : invalid number"));
                }
            } else if (name.equals("keypoint-interval")) {
                try {
                    if (Integer.parseInt(value) < 0) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".keyPointNegative", "Key Point Interval cannot be negative number"));
                    } else {
                        result.passed("Passed ***");
                    }
                }
                catch (NumberFormatException e) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".keyPointInvalid", "Key Point Interval : invalid number"));
                }
            }
        }
        return result;
    }
}

