/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.admin.verifier.ServerXmlTest;
import com.sun.enterprise.admin.verifier.tests.StaticTest;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdbcResourceTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext context) {
        Result result = super.getInitializedResult();
        return result;
    }

    public Result check(ConfigContextEvent ccce) {
        Result result = new Result();
        String beanName = ccce.getBeanName();
        if (beanName != null) {
            result.passed("Save to be implemented");
            return result;
        }
        ConfigContext context = ccce.getConfigContext();
        Object value = ccce.getObject();
        JdbcResource jdbc = (JdbcResource)value;
        boolean isPool = false;
        String pool = jdbc.getPoolName();
        if (!StaticTest.checkObjectName(jdbc.getJndiName(), result)) {
            result.failed("JDBC Resource Jndi-Name Invalid ");
            return result;
        }
        result.passed("Valid Object Name");
        try {
            Domain domain = (Domain)context.getRootConfigBean();
            Resources resource = domain.getResources();
            JdbcConnectionPool[] connection = resource.getJdbcConnectionPool();
            for (int i = 0; i < connection.length; ++i) {
                if (!connection[i].getName().equals(pool)) continue;
                isPool = true;
            }
            if (isPool) {
                result.passed("Valid Connection Pool");
            } else {
                result.failed("Connection Pool Not Available");
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", e);
            result.failed("Exception : " + e.getMessage());
        }
        return result;
    }
}

