/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.Assert;
import com.sun.enterprise.admin.util.BaseValidator;
import com.sun.enterprise.admin.util.Validator;
import com.sun.enterprise.admin.util.ValidatorResult;

public class StringValidator
extends BaseValidator {
    private final int mMininumLength;
    private static final int kDefaultMinimumLength = 1;
    private static final StringValidator sDefaultInstance = new StringValidator(1);
    private static final String badArgMessage = "Can't call StringValidator.validate() with a non-String argument";

    public StringValidator(int minimumLength) {
        Assert.assertRange(minimumLength, 0, Integer.MAX_VALUE, (Object)"minimumLength");
        this.mMininumLength = minimumLength;
    }

    public static Validator getInstance() {
        return sDefaultInstance;
    }

    public ValidatorResult validate(Object obj) {
        ValidatorResult result = super.validate(obj);
        if (result.isValid()) {
            Assert.assertit(obj instanceof String, badArgMessage);
            String str = (String)obj;
            int len = str.length();
            if (len < this.mMininumLength) {
                result = this.makeBadResult(len);
            }
        }
        return result;
    }

    private ValidatorResult makeBadResult(int len) {
        return new ValidatorResult(false, "The String argument is invalid.  The minimum required length is " + this.mMininumLength + " and the String's actual length is " + len);
    }
}

