/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.target;

import com.sun.enterprise.admin.target.ConfigTarget;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;

public class ClusterTarget
extends Target {
    protected ClusterTarget(String name, ConfigContext cc) {
        super(name, cc);
    }

    public TargetType getType() {
        return TargetType.CLUSTER;
    }

    public String getTargetObjectName(String[] tokens) {
        this.checkTokens(tokens, 1);
        return tokens[0] + ":type=cluster,category=config,name=" + this.getName();
    }

    public ConfigTarget getConfigTarget() throws Exception {
        return new ConfigTarget(this.getConfigRef(), this.getConfigContext());
    }

    public String getConfigRef() throws ConfigException {
        Config config = ClusterHelper.getConfigForCluster(this.getConfigContext(), this.getName());
        return config.getName();
    }

    public Server[] getServers() throws ConfigException {
        return ServerHelper.getServersInCluster(this.getConfigContext(), this.getName());
    }

    public Cluster[] getClusters() throws ConfigException {
        Cluster[] clusters = new Cluster[]{ClusterHelper.getClusterByName(this.getConfigContext(), this.getName())};
        return clusters;
    }

    public Config[] getConfigs() throws ConfigException {
        Config[] configs = new Config[]{ClusterHelper.getConfigForCluster(this.getConfigContext(), this.getName())};
        return configs;
    }

    public NodeAgent[] getNodeAgents() throws ConfigException {
        return NodeAgentHelper.getNodeAgentsForCluster(this.getConfigContext(), this.getName());
    }

    public ApplicationRef[] getApplicationRefs() throws ConfigException {
        return ClusterHelper.getApplicationReferences(this.getConfigContext(), this.getName());
    }

    public ResourceRef[] getResourceRefs() throws ConfigException {
        return ClusterHelper.getResourceReferences(this.getConfigContext(), this.getName());
    }
}

