/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx.storage;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.ObjectNameHelper;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.server.core.mbean.config.GenericConfigurator;
import com.sun.enterprise.admin.server.core.mbean.config.ServerController;
import com.sun.enterprise.admin.server.core.mbean.config.naming.ConfigMBeanNamingInfo;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ServerManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;

public class PersistenceChecker {
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private AdminContext mAdminContext;

    public void setAdminContext(AdminContext ctx) {
        this.mAdminContext = ctx;
    }

    private Object findElement_8_0(ObjectName objectName) throws InstanceNotFoundException {
        try {
            MBeanRegistry registry = MBeanRegistryFactory.getAdminMBeanRegistry();
            return registry.findMBeanRegistryEntry(objectName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object findElement(ObjectName objectName) throws InstanceNotFoundException {
        Object match = null;
        match = this.findElement_8_0(objectName);
        if (match != null) {
            return match;
        }
        String type = ObjectNameHelper.getType(objectName);
        String instanceName = ObjectNameHelper.getServerInstanceName(objectName);
        if (type != null) {
            if (type.equals("controller")) {
                match = new ServerController();
            } else if (type.equals("configurator")) {
                match = new GenericConfigurator();
            } else if (type.equals("server-instance")) {
                match = this.findServerInstance(instanceName);
                if (match == null) {
                    throw new InstanceNotFoundException(objectName.toString());
                }
            } else if (type.equals("deployment-service")) {
                match = this.findServerInstance(instanceName);
                if (match == null) {
                    throw new InstanceNotFoundException(objectName.toString());
                }
            } else {
                match = this.findGenericConfigBean(objectName, instanceName);
            }
        } else {
            _logger.log(Level.FINE, "mbean.config.admin.unknown_mbean_type", objectName.toString());
        }
        return match;
    }

    private Object findServerInstance(String instanceName) {
        ServerManager sm = ServerManager.instance();
        Server serverInstance = null;
        if (!sm.instanceExists(instanceName)) {
            return null;
        }
        try {
            ConfigContext cc = this.getConfigContext(instanceName);
            serverInstance = ServerBeansFactory.getServerBean(cc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverInstance;
    }

    private Object findGenericConfigBean(ObjectName objectName, String instanceName) {
        ConfigBean bean = null;
        ConfigMBeanNamingInfo mbeanInfo = null;
        try {
            mbeanInfo = new ConfigMBeanNamingInfo(objectName);
        }
        catch (MBeanConfigException mce) {
            _logger.log(Level.FINE, "mbean.config.admin.naming_not_found", new Object[]{objectName.toString(), mce.getLocalizedMessage()});
        }
        if (mbeanInfo != null) {
            String xPath = mbeanInfo.getXPath();
            try {
                ConfigContext ctx = this.getConfigContext(instanceName);
                bean = ConfigBeansFactory.getConfigBeanByXPath(ctx, xPath);
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "mbean.config.admin.config_bean_not_found", new Object[]{xPath, e.getLocalizedMessage()});
            }
        }
        return bean;
    }

    private ConfigContext getConfigContext(String instanceName) throws ConfigException {
        if (this.mAdminContext != null) {
            return this.mAdminContext.getAdminConfigContext();
        }
        String backupServerXmlPath = new InstanceEnvironment(instanceName).getBackupConfigFilePath();
        return ConfigFactory.createConfigContext(backupServerXmlPath);
    }
}

