/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.channel;

import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class RRStateFactory {
    private static final String STATE_FILE_NM = ".restart-required-state";
    private static final String DEF_LOCATION = ".";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveState(boolean state) throws IOException {
        File stateFile = RRStateFactory.getStateFile(null);
        FileWriter fw = new FileWriter(stateFile);
        try {
            fw.write(Boolean.toString(state));
            fw.flush();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean getState() {
        return RRStateFactory.getState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getState(String instanceRoot) {
        boolean restartNeeded = false;
        File f = RRStateFactory.getStateFile(instanceRoot);
        if (f.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(f));
                String state = br.readLine();
                restartNeeded = new Boolean(state.trim());
            }
            catch (IOException ioe) {
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return restartNeeded;
    }

    public static void removeStateFile() {
        File state = RRStateFactory.getStateFile(null);
        if (state.exists()) {
            FileUtils.liquidate(state);
        }
    }

    private static File getStateFile(String instanceRoot) {
        if (instanceRoot == null) {
            instanceRoot = System.getProperty("com.sun.aas.instanceRoot", DEF_LOCATION);
        }
        File f = new File(instanceRoot + File.separator + STATE_FILE_NM);
        return f;
    }

    public static void main(String[] args) {
        try {
            System.setProperty("com.sun.aas.instanceRoot", "/tmp");
            RRStateFactory.saveState(true);
            boolean state = RRStateFactory.getState();
            System.out.println(state);
            RRStateFactory.removeStateFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

