/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.channel;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.DynamicReconfigEvent;
import com.sun.enterprise.admin.event.DynamicReconfigEventListener;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.util.i18n.StringManager;

public class DynamicReconfigEventListenerImpl
implements DynamicReconfigEventListener {
    private static StringManager localStrings = StringManager.getManager(DynamicReconfigEventListenerImpl.class);

    public void processEvent(DynamicReconfigEvent event) throws AdminEventListenerException {
        String inst = event.getInstanceName();
        if (inst == null) {
            String msg = localStrings.getString("admin.server.core.channel.impl.no_inst_name");
            throw new AdminEventListenerException(msg);
        }
        RMIClient client = AdminChannel.getRMIClient(inst);
        if (client == null) {
            String msg = localStrings.getString("admin.server.core.channel.impl.no_rmi_client", inst);
            throw new AdminEventListenerException(msg);
        }
        boolean resNeeded = client.isRestartNeeded();
        if (event.getActionType() == 1) {
            if (resNeeded) {
                String msg = localStrings.getString("admin.server.core.channel.impl.restart_required", inst);
                throw new AdminEventListenerException(msg);
            }
        } else if (event.getActionType() == 0) {
            client.setRestartNeeded(true);
        }
    }
}

