/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.monitor.callflow.RequestType;
import com.sun.enterprise.admin.selfmanagement.event.CallflowEventListener;
import com.sun.enterprise.admin.selfmanagement.event.TraceEventImplMBean;
import java.util.HashMap;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;

public class TraceEventImpl
extends NotificationBroadcasterSupport
implements TraceEventImplMBean {
    private long sequenceNumber = 0L;
    private static final String[] types = new String[]{"trace.request_start", "trace.request_end", "trace.web_component_method_entry", "trace.web_component_method_exit", "trace.ejb_component_method_entry", "trace.ejb_component_method_exit"};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.Notification", "Notifications sent by the TraceEventImpl MBean")};

    public TraceEventImpl() {
        CallflowEventListener.setTraceImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestEnd(String requestId, long nanoTime, String threadId) {
        long seqno;
        TraceEventImpl traceEventImpl = this;
        synchronized (traceEventImpl) {
            seqno = this.sequenceNumber++;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("com.sun.appserv.management.event.trace.requestid", requestId);
        map.put("com.sun.appserv.management.event.trace.nanotime", nanoTime);
        map.put("com.sun.appserv.management.event.trace.threadid", threadId);
        Notification n = new Notification("trace.request_end", (Object)this, seqno, "request end!");
        n.setUserData(map);
        this.sendNotification(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStart(String requestId, RequestType requestType, String callerIPAddress, long nanoTime, String threadId) {
        long seqno;
        TraceEventImpl traceEventImpl = this;
        synchronized (traceEventImpl) {
            seqno = this.sequenceNumber++;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("com.sun.appserv.management.event.trace.requestid", requestId);
        map.put("com.sun.appserv.management.event.trace.requesttype", this.getRequestTypeString(requestType));
        map.put("com.sun.appserv.management.event.trace.callerip", callerIPAddress);
        map.put("com.sun.appserv.management.event.trace.nanotime", nanoTime);
        map.put("com.sun.appserv.management.event.trace.threadid", threadId);
        Notification n = new Notification("trace.request_start", (Object)this, seqno, "request start!");
        n.setUserData(map);
        this.sendNotification(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbMethodStart(String requestId, String methodName, String componentType, String appName, String moduleName, String componentName, String tranId, String secId, long nanoTime, String threadId) {
        long seqno;
        TraceEventImpl traceEventImpl = this;
        synchronized (traceEventImpl) {
            seqno = this.sequenceNumber++;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("com.sun.appserv.management.event.trace.requestid", requestId);
        map.put("com.sun.appserv.management.event.trace.methodname", methodName);
        map.put("com.sun.appserv.management.event.trace.componenttype", componentType);
        map.put("com.sun.appserv.management.event.trace.applicationname", appName);
        map.put("com.sun.appserv.management.event.trace.modulename", moduleName);
        map.put("com.sun.appserv.management.event.trace.componentname", componentName);
        map.put("com.sun.appserv.management.event.trace.transactionid", tranId);
        map.put("com.sun.appserv.management.event.trace.securityid", secId);
        map.put("com.sun.appserv.management.event.trace.nanotime", nanoTime);
        map.put("com.sun.appserv.management.event.trace.threadid", threadId);
        Notification n = new Notification("trace.ejb_component_method_entry", (Object)this, seqno, "ejb method start!");
        n.setUserData(map);
        this.sendNotification(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbMethodEnd(String requestId, Throwable exception, long nanoTime, String threadId) {
        long seqno;
        TraceEventImpl traceEventImpl = this;
        synchronized (traceEventImpl) {
            seqno = this.sequenceNumber++;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("com.sun.appserv.management.event.trace.requestid", requestId);
        if (exception != null) {
            map.put("com.sun.appserv.management.event.trace.exception", this.getExceptionString(exception));
            map.put("com.sun.appserv.management.event.trace.exceptionobject", exception);
        }
        map.put("com.sun.appserv.management.event.trace.nanotime", nanoTime);
        map.put("com.sun.appserv.management.event.trace.threadid", threadId);
        Notification n = new Notification("trace.ejb_component_method_exit", (Object)this, seqno, "ejb method end!");
        n.setUserData(map);
        this.sendNotification(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void webMethodEnd(String requestId, Throwable exception, long nanoTime, String threadId) {
        long seqno;
        TraceEventImpl traceEventImpl = this;
        synchronized (traceEventImpl) {
            seqno = this.sequenceNumber++;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("com.sun.appserv.management.event.trace.requestid", requestId);
        if (exception != null) {
            map.put("com.sun.appserv.management.event.trace.exception", this.getExceptionString(exception));
            map.put("com.sun.appserv.management.event.trace.exceptionobject", exception);
        }
        map.put("com.sun.appserv.management.event.trace.nanotime", nanoTime);
        map.put("com.sun.appserv.management.event.trace.threadid", threadId);
        Notification n = new Notification("trace.web_component_method_exit", (Object)this, seqno, "web method end!");
        n.setUserData(map);
        this.sendNotification(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void webMethodStart(String requestId, String methodName, String applicationName, String componentType, String componentName, String callerPrincipal, long nanoTime, String threadId) {
        long seqno;
        TraceEventImpl traceEventImpl = this;
        synchronized (traceEventImpl) {
            seqno = this.sequenceNumber++;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("com.sun.appserv.management.event.trace.requestid", requestId);
        map.put("com.sun.appserv.management.event.trace.methodname", methodName);
        map.put("com.sun.appserv.management.event.trace.componenttype", componentType);
        map.put("com.sun.appserv.management.event.trace.componentname", componentName);
        map.put("com.sun.appserv.management.event.trace.callerprincipal", callerPrincipal);
        map.put("com.sun.appserv.management.event.trace.applicationname", applicationName);
        map.put("com.sun.appserv.management.event.trace.nanotime", nanoTime);
        map.put("com.sun.appserv.management.event.trace.threadid", threadId);
        Notification n = new Notification("trace.web_component_method_entry", (Object)this, seqno, "web method start!");
        n.setUserData(map);
        this.sendNotification(n);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return (MBeanNotificationInfo[])notifsInfo.clone();
    }

    private String getRequestTypeString(RequestType requestType) {
        if (RequestType.REMOTE_WEB == requestType) {
            return "remote web request";
        }
        if (RequestType.REMOTE_EJB == requestType) {
            return "remote ejb request";
        }
        if (RequestType.REMOTE_ASYNC_MESSAGE == requestType) {
            return "remote asynchronous message request";
        }
        if (RequestType.TIMER_EJB == requestType) {
            return "timer ejb request";
        }
        if (RequestType.REMOTE_WEB_SERVICE == requestType) {
            return "remote web service request";
        }
        return "unknown request type";
    }

    private String getExceptionString(Throwable exception) {
        StringBuffer exceptionMsg = new StringBuffer();
        exceptionMsg.append(" Message: ");
        String message = exception.getMessage();
        exceptionMsg.append(message);
        String className = exception.getClass().getName();
        exceptionMsg.append(" Exception Class Name: ");
        exceptionMsg.append(className);
        if (exception.getCause() != null) {
            exceptionMsg.append(" Exception Cause Message: ");
            exceptionMsg.append(exception.getCause().getMessage());
            exceptionMsg.append(" Exception Cause Class Name: ");
            exceptionMsg.append(exception.getCause().getClass().getName());
        }
        return exceptionMsg.toString();
    }
}

