/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.selfmanagement.event.Event;
import com.sun.enterprise.admin.selfmanagement.event.EventAbstractFactory;
import com.sun.enterprise.admin.selfmanagement.event.LifeCycleEventFactory;
import com.sun.enterprise.admin.selfmanagement.event.LogEventFactory;
import com.sun.enterprise.admin.selfmanagement.event.MonitorEventFactory;
import com.sun.enterprise.admin.selfmanagement.event.NotificationEventFactory;
import com.sun.enterprise.admin.selfmanagement.event.TimerEventFactory;
import com.sun.enterprise.admin.selfmanagement.event.TraceEventFactory;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;

public class EventBuilder {
    private static final EventBuilder instance = new EventBuilder();
    private static final ConcurrentHashMap<String, EventAbstractFactory> eventFactoryMap = new ConcurrentHashMap(10, 0.75f, 2);
    private boolean initialized = false;
    protected static final StringManager sm = StringManager.getManager(EventBuilder.class);

    private EventBuilder() {
    }

    public static EventBuilder getInstance() {
        return instance;
    }

    public synchronized void addEventFactory(String eventType, EventAbstractFactory factory) {
        if (eventFactoryMap.get(eventType) == null) {
            eventFactoryMap.put(eventType, factory);
        }
    }

    public Event getEvent(String eventType, ElementProperty[] properties, String description) {
        Initer.getIniter();
        EventAbstractFactory factory = eventFactoryMap.get(eventType);
        if (factory == null) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.unknown_event_type", eventType));
        }
        return factory.instrumentEvent(properties, description);
    }

    public Event getEvent(String eventType, String description, Hashtable attributes, ElementProperty[] properties) {
        return this.getEvent(eventType, properties, description);
    }

    private static final class Initer {
        private static final Initer _Instance = new Initer();

        static Initer getIniter() {
            return _Instance;
        }

        Initer() {
            LogEventFactory.getInstance();
            NotificationEventFactory.getInstance();
            LifeCycleEventFactory.getInstance();
            MonitorEventFactory.getInstance();
            TimerEventFactory.getInstance();
            TraceEventFactory.getInstance();
        }
    }
}

