/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.event.DynamicReconfigEvent;
import com.sun.enterprise.admin.event.EventContext;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.admin.servermgmt.pe.PEInstancesManager;
import com.sun.enterprise.util.i18n.StringManager;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;

public class ConfigMBean
extends BaseConfigMBean {
    private static final StringManager _strMgr = StringManager.getManager(ConfigMBean.class);

    public AttributeList setAttributes(AttributeList list) {
        Attribute attr;
        int i;
        boolean bEnabled = false;
        int reconfigIdx = -1;
        if (list != null) {
            for (i = 0; i < list.size(); ++i) {
                attr = (Attribute)list.get(i);
                if (!"dynamic-reconfiguration-enabled".equals(attr.getName())) continue;
                try {
                    bEnabled = this.validateDynamicReconfigEvent(attr.getValue());
                    continue;
                }
                catch (Exception e) {
                    reconfigIdx = i;
                }
            }
        }
        if (reconfigIdx != -1) {
            list.remove(reconfigIdx);
        }
        list = super.setAttributes(list);
        if (reconfigIdx != -1) {
            return list;
        }
        if (list != null) {
            for (i = 0; i < list.size(); ++i) {
                attr = (Attribute)list.get(i);
                if (!"dynamic-reconfiguration-enabled".equals(attr.getName())) continue;
                this.emitDynamicReconfigEvent(bEnabled);
            }
        }
        return list;
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, MBeanException, ReflectionException {
        boolean bEnabled = false;
        if ("dynamic-reconfiguration-enabled".equals(attr.getName())) {
            bEnabled = this.validateDynamicReconfigEvent(attr.getValue());
        }
        super.setAttribute(attr);
        if ("dynamic-reconfiguration-enabled".equals(attr.getName())) {
            this.emitDynamicReconfigEvent(bEnabled);
        }
    }

    private boolean validateDynamicReconfigEvent(Object value) throws IllegalArgumentException, MBeanException {
        boolean bEnabled = false;
        if (value instanceof Boolean) {
            bEnabled = (Boolean)value;
        } else if ("true".equalsIgnoreCase(value.toString()) || "yes".equalsIgnoreCase(value.toString())) {
            bEnabled = true;
        }
        boolean restartRequired = false;
        try {
            restartRequired = this.getRuntimeStatus().isRestartNeeded();
        }
        catch (InstanceException ie) {
            throw new MBeanException((Exception)((Object)ie));
        }
        if (bEnabled && restartRequired) {
            String msg = _strMgr.getString("admin.mbeans.configMBean.serverRequiresRestart");
            Exception e = new Exception(msg);
            throw new MBeanException(e, msg);
        }
        return bEnabled;
    }

    private void emitDynamicReconfigEvent(boolean bEnabled) {
        try {
            AdminContext adminContext = MBeanRegistryFactory.getAdminContext();
            String instanceName = adminContext.getServerName();
            int action = bEnabled ? 1 : 0;
            DynamicReconfigEvent event = new DynamicReconfigEvent(instanceName, action);
            String configName = (String)this.getAttribute("name");
            event.setTargetDestination(configName);
            EventContext.addEvent(event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RuntimeStatus getRuntimeStatus() throws InstanceException {
        String serverName = System.getProperty("com.sun.aas.instanceName");
        PEInstancesManager manager = new PEInstancesManager(new RepositoryConfig());
        return RuntimeStatus.getRuntimeStatus((String)serverName, (InstancesManager)manager);
    }
}

