/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.util.i18n.StringManager;

public class AuthRealmEvent
extends AdminEvent {
    public static final int ACTION_CREATE = 1;
    public static final int ACTION_DELETE = 2;
    public static final int ACTION_UPDATE = 3;
    static final String eventType = AuthRealmEvent.class.getName();
    private int actionType;
    private String realmName;
    private static StringManager localStrings = StringManager.getManager(AuthRealmEvent.class);

    public AuthRealmEvent(String instance, String realm, int action) {
        this(eventType, instance, realm, action);
    }

    public AuthRealmEvent(String type, String instance, String realm, int action) {
        super(type, instance);
        this.realmName = realm;
        this.setAction(action);
    }

    public String getAuthRealmName() {
        return this.realmName;
    }

    public int getActionType() {
        return this.actionType;
    }

    private void setAction(int action) {
        boolean valid = false;
        if (action == 1 || action == 2 || action == 3) {
            valid = true;
        }
        if (!valid) {
            String msg = localStrings.getString("admin.event.invalid_action", "" + action);
            throw new IllegalArgumentException(msg);
        }
        this.actionType = action;
    }
}

