/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common;

import com.sun.enterprise.admin.common.MalformedNameException;
import com.sun.enterprise.admin.common.NameParser;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public final class Name
implements Serializable {
    public static final long serialVersionUID = 4479037048166596417L;
    public static final int kInvalidIndex = -1;
    private String mString = null;
    private Vector mNameParts = null;

    public Name(String nameString) throws MalformedNameException {
        NameParser parser = new NameParser();
        parser.parseIt(nameString);
        Iterator iter = parser.getParts();
        this.mNameParts = new Vector();
        while (iter.hasNext()) {
            Object element = iter.next();
            this.mNameParts.addElement(element);
        }
        this.mString = nameString;
    }

    public Name getNamePart(int partNum) {
        Name namePart = null;
        String namePartString = null;
        int lowerLimit = -1;
        int upperLimit = this.mNameParts.size();
        namePartString = (String)this.mNameParts.elementAt(partNum);
        try {
            namePart = new Name(namePartString);
        }
        catch (Exception e) {
            // empty catch block
        }
        return namePart;
    }

    public Name getParent() {
        Name parentName = null;
        int size = this.mNameParts.size();
        if (size > 1) {
            String nameSubstring = this.createPartialNameString(0, size - 1);
            try {
                parentName = new Name(nameSubstring);
            }
            catch (MalformedNameException e) {
                // empty catch block
            }
        }
        return parentName;
    }

    public int getNumParts() {
        return this.mNameParts.size();
    }

    public boolean isIndexed() {
        boolean indexed = false;
        if (this.mString.charAt(this.mString.length() - 1) == ']') {
            indexed = true;
        }
        return indexed;
    }

    public int getIndex() {
        int index = -1;
        String indexString = null;
        if (this.isIndexed()) {
            int startPos = this.mString.lastIndexOf(91);
            int endPos = this.mString.lastIndexOf(93);
            indexString = this.mString.substring(startPos + 1, endPos);
            try {
                index = Integer.parseInt(indexString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return index;
    }

    public String toString() {
        return this.mString;
    }

    public boolean equals(Object other) {
        boolean isSame = false;
        if (other instanceof Name) {
            Name otherName = (Name)other;
            if (this.mString.equals(otherName.mString)) {
                isSame = true;
            }
        }
        return isSame;
    }

    public int hashCode() {
        return this.mString.length() * 2 + 1;
    }

    private String createPartialNameString(int beginIndex, int endIndex) {
        boolean isInputValid = beginIndex <= endIndex && endIndex < this.mNameParts.size() && beginIndex >= 0;
        StringBuffer nameBuffer = new StringBuffer();
        for (int i = beginIndex; i < endIndex; ++i) {
            String aPart = (String)this.mNameParts.elementAt(i);
            nameBuffer.append(aPart);
            if (i >= endIndex - 1) continue;
            nameBuffer.append('.');
        }
        return nameBuffer.toString();
    }
}

