/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.addon;

import com.sun.enterprise.util.OS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Addon {
    private File addonJar;

    public Addon(File addonJar) {
        this.addonJar = addonJar;
    }

    public boolean install(String installDir, String instanceRoot) throws Exception {
        JarFile file = new JarFile(this.addonJar);
        Manifest mf = file.getManifest();
        Attributes attributes = null;
        if (mf != null) {
            attributes = mf.getMainAttributes();
            if (attributes != null) {
                String mainClass = attributes.getValue(Attributes.Name.MAIN_CLASS);
                Logger.getAnonymousLogger().log(Level.FINE, "Addon getting installed: " + this.addonJar);
                Logger.getAnonymousLogger().log(Level.FINE, "Main Class " + mainClass);
                if (mainClass != null) {
                    URL url = this.addonJar.toURI().toURL();
                    ArrayList<URL> classPath = new ArrayList<URL>();
                    classPath.add(url);
                    this.addClasspath(installDir, classPath);
                    URL[] urls = classPath.toArray(new URL[0]);
                    URLClassLoader loader = new URLClassLoader(urls);
                    Class<?> main = loader.loadClass(mainClass);
                    Object obj = main.newInstance();
                    String[] argu = new String[]{installDir, instanceRoot};
                    Class[] types = new Class[]{argu.getClass()};
                    Method method = main.getMethod("main", types);
                    Object[] args = new Object[]{argu};
                    method.invoke(obj, args);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private void addClasspath(String installDir, List classPath) throws Exception {
        BufferedReader bf = null;
        InputStream in = null;
        try {
            String asenv = "";
            asenv = OS.isUNIX() ? installDir + File.separator + "config" + File.separator + "asenv.conf" : installDir + File.separator + "config" + File.separator + "asenv.bat";
            in = new FileInputStream(asenv);
            String antLib = "";
            bf = new BufferedReader(new InputStreamReader(in));
            String line = bf.readLine();
            while (line != null) {
                int pos;
                if (line.indexOf("AS_ANT_LIB") != -1 && (pos = line.indexOf("=")) > 0) {
                    String lhs = line.substring(0, pos).trim();
                    String rhs = line.substring(pos + 1).trim();
                    if (OS.isWindows()) {
                        lhs = lhs.substring(3).trim();
                    }
                    if (OS.isUNIX() && (pos = rhs.indexOf("\"")) != -1 && (pos = (rhs = rhs.substring(pos + 1).trim()).indexOf("\"")) != -1) {
                        rhs = rhs.substring(0, pos).trim();
                    }
                    antLib = rhs;
                    break;
                }
                line = bf.readLine();
            }
            Logger.getAnonymousLogger().log(Level.FINE, "antLib " + antLib);
            File antLibDir = new File(antLib);
            File[] fileArray = antLibDir.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getName().endsWith(".jar")) continue;
                URL url = fileArray[i].toURI().toURL();
                classPath.add(url);
            }
            File installLib = new File(installDir + File.separator + "lib");
            File[] installLibArray = installLib.listFiles();
            Logger.getAnonymousLogger().log(Level.FINE, "installLib " + installLib.getAbsolutePath());
            for (int i = 0; i < installLibArray.length; ++i) {
                if (!installLibArray[i].getName().endsWith(".jar")) continue;
                URL url = installLibArray[i].toURI().toURL();
                classPath.add(url);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (bf != null) {
                bf.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }
}

