/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.appserv.util.cache.CacheListener;
import com.sun.ejb.ComponentContext;
import com.sun.ejb.Invocation;
import com.sun.ejb.InvocationInfo;
import com.sun.ejb.base.io.IOUtils;
import com.sun.ejb.base.stats.StatefulSessionStoreMonitor;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.PeriodicTask;
import com.sun.ejb.containers.RemoteBusinessIntfInfo;
import com.sun.ejb.containers.SFSBVersionManager;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.util.ContainerWorkPool;
import com.sun.ejb.containers.util.cache.LruSessionCache;
import com.sun.ejb.spi.container.ContainerService;
import com.sun.ejb.spi.container.SFSBContainerCallback;
import com.sun.ejb.spi.container.StatefulEJBContext;
import com.sun.ejb.spi.io.IndirectlySerializable;
import com.sun.ejb.spi.io.SerializableObjectFactory;
import com.sun.ejb.spi.sfsb.initialization.SFSBContainerInitialization;
import com.sun.ejb.spi.sfsb.store.SFSBBeanState;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManagerException;
import com.sun.ejb.spi.sfsb.util.CheckpointPolicy;
import com.sun.ejb.spi.sfsb.util.SFSBUUIDUtil;
import com.sun.ejb.spi.stats.StatefulSessionBeanStatsProvider;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbRemovalInfo;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.runtime.CheckpointAtEndOfMethodDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.iiop.SFSBClientVersionManager;
import com.sun.enterprise.util.EntityManagerFactoryWrapper;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.threadpool.Servicable;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBObject;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.SessionSynchronization;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public final class StatefulSessionContainer
extends BaseContainer
implements CacheListener,
SFSBContainerCallback,
StatefulSessionBeanStatsProvider,
SFSBContainerInitialization {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    static final int PASSIVE = 1;
    static final int READY = 2;
    static final int INVOKING = 3;
    static final int INCOMPLETE_TX = 4;
    static final int DESTROYED = 5;
    public static final int MIN_PASSIVATION_BATCH_COUNT = 8;
    private long instanceCount = 1L;
    protected ArrayList passivationCandidates = new ArrayList();
    private Object asyncTaskSemaphore = new Object();
    private int asyncTaskCount = 0;
    private int asyncCummTaskCount = 0;
    private int passivationBatchCount = 8;
    private int containerTrimCount = 0;
    private LruSessionCache sessionBeanCache;
    private SFSBStoreManager sfsbStoreManager;
    private SFSBUUIDUtil uuidGenerator;
    private ArrayList scheduledTimerTasks = new ArrayList();
    protected int statMethodReadyCount = 0;
    private Level TRACE_LEVEL = Level.FINE;
    private String ejbName;
    private CheckpointPolicy checkpointPolicy;
    private int removalGracePeriodInSeconds;
    private StatefulSessionStoreMonitor sfsbStoreMonitor;
    private final String traceInfoPrefix;
    private static Map<EntityManager, EEMRefInfo> extendedEMReferenceCountMap = new HashMap<EntityManager, EEMRefInfo>();
    private static Map<EEMRefInfoKey, EntityManager> eemKey2EEMMap = new HashMap<EEMRefInfoKey, EntityManager>();

    public StatefulSessionContainer(EjbDescriptor desc, ClassLoader loader) throws Exception {
        super(desc, loader);
        super.createCallFlowAgent(ComponentType.SFSB);
        this.ejbName = desc.getName();
        this.traceInfoPrefix = "sfsb-" + this.ejbName + ": ";
    }

    protected void initializeHome() throws Exception {
        super.initializeHome();
        this.loadCheckpointInfo();
        this.registerMonitorableComponents();
    }

    protected void loadCheckpointInfo() {
        try {
            if (this.checkpointPolicy.isHAEnabled()) {
                for (InvocationInfo info : this.invocationInfoMap.values()) {
                    CheckpointAtEndOfMethodDescriptor cpDesc;
                    info.checkpointEnabled = false;
                    MethodDescriptor md = new MethodDescriptor(info.method, info.methodIntf);
                    IASEjbExtraDescriptors extraDesc = this.ejbDescriptor.getIASEjbExtraDescriptors();
                    if (extraDesc != null && (cpDesc = extraDesc.getCheckpointAtEndOfMethodDescriptor()) != null) {
                        info.checkpointEnabled = cpDesc.isCheckpointEnabledFor(md);
                    }
                    if (!info.checkpointEnabled || !_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "[SFSBContainer] " + info.method + " MARKED for " + "end-of-method-checkpoint");
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "[SFSBContainer] Exception while  loading checkpoint info", ex);
        }
    }

    protected void registerMonitorableComponents() {
        this.registryMediator.registerProvider(this);
        this.registryMediator.registerProvider(this.sessionBeanCache);
        super.registerMonitorableComponents();
        super.populateMethodMonitorMap();
        this.sfsbStoreMonitor = this.registryMediator.registerProvider(this.sfsbStoreManager.getMonitorableSFSBStoreManager(), this.checkpointPolicy.isHAEnabled());
        this.sessionBeanCache.setStatefulSessionStoreMonitor(this.sfsbStoreMonitor);
        _logger.log(Level.FINE, "[SFSBContainer] registered monitorable");
    }

    public String getMonitorAttributeValues() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(" { asyncTaskCount=").append(this.asyncTaskCount).append("; asyncCummTaskCount=").append(this.asyncCummTaskCount).append("; passivationBatchCount=").append(this.passivationBatchCount).append("; passivationQSz=").append(this.passivationCandidates.size()).append("; trimEventCount=").append(this.containerTrimCount).append(" }");
        return sbuf.toString();
    }

    public void appendStats(StringBuffer sbuf) {
        sbuf.append("\nStatefulContainer: ").append("CreateCount=").append(this.statCreateCount).append("; ").append("RemoveCount=").append(this.statRemoveCount).append("; ").append("Size=").append(this.sessionBeanCache.getNumBeansInCache()).append("; ").append("ReadyCount=").append(this.statMethodReadyCount).append("; ");
        sbuf.append("]");
    }

    private static final String convertCtxStateToString(SessionContextImpl sc) {
        switch (sc.getState()) {
            case 1: {
                return "PASSIVE";
            }
            case 2: {
                return "READY";
            }
            case 3: {
                return "INVOKING";
            }
            case 4: {
                return "INCOMPLETE_TX";
            }
            case 5: {
                return "DESTROYED";
            }
        }
        return "UNKNOWN-STATE";
    }

    boolean isIdentical(EJBObjectImpl ejbo, EJBObject other) throws RemoteException {
        if (other == ejbo.getStub()) {
            return true;
        }
        try {
            return this.protocolMgr.isIdentical(ejbo.getStub(), (Remote)other);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Exception while getting stub for ejb", ex);
            throw new RemoteException("Error during isIdentical.", ex);
        }
    }

    EJBObjectImpl createEJBObjectImpl() throws CreateException, RemoteException {
        try {
            SessionContextImpl context = this.createBeanInstance();
            EJBObjectImpl ejbObjImpl = this.createEJBObjectImpl(context);
            this.afterInstanceCreation(context);
            return ejbObjImpl;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.create_ejbobject_exception", this.ejbDescriptor.getName());
            _logger.log(Level.WARNING, "create object exception", ex);
            if (ex instanceof EJBException) {
                throw (EJBException)((Object)ex);
            }
            CreateException ce = new CreateException("ERROR creating stateful SessionBean");
            ce.initCause((Throwable)ex);
            throw ce;
        }
    }

    EJBObjectImpl createRemoteBusinessObjectImpl() throws CreateException, RemoteException {
        try {
            SessionContextImpl context = this.createBeanInstance();
            EJBObjectImpl ejbBusinessObjImpl = this.createRemoteBusinessObjectImpl(context);
            this.afterInstanceCreation(context);
            return ejbBusinessObjImpl;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.create_ejbobject_exception", this.ejbDescriptor.getName());
            _logger.log(Level.WARNING, "create object exception", ex);
            if (ex instanceof EJBException) {
                throw (EJBException)((Object)ex);
            }
            CreateException ce = new CreateException("ERROR creating stateful SessionBean");
            ce.initCause((Throwable)ex);
            throw ce;
        }
    }

    EJBLocalObjectImpl createEJBLocalObjectImpl() throws CreateException {
        try {
            SessionContextImpl context = this.createBeanInstance();
            EJBLocalObjectImpl localObjImpl = this.createEJBLocalObjectImpl(context);
            this.afterInstanceCreation(context);
            return localObjImpl;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.create_ejblocalobject_exception", this.ejbDescriptor.getName());
            _logger.log(Level.WARNING, "create ejblocal object exception", ex);
            if (ex instanceof EJBException) {
                throw (EJBException)((Object)ex);
            }
            CreateException ce = new CreateException("ERROR creating stateful SessionBean");
            ce.initCause((Throwable)ex);
            throw ce;
        }
    }

    EJBLocalObjectImpl createEJBLocalBusinessObjectImpl() throws CreateException {
        try {
            SessionContextImpl context = this.createBeanInstance();
            EJBLocalObjectImpl localBusinessObjImpl = this.createEJBLocalBusinessObjectImpl(context);
            this.afterInstanceCreation(context);
            return localBusinessObjImpl;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.create_ejblocalobject_exception", this.ejbDescriptor.getName());
            _logger.log(Level.WARNING, "create ejblocal object exception", ex);
            if (ex instanceof EJBException) {
                throw (EJBException)((Object)ex);
            }
            CreateException ce = new CreateException("ERROR creating stateful SessionBean");
            ce.initCause((Throwable)ex);
            throw ce;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SessionContextImpl createBeanInstance() throws Exception {
        SessionContextImpl sessionContextImpl;
        block9: {
            Invocation i = null;
            try {
                Object ejb = this.ejbClass.newInstance();
                SessionContextImpl context = new SessionContextImpl(ejb, this);
                context.setInterceptorInstances(this.interceptorManager.createInterceptorInstances());
                Object sessionKey = this.uuidGenerator.createSessionKey();
                this.createExtendedEMs(context, sessionKey);
                i = new Invocation(ejb, this);
                i.context = context;
                this.invocationManager.preInvoke(i);
                if (ejb instanceof SessionBean) {
                    ((SessionBean)ejb).setSessionContext((SessionContext)context);
                }
                this.injectionManager.injectInstance(ejb, this.ejbDescriptor, false);
                for (Object interceptorInstance : context.getInterceptorInstances()) {
                    this.injectionManager.injectInstance(interceptorInstance, this.ejbDescriptor, false);
                }
                context.touch();
                this.sessionBeanCache.put(sessionKey, context);
                context.setInstanceKey(sessionKey);
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    _logger.log(this.TRACE_LEVEL, "[SFSBContainer] Created session: " + sessionKey);
                }
                sessionContextImpl = context;
                if (i == null) break block9;
            }
            catch (Exception ex) {
                try {
                    throw ex;
                    catch (Throwable t) {
                        EJBException ejbEx = new EJBException();
                        ejbEx.initCause(t);
                        throw ejbEx;
                    }
                }
                catch (Throwable throwable) {
                    if (i != null) {
                        this.invocationManager.postInvoke(i);
                    }
                    throw throwable;
                }
            }
            this.invocationManager.postInvoke(i);
        }
        return sessionContextImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExtendedEMs(SessionContextImpl ctx, Object sessionKey) {
        Set<EntityManagerReferenceDescriptor> emRefs = this.ejbDescriptor.getEntityManagerReferenceDescriptors();
        Iterator<EntityManagerReferenceDescriptor> iter = emRefs.iterator();
        HashSet<EEMRefInfo> eemRefInfos = new HashSet<EEMRefInfo>();
        while (iter.hasNext()) {
            EntityManagerReferenceDescriptor refDesc = iter.next();
            if (refDesc.getPersistenceContextType() != PersistenceContextType.EXTENDED) continue;
            String unitName = refDesc.getUnitName();
            EntityManagerFactory emf = EntityManagerFactoryWrapper.lookupEntityManagerFactory(1, unitName, this.ejbDescriptor);
            if (emf != null) {
                EntityManager em = this.findExtendedEMFromInvList(emf);
                if (em == null) {
                    try {
                        Map<String, String> properties = refDesc.getProperties();
                        em = emf.createEntityManager(properties);
                        if (em == null) {
                            throw new EJBException("EM is null. Couldn't create EntityManager for refName: " + refDesc.getName() + "; unitname: " + unitName);
                        }
                    }
                    catch (Throwable th) {
                        EJBException ejbEx = new EJBException("Couldn't create EntityManager for refName: " + refDesc.getName() + "; unitname: " + unitName);
                        ejbEx.initCause(th);
                        throw ejbEx;
                    }
                }
                String emRefName = refDesc.getName();
                long containerID = this.getContainerId();
                EEMRefInfo refInfo = null;
                Map<EntityManager, EEMRefInfo> map = extendedEMReferenceCountMap;
                synchronized (map) {
                    refInfo = extendedEMReferenceCountMap.get(em);
                    if (refInfo != null) {
                        refInfo.refCount++;
                    } else {
                        refInfo = new EEMRefInfo(emRefName, refDesc.getUnitName(), containerID, sessionKey, em, emf);
                        refInfo.refCount = 1;
                        extendedEMReferenceCountMap.put(em, refInfo);
                        eemKey2EEMMap.put(refInfo.getKey(), refInfo.getEntityManager());
                    }
                }
                ctx.addExtendedEntityManagerMapping(emf, refInfo);
                eemRefInfos.add(refInfo);
                continue;
            }
            throw new EJBException("EMF is null. Couldn't get extended EntityManager for refName: " + refDesc.getName() + "; unitname: " + unitName);
        }
        if (eemRefInfos.size() > 0) {
            ctx.setEEMRefInfos(eemRefInfos);
        }
    }

    private EntityManager findExtendedEMFromInvList(EntityManagerFactory emf) {
        EntityManager em = null;
        ComponentInvocation compInv = this.invocationManager.getCurrentInvocation();
        if (compInv != null && compInv.getInvocationType() == 1 && compInv.context instanceof SessionContextImpl) {
            SessionContextImpl ctxImpl = (SessionContextImpl)compInv.context;
            if (ctxImpl.container instanceof StatefulSessionContainer) {
                em = ctxImpl.getExtendedEntityManager(emf);
            }
        }
        return em;
    }

    private void afterInstanceCreation(SessionContextImpl context) throws Exception {
        context.setState(2);
        Invocation i = null;
        try {
            i = new Invocation(context.getEJB(), this);
            i.context = context;
            this.invocationManager.preInvoke(i);
            this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT, context);
        }
        catch (Throwable t) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(t);
            throw ejbEx;
        }
        finally {
            if (i != null) {
                this.invocationManager.postInvoke(i);
            }
        }
        ++this.statCreateCount;
        this.incrementMethodReadyStat();
    }

    private EJBLocalObjectImpl createEJBLocalObjectImpl(SessionContextImpl context) throws Exception {
        if (context.getEJBLocalObjectImpl() != null) {
            return context.getEJBLocalObjectImpl();
        }
        EJBLocalObjectImpl localObjImpl = this.instantiateEJBLocalObjectImpl();
        context.setEJBLocalObjectImpl(localObjImpl);
        localObjImpl.setContext(context);
        localObjImpl.setKey(context.getInstanceKey());
        if (this.hasLocalBusinessView) {
            this.createEJBLocalBusinessObjectImpl(context);
        }
        if (this.hasRemoteHomeView) {
            this.createEJBObjectImpl(context);
        }
        if (this.hasRemoteBusinessView) {
            this.createRemoteBusinessObjectImpl(context);
        }
        return localObjImpl;
    }

    private EJBLocalObjectImpl createEJBLocalBusinessObjectImpl(SessionContextImpl context) throws Exception {
        if (context.getEJBLocalBusinessObjectImpl() != null) {
            return context.getEJBLocalBusinessObjectImpl();
        }
        EJBLocalObjectImpl localBusinessObjImpl = this.instantiateEJBLocalBusinessObjectImpl();
        context.setEJBLocalBusinessObjectImpl(localBusinessObjImpl);
        localBusinessObjImpl.setContext(context);
        localBusinessObjImpl.setKey(context.getInstanceKey());
        if (this.hasLocalHomeView) {
            this.createEJBLocalObjectImpl(context);
        }
        if (this.hasRemoteHomeView) {
            this.createEJBObjectImpl(context);
        }
        if (this.hasRemoteBusinessView) {
            this.createRemoteBusinessObjectImpl(context);
        }
        return localBusinessObjImpl;
    }

    private EJBObjectImpl createEJBObjectImpl(SessionContextImpl context) throws Exception {
        if (context.getEJBObjectImpl() != null) {
            return context.getEJBObjectImpl();
        }
        EJBObjectImpl ejbObjImpl = this.instantiateEJBObjectImpl();
        context.setEJBObjectImpl(ejbObjImpl);
        ejbObjImpl.setContext(context);
        Object sessionKey = context.getInstanceKey();
        ejbObjImpl.setKey(sessionKey);
        byte[] sessionOID = this.uuidGenerator.keyToByteArray(sessionKey);
        EJBObject ejbStub = (EJBObject)this.remoteHomeRefFactory.createRemoteReference(sessionOID);
        context.setEJBStub(ejbStub);
        ejbObjImpl.setStub((Remote)ejbStub);
        if (this.hasRemoteBusinessView) {
            this.createRemoteBusinessObjectImpl(context);
        }
        if (this.isLocal) {
            if (this.hasLocalHomeView) {
                this.createEJBLocalObjectImpl(context);
            }
            if (this.hasLocalBusinessView) {
                this.createEJBLocalBusinessObjectImpl(context);
            }
        }
        return ejbObjImpl;
    }

    private EJBObjectImpl createRemoteBusinessObjectImpl(SessionContextImpl context) throws Exception {
        if (context.getEJBRemoteBusinessObjectImpl() != null) {
            return context.getEJBRemoteBusinessObjectImpl();
        }
        EJBObjectImpl ejbBusinessObjImpl = this.instantiateRemoteBusinessObjectImpl();
        context.setEJBRemoteBusinessObjectImpl(ejbBusinessObjImpl);
        ejbBusinessObjImpl.setContext(context);
        Object sessionKey = context.getInstanceKey();
        ejbBusinessObjImpl.setKey(sessionKey);
        byte[] sessionOID = this.uuidGenerator.keyToByteArray(sessionKey);
        for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
            Remote stub = next.referenceFactory.createRemoteReference(sessionOID);
            ejbBusinessObjImpl.setStub(next.generatedRemoteIntf.getName(), stub);
        }
        if (this.hasRemoteHomeView) {
            this.createEJBObjectImpl(context);
        }
        if (this.isLocal) {
            if (this.hasLocalHomeView) {
                this.createEJBLocalObjectImpl(context);
            }
            if (this.hasLocalBusinessView) {
                this.createEJBLocalBusinessObjectImpl(context);
            }
        }
        return ejbBusinessObjImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBean(EJBLocalRemoteObject ejbo, Method removeMethod, boolean local) throws RemoveException, EJBException {
        Invocation i = new Invocation();
        i.ejbObject = ejbo;
        i.isLocal = local;
        i.method = removeMethod;
        Class<?> declaringClass = removeMethod.getDeclaringClass();
        i.isHome = declaringClass == EJBHome.class || declaringClass == EJBLocalHome.class;
        try {
            this.preInvoke(i);
            this.removeBean(i);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "ejb.preinvoke_exception", e);
            i.exception = e;
        }
        finally {
            if (AppVerification.doInstrument()) {
                AppVerification.getInstrumentLogger().doInstrumentForEjb(this.ejbDescriptor, removeMethod, i.exception);
            }
            this.postInvoke(i);
        }
        if (i.exception != null) {
            if (i.exception instanceof RemoveException) {
                throw (RemoveException)i.exception;
            }
            if (i.exception instanceof RuntimeException) {
                throw (RuntimeException)i.exception;
            }
            if (i.exception instanceof Exception) {
                throw new EJBException((Exception)i.exception);
            }
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(i.exception);
            throw ejbEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBean(Invocation inv) throws RemoveException {
        try {
            ++this.statRemoveCount;
            SessionContextImpl sc = (SessionContextImpl)inv.context;
            Transaction tc = sc.getTransaction();
            if (tc != null && tc.getStatus() != 6) {
                throw new RemoveException("Cannot remove EJB: transaction in progress");
            }
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(this.TRACE_LEVEL, "[SFSBContainer] Removing session: " + sc.getInstanceKey());
            }
            sc.setInEjbRemove(true);
            try {
                this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY, sc);
            }
            catch (Throwable t) {
                _logger.log(Level.FINE, "exception thrown from SFSB PRE_DESTROY", t);
            }
            finally {
                sc.setInEjbRemove(false);
            }
            this.forceDestroyBean(sc);
        }
        catch (EJBException ex) {
            _logger.log(Level.FINE, "EJBException in removing bean", ex);
            throw ex;
        }
        catch (RemoveException ex) {
            _logger.log(Level.FINE, "Remove exception while removing bean", ex);
            throw ex;
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Some exception while removing bean", ex);
            throw new EJBException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceDestroyBean(EJBContextImpl ctx) {
        SessionContextImpl sc;
        SessionContextImpl sessionContextImpl = sc = (SessionContextImpl)ctx;
        synchronized (sessionContextImpl) {
            if (sc.getState() == 5) {
                return;
            }
            sc.setState(5);
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(this.TRACE_LEVEL, "[SFSBContainer] (Force)Destroying session: " + sc.getInstanceKey());
            }
            Transaction prevTx = sc.getTransaction();
            try {
                if (prevTx != null && prevTx.getStatus() != 6) {
                    prevTx.setRollbackOnly();
                }
            }
            catch (SystemException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
            catch (IllegalStateException ex) {
                throw new EJBException((Exception)ex);
            }
            Object sessionKey = sc.getInstanceKey();
            this.sessionBeanCache.remove(sessionKey, sc.existsInStore());
            if (this.isRemote) {
                if (this.hasRemoteHomeView) {
                    EJBObjectImpl ejbObjImpl = sc.getEJBObjectImpl();
                    ejbObjImpl.clearContext();
                    ejbObjImpl.setRemoved(true);
                    sc.setEJBObjectImpl(null);
                    this.remoteHomeRefFactory.destroyReference(ejbObjImpl.getStub(), ejbObjImpl.getEJBObject());
                }
                if (this.hasRemoteBusinessView) {
                    EJBObjectImpl ejbBusinessObjImpl = sc.getEJBRemoteBusinessObjectImpl();
                    ejbBusinessObjImpl.clearContext();
                    ejbBusinessObjImpl.setRemoved(true);
                    sc.setEJBRemoteBusinessObjectImpl(null);
                    for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
                        next.referenceFactory.destroyReference(ejbBusinessObjImpl.getStub(next.generatedRemoteIntf.getName()), ejbBusinessObjImpl.getEJBObject(next.generatedRemoteIntf.getName()));
                    }
                }
            }
            if (this.isLocal) {
                if (this.hasLocalHomeView) {
                    EJBLocalObjectImpl localObjImpl = sc.getEJBLocalObjectImpl();
                    localObjImpl.clearContext();
                    localObjImpl.setRemoved(true);
                    sc.setEJBLocalObjectImpl(null);
                }
                if (this.hasLocalBusinessView) {
                    EJBLocalObjectImpl localBusinessObjImpl = sc.getEJBLocalBusinessObjectImpl();
                    localBusinessObjImpl.clearContext();
                    localBusinessObjImpl.setRemoved(true);
                    sc.setEJBLocalBusinessObjectImpl(null);
                }
            }
            this.destroyExtendedEMsForContext(sc);
            this.transactionManager.ejbDestroyed(sc);
            if (this.checkpointPolicy.isHAEnabled()) {
                SFSBClientVersionManager.removeClientVersion(this.getContainerId(), sessionKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyExtendedEMsForContext(SessionContextImpl sc) {
        for (EntityManager em : sc.getExtendedEntityManagers()) {
            Map<EntityManager, EEMRefInfo> map = extendedEMReferenceCountMap;
            synchronized (map) {
                if (extendedEMReferenceCountMap.containsKey(em)) {
                    EEMRefInfo refInfo = extendedEMReferenceCountMap.get(em);
                    if (refInfo.refCount > 1) {
                        refInfo.refCount--;
                        _logger.log(Level.FINE, "Decremented RefCount ExtendedEM em: " + em);
                    } else {
                        _logger.log(Level.FINE, "DESTROYED ExtendedEM em: " + em);
                        refInfo = extendedEMReferenceCountMap.remove(em);
                        eemKey2EEMMap.remove(refInfo.getKey());
                        try {
                            em.close();
                        }
                        catch (Throwable th) {
                            _logger.log(Level.FINE, "Exception during em.close()", th);
                        }
                    }
                }
            }
        }
    }

    public boolean userTransactionMethodsAllowed(ComponentInvocation inv) {
        boolean utMethodsAllowed = false;
        if (this.isBeanManagedTran) {
            if (inv instanceof Invocation) {
                Invocation i = (Invocation)inv;
                SessionContextImpl sc = (SessionContextImpl)i.context;
                utMethodsAllowed = sc.getInstanceKey() != null;
            } else {
                utMethodsAllowed = true;
            }
        }
        return utMethodsAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimedoutBean(EJBContextImpl ctx) {
        EJBContextImpl eJBContextImpl = ctx;
        synchronized (eJBContextImpl) {
            if (ctx.getState() != 3) {
                try {
                    Object ejb = ctx.getEJB();
                    ctx.setInEjbRemove(true);
                    this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY, ctx);
                }
                catch (Throwable t) {
                    _logger.log(Level.FINE, "ejbRemove exception", t);
                }
                finally {
                    ctx.setInEjbRemove(false);
                }
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    SessionContextImpl sc = (SessionContextImpl)ctx;
                    _logger.log(this.TRACE_LEVEL, "[SFSBContainer] Removing TIMEDOUT session: " + sc.getInstanceKey());
                }
                this.forceDestroyBean(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionContextImpl _getContextForInstance(byte[] instanceKey) {
        Object sessionKey = this.uuidGenerator.byteArrayToKey(instanceKey, 0, -1);
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            _logger.log(this.TRACE_LEVEL, "[SFSBContainer] Got request for: " + sessionKey);
        }
        while (true) {
            SessionContextImpl sc;
            if ((sc = (SessionContextImpl)this.sessionBeanCache.lookupEJB(sessionKey, this, null)) == null) {
                throw new NoSuchObjectLocalException("Invalid Session Key ( " + sessionKey + ")");
            }
            SessionContextImpl sessionContextImpl = sc;
            synchronized (sessionContextImpl) {
                switch (sc.getState()) {
                    case 1: 
                    case 5: {
                        break;
                    }
                    default: {
                        return sc;
                    }
                }
            }
        }
    }

    EJBObjectImpl getEJBObjectImpl(byte[] instanceKey) {
        SessionContextImpl sc = this._getContextForInstance(instanceKey);
        return sc != null ? sc.getEJBObjectImpl() : null;
    }

    EJBObjectImpl getEJBRemoteBusinessObjectImpl(byte[] instanceKey) {
        SessionContextImpl sc = this._getContextForInstance(instanceKey);
        return sc != null ? sc.getEJBRemoteBusinessObjectImpl() : null;
    }

    EJBLocalObjectImpl getEJBLocalObjectImpl(Object sessionKey) {
        EJBLocalObjectImpl localObjImpl;
        try {
            localObjImpl = this.instantiateEJBLocalObjectImpl();
            localObjImpl.setKey(sessionKey);
        }
        catch (Exception ex) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)ex);
            throw ejbEx;
        }
        return localObjImpl;
    }

    EJBLocalObjectImpl getEJBLocalBusinessObjectImpl(Object sessionKey) {
        EJBLocalObjectImpl localBusinessObjImpl;
        try {
            localBusinessObjImpl = this.instantiateEJBLocalBusinessObjectImpl();
            localBusinessObjImpl.setKey(sessionKey);
        }
        catch (Exception ex) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)ex);
            throw ejbEx;
        }
        return localBusinessObjImpl;
    }

    void checkExists(EJBLocalRemoteObject ejbObj) {
        if (ejbObj.isRemoved()) {
            throw new NoSuchObjectLocalException("Bean has been removed");
        }
    }

    private final void logTraceInfo(Invocation inv, Object key, String message) {
        _logger.log(this.TRACE_LEVEL, this.traceInfoPrefix + message + " for " + inv.method.getName() + "; key: " + key);
    }

    private final void logTraceInfo(SessionContextImpl sc, String message) {
        _logger.log(this.TRACE_LEVEL, this.traceInfoPrefix + message + " for key: " + sc.getInstanceKey() + "; " + System.identityHashCode(sc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentContext _getContext(Invocation inv) {
        EJBLocalRemoteObject ejbo = inv.ejbObject;
        SessionContextImpl sc = ejbo.getContext();
        Object sessionKey = ejbo.getKey();
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            this.logTraceInfo(inv, sessionKey, "Trying to get context");
        }
        if (sc == null) {
            sc = (SessionContextImpl)this.sessionBeanCache.lookupEJB(sessionKey, this, ejbo);
        }
        if (sc == null || sc.getState() == 5) {
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                this.logTraceInfo(inv, sessionKey, "Context already destroyed");
            }
            throw new NoSuchObjectLocalException("The EJB does not exist. session-key: " + sessionKey);
        }
        SessionContextImpl context = null;
        SessionContextImpl sessionContextImpl = sc;
        synchronized (sessionContextImpl) {
            SessionContextImpl newSC = sc;
            if (sc.getState() == 1 && (newSC = (SessionContextImpl)this.sessionBeanCache.lookupEJB(sessionKey, this, ejbo)) == null) {
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    this.logTraceInfo(inv, sessionKey, "Context does not exist");
                }
                throw new NoSuchObjectLocalException("The EJB does not exist. key: " + sessionKey);
            }
            SessionContextImpl sessionContextImpl2 = newSC;
            synchronized (sessionContextImpl2) {
                if (newSC.getState() == 5) {
                    if (_logger.isLoggable(this.TRACE_LEVEL)) {
                        this.logTraceInfo(inv, sessionKey, "Got destroyed context");
                    }
                    throw new NoSuchObjectLocalException("The EJB does not exist. session-key: " + sessionKey);
                }
                if (newSC.getState() == 3) {
                    this.handleConcurrentInvocation(inv, sessionKey);
                }
                if (newSC.getState() == 2) {
                    this.decrementMethodReadyStat();
                }
                if (this.checkpointPolicy.isHAEnabled()) {
                    this.doVersionCheck(inv, sessionKey, sc);
                }
                newSC.setState(3);
                context = newSC;
            }
        }
        context.touch();
        if (context.existsInStore() && this.removalGracePeriodInSeconds > 0) {
            long now = System.currentTimeMillis();
            long threshold = now - (long)(this.removalGracePeriodInSeconds * 1000);
            if (context.getLastPersistedAt() <= threshold) {
                try {
                    this.sfsbStoreManager.updateLastAccessTime(sessionKey, now);
                    context.setLastPersistedAt(System.currentTimeMillis());
                }
                catch (SFSBStoreManagerException sfsbEx) {
                    _logger.log(Level.WARNING, "Couldn't update timestamp for: " + sessionKey + "; Exception: " + sfsbEx);
                    _logger.log(Level.FINE, "Couldn't update timestamp for: " + sessionKey, sfsbEx);
                }
            }
        }
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            this.logTraceInfo(inv, context, "Got Context!!");
        }
        return context;
    }

    public boolean isHAEnabled() {
        return this.checkpointPolicy.isHAEnabled();
    }

    private void doVersionCheck(Invocation inv, Object sessionKey, SessionContextImpl sc) {
        EJBLocalRemoteObject ejbLRO = inv.ejbObject;
        long clientVersion = -1L;
        if (!inv.isLocal) {
            clientVersion = SFSBVersionManager.getRequestClientVersion();
            SFSBVersionManager.clearRequestClientVersion();
            SFSBVersionManager.clearResponseClientVersion();
        }
        if (ejbLRO != null) {
            if (clientVersion == -1L) {
                clientVersion = ejbLRO.getSfsbClientVersion();
            }
            long ctxVersion = sc.getVersion();
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(this.TRACE_LEVEL, "doVersionCheck(): for: {" + this.ejbDescriptor.getName() + "." + inv.method.getName() + " <=> " + sessionKey + "} clientVersion: " + clientVersion + " == " + ctxVersion);
            }
            if (clientVersion > ctxVersion) {
                throw new NoSuchObjectLocalException("Found only a stale version  clientVersion: " + clientVersion + " contextVersion: " + ctxVersion);
            }
        }
    }

    private void handleConcurrentInvocation(Invocation inv, Object sessionKey) {
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            this.logTraceInfo(inv, sessionKey, "Another invocation in progress");
        }
        String errMsg = "SessionBean is executing another request. [session-key: " + sessionKey + "]";
        ConcurrentAccessException conEx = new ConcurrentAccessException(errMsg);
        if (inv.isBusinessInterface) {
            throw conEx;
        }
        throw new EJBException((Exception)conEx);
    }

    public void postInvokeTx(Invocation inv) throws Exception {
        if (inv.invocationInfo.removalInfo != null) {
            SessionContextImpl sc;
            Transaction tx;
            InvocationInfo invInfo = inv.invocationInfo;
            EjbRemovalInfo removeInfo = invInfo.removalInfo;
            if (!this.retainAfterRemoveMethod(inv, removeInfo) && (tx = (sc = (SessionContextImpl)inv.context).getTransaction()) != null) {
                ContainerSynchronization sync = this.containerFactory.getContainerSync(tx);
                sync.removeBean(sc);
            }
        }
        super.postInvokeTx(inv);
    }

    private boolean retainAfterRemoveMethod(Invocation inv, EjbRemovalInfo rInfo) {
        boolean retain = rInfo.getRetainIfException() && inv.exceptionFromBeanMethod != null && this.isApplicationException(inv.exceptionFromBeanMethod);
        return retain;
    }

    public void releaseContext(Invocation inv) {
        SessionContextImpl sc = (SessionContextImpl)inv.context;
        if (sc.getState() == 5) {
            return;
        }
        Transaction tx = sc.getTransaction();
        try {
            if (inv.invocationInfo.removalInfo != null) {
                InvocationInfo invInfo = inv.invocationInfo;
                EjbRemovalInfo removeInfo = invInfo.removalInfo;
                if (this.retainAfterRemoveMethod(inv, removeInfo)) {
                    _logger.log(Level.INFO, "Skipping destruction of SFSB " + invInfo.ejbName + " after @Remove method " + invInfo.method + " due to (retainIfException" + " == true) and exception " + inv.exception);
                } else {
                    try {
                        this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY, sc);
                    }
                    catch (Throwable t) {
                        _logger.log(Level.FINE, "@Remove.preDestroy exception", t);
                    }
                    this.forceDestroyBean(sc);
                }
            }
            if (tx == null || tx.getStatus() == 6) {
                if (sc.getState() != 2) {
                    if (sc.isAfterCompletionDelayed()) {
                        if (_logger.isLoggable(this.TRACE_LEVEL)) {
                            this.logTraceInfo(inv, sc, "Calling delayed afterCompletion");
                        }
                        this.callEjbAfterCompletion(sc, sc.getCompletedTxStatus());
                    }
                    if (sc.getState() != 5) {
                        sc.setState(2);
                        this.handleEndOfMethodCheckpoint(sc, inv);
                    }
                }
                if (sc.getState() != 5 && this.checkpointPolicy.isHAEnabled()) {
                    this.syncClientVersion(inv, sc);
                }
            } else {
                if (sc.getState() != 5 && this.checkpointPolicy.isHAEnabled()) {
                    this.syncClientVersion(inv, sc);
                }
                sc.setState(4);
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    this.logTraceInfo(inv, sc, "Marking state == INCOMPLETE_TX");
                }
            }
        }
        catch (SystemException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
    }

    void afterBegin(EJBContextImpl context) {
        if (this.isBeanManagedTran) {
            return;
        }
        Object ejb = context.getEJB();
        if (ejb instanceof SessionSynchronization) {
            SessionSynchronization sync = (SessionSynchronization)ejb;
            try {
                sync.afterBegin();
            }
            catch (Exception ex) {
                this.forceDestroyBean(context);
                throw new EJBException("Error during SessionSynchronization..afterBegin(), EJB instance discarded", ex);
            }
        }
        if (this.checkpointPolicy.isHAEnabled()) {
            ContainerSynchronization cSync = null;
            try {
                cSync = this.containerFactory.getContainerSync(context.getTransaction());
                cSync.registerForTxCheckpoint((SessionContextImpl)context);
            }
            catch (RollbackException rollEx) {
                _logger.log(Level.WARNING, "Cannot register bean for checkpointing", rollEx);
            }
            catch (SystemException sysEx) {
                _logger.log(Level.WARNING, "Cannot register bean for checkpointing", sysEx);
            }
        }
    }

    void beforeCompletion(EJBContextImpl context) {
        if (this.isBeanManagedTran) {
            return;
        }
        Object ejb = context.getEJB();
        if (!(ejb instanceof SessionSynchronization)) {
            return;
        }
        Invocation inv = new Invocation(ejb, this);
        inv.context = context;
        this.invocationManager.preInvoke(inv);
        try {
            this.transactionManager.enlistComponentResources();
            ((SessionSynchronization)ejb).beforeCompletion();
        }
        catch (Exception ex) {
            try {
                this.forceDestroyBean(context);
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "error destroying bean", e);
            }
            throw new EJBException("Error during SessionSynchronization.beforeCompletion, EJB instance discarded", ex);
        }
        finally {
            this.invocationManager.postInvoke(inv);
        }
    }

    void afterCompletion(EJBContextImpl context, int status) {
        if (context.getState() == 5) {
            return;
        }
        SessionContextImpl sc = (SessionContextImpl)context;
        Object ejb = sc.getEJB();
        boolean committed = status == 3 || status == 6;
        sc.setTransaction(null);
        if (!this.isBeanManagedTran && ejb instanceof SessionSynchronization) {
            if (sc.getState() == 3 && !sc.isTxCompleting()) {
                sc.setAfterCompletionDelayed(true);
                sc.setCompletedTxStatus(committed);
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    this.logTraceInfo(sc, "AfterCompletion delayed");
                }
                return;
            }
            this.callEjbAfterCompletion(sc, committed);
        }
        if (sc.getState() != 5) {
            if (this.checkpointPolicy.isHAEnabled()) {
                if (this.isBeanManagedTran) {
                    sc.setTxCheckpointDelayed(true);
                    if (_logger.isLoggable(this.TRACE_LEVEL)) {
                        this.logTraceInfo(sc, "(BMT)Checkpoint delayed");
                    }
                }
            } else if (!this.isBeanManagedTran) {
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    this.logTraceInfo(sc, "Released context");
                }
                sc.setState(2);
                this.incrementMethodReadyStat();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SFSBBeanState getSFSBBeanState(SessionContextImpl sc) {
        SFSBBeanState sfsbBeanState = null;
        try {
            if (this.containerState != 0 && this.containerState != 1) {
                _logger.log(Level.FINE, "getSFSBBeanState() returning because containerState: " + this.containerState);
                return null;
            }
            if (sc.getState() == 5) {
                return null;
            }
            Object ejb = sc.getEJB();
            ComponentInvocation ci = new ComponentInvocation(ejb, this, sc);
            this.invocationManager.preInvoke(ci);
            SessionContextImpl sessionContextImpl = sc;
            synchronized (sessionContextImpl) {
                try {
                    this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE, sc);
                    sc.setLastPersistedAt(System.currentTimeMillis());
                    long newCtxVersion = sc.incrementAndGetVersion();
                    byte[] serializedState = IOUtils.serializeObject(sc, true);
                    sfsbBeanState = this.sfsbStoreManager.createSFSBBeanState(sc.getInstanceKey(), System.currentTimeMillis(), !sc.existsInStore(), serializedState);
                    sfsbBeanState.setVersion(newCtxVersion);
                    this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE, sc);
                }
                catch (NotSerializableException serEx) {
                    _logger.log(Level.WARNING, "Error  during checkpoint (" + this.ejbDescriptor.getName() + ". Key: " + sc.getInstanceKey() + ") " + serEx);
                    _logger.log(Level.FINE, "sfsb checkpoint error. Key: " + sc.getInstanceKey(), serEx);
                    try {
                        this.forceDestroyBean(sc);
                    }
                    catch (Exception e) {
                        _logger.log(Level.FINE, "error destroying bean", e);
                    }
                }
                catch (Throwable ex) {
                    _logger.log(Level.WARNING, "ejb.sfsb_checkpoint_error", new Object[]{this.ejbDescriptor.getName()});
                    _logger.log(Level.WARNING, "sfsb checkpoint error. key: " + sc.getInstanceKey(), ex);
                    try {
                        this.forceDestroyBean(sc);
                    }
                    catch (Exception e) {
                        _logger.log(Level.FINE, "error destroying bean", e);
                    }
                }
                finally {
                    this.invocationManager.postInvoke(ci);
                }
            }
        }
        catch (Throwable th) {
            _logger.log(Level.WARNING, "ejb.sfsb_checkpoint_error", new Object[]{this.ejbDescriptor.getName()});
            _logger.log(Level.WARNING, "sfsb checkpoint error", th);
        }
        return sfsbBeanState;
    }

    void txCheckpointCompleted(SessionContextImpl sc) {
        if (sc.getState() != 5) {
            sc.setExistsInStore(true);
            sc.setState(2);
            this.incrementMethodReadyStat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callEjbAfterCompletion(SessionContextImpl context, boolean status) {
        Object ejb = context.getEJB();
        ComponentInvocation ci = new ComponentInvocation(ejb, this, context);
        this.invocationManager.preInvoke(ci);
        try {
            context.setInAfterCompletion(true);
            ((SessionSynchronization)ejb).afterCompletion(status);
            context.setAfterCompletionDelayed(false);
            context.setTxCompleting(false);
        }
        catch (Exception ex) {
            try {
                this.forceDestroyBean(context);
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "error removing bean", e);
            }
            _logger.log(Level.INFO, "ejb.aftercompletion_exception", ex);
        }
        finally {
            context.setInAfterCompletion(false);
            this.invocationManager.postInvoke(ci);
        }
    }

    public final boolean canPassivateEJB(ComponentContext context) {
        SessionContextImpl sc = (SessionContextImpl)context;
        return sc.getState() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean passivateEJB(ComponentContext context) {
        SessionContextImpl sc = (SessionContextImpl)context;
        boolean success = false;
        try {
            if (this.containerState != 0 && this.containerState != 1) {
                _logger.log(this.TRACE_LEVEL, "passivateEJB() returning because containerState: " + this.containerState);
                return false;
            }
            if (sc.getState() == 5) {
                return false;
            }
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(this.TRACE_LEVEL, this.traceInfoPrefix + "Passivating context " + sc.getInstanceKey() + "; current-state = " + StatefulSessionContainer.convertCtxStateToString(sc));
            }
            Object ejb = sc.getEJB();
            long passStartTime = -1L;
            if (this.sfsbStoreMonitor.isMonitoringOn()) {
                passStartTime = System.currentTimeMillis();
            }
            ComponentInvocation ci = new ComponentInvocation(ejb, this, sc);
            this.invocationManager.preInvoke(ci);
            boolean failed = false;
            success = false;
            SessionContextImpl sessionContextImpl = sc;
            synchronized (sessionContextImpl) {
                try {
                    if (!sc.canBePassivated()) {
                        boolean bl = false;
                        return bl;
                    }
                    sc.setState(1);
                    this.decrementMethodReadyStat();
                    this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE, sc);
                    sc.setLastPersistedAt(System.currentTimeMillis());
                    boolean saved = false;
                    try {
                        saved = this.sessionBeanCache.passivateEJB(sc, sc.getInstanceKey());
                    }
                    catch (EMNotSerializableException emNotSerEx) {
                        _logger.log(Level.WARNING, "Extended EM not serializable. Exception: " + emNotSerEx);
                        _logger.log(Level.FINE, "Extended EM not serializable", emNotSerEx);
                        saved = false;
                    }
                    if (!saved) {
                        this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE, sc);
                        sc.setState(2);
                        this.incrementMethodReadyStat();
                        boolean emNotSerEx = false;
                        return emNotSerEx;
                    }
                    this.sfsbStoreMonitor.incrementPassivationCount(true);
                    this.transactionManager.ejbDestroyed(sc);
                    this.decrementRefCountsForEEMs(sc);
                    if (this.isRemote) {
                        if (this.hasRemoteHomeView) {
                            EJBObjectImpl ejbObjImpl = sc.getEJBObjectImpl();
                            ejbObjImpl.clearContext();
                            sc.setEJBObjectImpl(null);
                            this.remoteHomeRefFactory.destroyReference(ejbObjImpl.getStub(), ejbObjImpl.getEJBObject());
                        }
                        if (this.hasRemoteBusinessView) {
                            EJBObjectImpl ejbBusinessObjImpl = sc.getEJBRemoteBusinessObjectImpl();
                            ejbBusinessObjImpl.clearContext();
                            sc.setEJBRemoteBusinessObjectImpl(null);
                            for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
                                next.referenceFactory.destroyReference(ejbBusinessObjImpl.getStub(), ejbBusinessObjImpl.getEJBObject(next.generatedRemoteIntf.getName()));
                            }
                        }
                    }
                    if (this.isLocal) {
                        long version = sc.getVersion();
                        if (this.hasLocalHomeView) {
                            EJBLocalObjectImpl localObjImpl = sc.getEJBLocalObjectImpl();
                            localObjImpl.setSfsbClientVersion(version);
                            localObjImpl.clearContext();
                            sc.setEJBLocalObjectImpl(null);
                        }
                        if (this.hasLocalBusinessView) {
                            EJBLocalObjectImpl localBusinessObjImpl = sc.getEJBLocalBusinessObjectImpl();
                            localBusinessObjImpl.setSfsbClientVersion(version);
                            localBusinessObjImpl.clearContext();
                            sc.setEJBLocalBusinessObjectImpl(null);
                        }
                    }
                    if (!_logger.isLoggable(this.TRACE_LEVEL)) return success;
                    this.logTraceInfo(sc, "Successfully passivated");
                }
                catch (NotSerializableException nsEx) {
                    this.sfsbStoreMonitor.incrementPassivationCount(false);
                    _logger.log(Level.WARNING, "Error during passivation: " + sc + "; " + nsEx);
                    _logger.log(Level.FINE, "sfsb passivation error", nsEx);
                    try {
                        this.forceDestroyBean(sc);
                    }
                    catch (Exception e) {
                        _logger.log(Level.FINE, "error destroying bean", e);
                    }
                }
                catch (Throwable ex) {
                    this.sfsbStoreMonitor.incrementPassivationCount(false);
                    _logger.log(Level.WARNING, "ejb.sfsb_passivation_error", new Object[]{this.ejbDescriptor.getName() + " <==> " + sc});
                    _logger.log(Level.WARNING, "sfsb passivation error. Key: " + sc.getInstanceKey(), ex);
                    try {
                        this.forceDestroyBean(sc);
                    }
                    catch (Exception e) {
                        _logger.log(Level.FINE, "error destroying bean", e);
                    }
                }
                finally {
                    this.invocationManager.postInvoke(ci);
                    if (passStartTime != -1L) {
                        long timeSpent = System.currentTimeMillis() - passStartTime;
                        this.sfsbStoreMonitor.setPassivationTime(timeSpent);
                    }
                }
                return success;
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.sfsb_passivation_error", new Object[]{this.ejbDescriptor.getName()});
            _logger.log(Level.WARNING, "sfsb passivation error", ex);
        }
        return success;
    }

    public final int getPassivationBatchCount() {
        return this.passivationBatchCount;
    }

    public final void setPassivationBatchCount(int count) {
        this.passivationBatchCount = count;
    }

    public final boolean passivateEJB(StatefulEJBContext sfsbCtx) {
        return this.passivateEJB((ComponentContext)sfsbCtx.getSessionContext());
    }

    public long getMethodReadyCount() {
        return this.statMethodReadyCount;
    }

    public long getPassiveCount() {
        return this.sfsbStoreMonitor == null ? 0L : (long)this.sfsbStoreMonitor.getNumPassivations();
    }

    public void activateEJB(Object sessionKey, StatefulEJBContext sfsbCtx, Object cookie) {
        SessionContextImpl context = (SessionContextImpl)sfsbCtx.getSessionContext();
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            this.logTraceInfo(context, "Attempting to activate");
        }
        EJBLocalRemoteObject ejbObject = (EJBLocalRemoteObject)cookie;
        Object ejb = context.getEJB();
        ComponentInvocation ci = new ComponentInvocation(ejb, this, context);
        this.invocationManager.preInvoke(ci);
        try {
            context.touch();
            context.setContainer(this);
            context.setState(2);
            this.incrementMethodReadyStat();
            context.setInstanceKey(sessionKey);
            context.setExistsInStore(true);
            if (ejbObject == null) {
                if (this.hasRemoteHomeView) {
                    this.createEJBObjectImpl(context);
                } else {
                    this.createRemoteBusinessObjectImpl(context);
                }
            } else if (ejbObject instanceof EJBObjectImpl) {
                EJBObjectImpl eo = (EJBObjectImpl)ejbObject;
                ejbObject.setContext(context);
                ejbObject.setKey(sessionKey);
                byte[] sessionOID = this.uuidGenerator.keyToByteArray(sessionKey);
                if (eo.isRemoteHomeView()) {
                    context.setEJBObjectImpl(eo);
                    EJBObject ejbStub = (EJBObject)this.remoteHomeRefFactory.createRemoteReference(sessionOID);
                    eo.setStub((Remote)ejbStub);
                    context.setEJBStub(ejbStub);
                    if (this.hasRemoteBusinessView) {
                        this.createRemoteBusinessObjectImpl(context);
                    }
                } else {
                    context.setEJBRemoteBusinessObjectImpl(eo);
                    for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
                        Remote stub = next.referenceFactory.createRemoteReference(sessionOID);
                        eo.setStub(next.generatedRemoteIntf.getName(), stub);
                    }
                    if (this.hasRemoteHomeView) {
                        this.createEJBObjectImpl(context);
                    }
                }
                if (this.isLocal) {
                    if (this.hasLocalHomeView) {
                        this.createEJBLocalObjectImpl(context);
                    }
                    if (this.hasLocalBusinessView) {
                        this.createEJBLocalBusinessObjectImpl(context);
                    }
                }
            } else if (ejbObject instanceof EJBLocalObjectImpl) {
                EJBLocalObjectImpl elo = (EJBLocalObjectImpl)ejbObject;
                ejbObject.setContext(context);
                ejbObject.setKey(sessionKey);
                if (elo.isLocalHomeView()) {
                    context.setEJBLocalObjectImpl(elo);
                    if (this.hasLocalBusinessView) {
                        this.createEJBLocalBusinessObjectImpl(context);
                    }
                } else {
                    context.setEJBLocalBusinessObjectImpl(elo);
                    if (this.hasLocalHomeView) {
                        this.createEJBLocalObjectImpl(context);
                    }
                }
                if (this.hasRemoteHomeView) {
                    this.createEJBObjectImpl(context);
                }
                if (this.hasRemoteBusinessView) {
                    this.createRemoteBusinessObjectImpl(context);
                }
            }
            this.repopulateEEMMapsInContext(sessionKey, context);
            try {
                this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE, context);
            }
            catch (Throwable th) {
                EJBException ejbEx = new EJBException("Error during activation" + sessionKey);
                ejbEx.initCause(th);
                throw ejbEx;
            }
            long now = System.currentTimeMillis();
            try {
                this.sfsbStoreManager.updateLastAccessTime(sessionKey, now);
                context.setLastPersistedAt(now);
            }
            catch (SFSBStoreManagerException sfsbEx) {
                _logger.log(Level.WARNING, "Couldn't update timestamp for: " + sessionKey + ";Exception: " + sfsbEx);
                _logger.log(Level.FINE, "Couldn't update timestamp for: " + sessionKey, sfsbEx);
            }
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                this.logTraceInfo(context, "Successfully activated");
            }
            _logger.log(Level.FINE, "Activated: " + sessionKey);
        }
        catch (Exception ex) {
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                this.logTraceInfo(context, "Failed to activate");
            }
            _logger.log(Level.SEVERE, "ejb.sfsb_activation_error", new Object[]{sessionKey});
            _logger.log(Level.SEVERE, "sfsb activation error. Key: " + sessionKey, ex);
            throw new EJBException("Unable to activate EJB for key: " + sessionKey, ex);
        }
        finally {
            this.invocationManager.postInvoke(ci);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementRefCountsForEEMs(SessionContextImpl context) {
        Collection<EEMRefInfo> allRefInfos = context.getAllEEMRefInfos();
        for (EEMRefInfo refInfo : allRefInfos) {
            EEMRefInfoKey key = refInfo.getKey();
            Map<EntityManager, EEMRefInfo> map = extendedEMReferenceCountMap;
            synchronized (map) {
                EEMRefInfo cachedRefInfo = extendedEMReferenceCountMap.get(refInfo.eem);
                if (cachedRefInfo != null) {
                    cachedRefInfo.refCount--;
                    if (cachedRefInfo.refCount == 0) {
                        extendedEMReferenceCountMap.remove(refInfo.eem);
                        eemKey2EEMMap.remove(key);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repopulateEEMMapsInContext(Object sessionKey, SessionContextImpl context) {
        Collection<EEMRefInfo> allRefInfos = context.getAllEEMRefInfos();
        for (EEMRefInfo refInfo : allRefInfos) {
            EEMRefInfoKey key = refInfo.getKey();
            Map<EntityManager, EEMRefInfo> map = extendedEMReferenceCountMap;
            synchronized (map) {
                EntityManager eMgr = eemKey2EEMMap.get(key);
                EEMRefInfo newRefInfo = null;
                if (eMgr != null) {
                    EEMRefInfo cachedRefInfo = extendedEMReferenceCountMap.get(eMgr);
                    context.addExtendedEntityManagerMapping(cachedRefInfo.getEntityManagerFactory(), cachedRefInfo);
                    cachedRefInfo.refCount++;
                    newRefInfo = cachedRefInfo;
                } else {
                    String emRefName = key.emRefName;
                    String unitName = refInfo.getUnitName();
                    EntityManagerFactory emf = EntityManagerFactoryWrapper.lookupEntityManagerFactory(1, unitName, this.ejbDescriptor);
                    if (emf != null) {
                        ObjectInputStream ois = null;
                        ByteArrayInputStream bis = null;
                        try {
                            bis = new ByteArrayInputStream(refInfo.serializedEEM);
                            ois = new ObjectInputStream(bis);
                            eMgr = (EntityManager)ois.readObject();
                            newRefInfo = new EEMRefInfo(emRefName, unitName, super.getContainerId(), sessionKey, eMgr, emf);
                            newRefInfo.refCount = 1;
                            extendedEMReferenceCountMap.put(eMgr, newRefInfo);
                            eemKey2EEMMap.put(newRefInfo.getKey(), newRefInfo.getEntityManager());
                        }
                        catch (Throwable th) {
                            EJBException ejbEx = new EJBException("Couldn't create EntityManager for refName: " + emRefName);
                            ejbEx.initCause(th);
                            throw ejbEx;
                        }
                        finally {
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (Throwable th) {}
                            }
                            if (bis != null) {
                                try {
                                    bis.close();
                                }
                                catch (Throwable th) {}
                            }
                        }
                    }
                    throw new EJBException("EMF is null. Couldn't get extended EntityManager for refName: " + emRefName);
                }
                context.addExtendedEntityManagerMapping(newRefInfo.getEntityManagerFactory(), newRefInfo);
            }
        }
    }

    public void invokePeriodically(long delay, long periodicity, Runnable target) {
        Timer timer = ContainerFactoryImpl.getContainerService().getTimer();
        PeriodicTask timerTask = new PeriodicTask(this.loader, target);
        timer.scheduleAtFixedRate((TimerTask)timerTask, delay, periodicity);
        this.scheduledTimerTasks.add(timerTask);
    }

    public ContainerService getContainerService() {
        return ContainerFactoryImpl.getContainerService();
    }

    public void onUndeploy(StatefulEJBContext sfsbCtx) {
        this.undeploy((SessionContextImpl)sfsbCtx.getSessionContext());
    }

    protected String[] getPre30LifecycleMethodNames() {
        return new String[]{null, "ejbRemove", "ejbPassivate", "ejbActivate"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onShutdown() {
        _logger.log(Level.FINE, "StatefulSessionContainer.onshutdown() called");
        ClassLoader origClassLoader = Utility.setContextClassLoader(this.loader);
        try {
            this.cancelAllTimerTasks();
            this.sessionBeanCache.shutdown();
            while (true) {
                ComponentContext ctx = null;
                Object object = this.asyncTaskSemaphore;
                synchronized (object) {
                    int sz = this.passivationCandidates.size();
                    if (sz <= 0) {
                        break;
                    }
                    ctx = (ComponentContext)this.passivationCandidates.remove(sz - 1);
                }
                this.passivateEJB(ctx);
            }
            super.onShutdown();
            this.sessionBeanCache.destroy();
            try {
                this.sfsbStoreManager.shutdown();
            }
            catch (SFSBStoreManagerException sfsbEx) {
                _logger.log(Level.WARNING, "[" + this.ejbName + "]: Error during " + "storeManager.shutdown()", sfsbEx);
            }
        }
        catch (Throwable th) {
            _logger.log(Level.WARNING, "[" + this.ejbName + "]: Error during " + " onShutdown()", th);
        }
        finally {
            Utility.setContextClassLoader(origClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        _logger.log(Level.FINE, "StatefulSessionContainer.undeploy() called");
        long myContainerId = this.getContainerId();
        super.setUndeployedState();
        ClassLoader origLoader = null;
        try {
            SessionContextImpl ctx;
            this.cancelAllTimerTasks();
            this.sessionBeanCache.setUndeployedState();
            origLoader = Utility.setContextClassLoader(this.loader);
            Iterator iter = this.sessionBeanCache.values();
            while (iter.hasNext()) {
                ctx = (SessionContextImpl)iter.next();
                this.invokePreDestroyAndUndeploy(ctx);
            }
            while (true) {
                ctx = null;
                Object object = this.asyncTaskSemaphore;
                synchronized (object) {
                    int sz = this.passivationCandidates.size();
                    if (sz <= 0) {
                        break;
                    }
                    ctx = (SessionContextImpl)this.passivationCandidates.remove(sz - 1);
                    this.invokePreDestroyAndUndeploy(ctx);
                }
            }
            this.sessionBeanCache.destroy();
            try {
                this.sfsbStoreManager.removeAll();
            }
            catch (SFSBStoreManagerException sfsbEx) {
                _logger.log(Level.WARNING, "[" + this.ejbName + "]: Error during " + "storeManager.shutdown()", sfsbEx);
            }
        }
        finally {
            super.undeploy();
            SFSBClientVersionManager.removeAllEntries(myContainerId);
            this.passivationCandidates = null;
            this.asyncTaskSemaphore = null;
            this.sessionBeanCache = null;
            if (origLoader != null) {
                Utility.setContextClassLoader(origLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokePreDestroyAndUndeploy(SessionContextImpl ctx) {
        try {
            ctx.setInEjbRemove(true);
            this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY, ctx);
        }
        catch (Throwable t) {
            _logger.log(Level.FINE, "exception thrown from SFSB PRE_DESTROY", t);
        }
        finally {
            ctx.setInEjbRemove(false);
        }
        try {
            this.undeploy(ctx);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "[" + this.ejbName + "]: Error while " + " undeploying ctx. Key: " + ctx.getInstanceKey());
            _logger.log(Level.FINE, "[" + this.ejbName + "]: Error while " + " undeploying ctx. Key: " + ctx.getInstanceKey(), ex);
        }
    }

    private void cancelAllTimerTasks() {
        try {
            int size = this.scheduledTimerTasks.size();
            for (int i = 0; i < size; ++i) {
                TimerTask task = (TimerTask)this.scheduledTimerTasks.get(i);
                task.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void undeploy(SessionContextImpl ctx) {
        if (ctx.getContainer() == this) {
            EJBObjectImpl ejbBusinessObjectImpl;
            EJBObjectImpl ejbObjectImpl;
            if (this.hasRemoteHomeView && (ejbObjectImpl = ctx.getEJBObjectImpl()) != null) {
                this.remoteHomeRefFactory.destroyReference(ejbObjectImpl.getStub(), ejbObjectImpl.getEJBObject());
            }
            if (this.hasRemoteBusinessView && (ejbBusinessObjectImpl = ctx.getEJBRemoteBusinessObjectImpl()) != null) {
                for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
                    next.referenceFactory.destroyReference(ejbBusinessObjectImpl.getStub(next.generatedRemoteIntf.getName()), ejbBusinessObjectImpl.getEJBObject(next.generatedRemoteIntf.getName()));
                }
            }
            this.sessionBeanCache.remove(ctx.getInstanceKey(), ctx.existsInStore());
            this.destroyExtendedEMsForContext(ctx);
            this.transactionManager.ejbDestroyed(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimEvent(Object primaryKey, Object context) {
        boolean addTask = false;
        Object object = this.asyncTaskSemaphore;
        synchronized (object) {
            ++this.containerTrimCount;
            this.passivationCandidates.add(context);
            int requiredTaskCount = this.passivationCandidates.size() / this.passivationBatchCount;
            boolean bl = addTask = this.asyncTaskCount < requiredTaskCount;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "qSize: " + this.passivationCandidates.size() + "; batchCount: " + this.passivationBatchCount + "; asyncTaskCount: " + this.asyncTaskCount + "; requiredTaskCount: " + requiredTaskCount + "; ADDED TASK ==> " + addTask);
            }
            if (!addTask) {
                return;
            }
            ++this.asyncTaskCount;
            ++this.asyncCummTaskCount;
        }
        try {
            ASyncPassivator work = new ASyncPassivator();
            ContainerWorkPool.addLast(work);
        }
        catch (Exception ex) {
            Object object2 = this.asyncTaskSemaphore;
            synchronized (object2) {
                --this.asyncTaskCount;
            }
            _logger.log(Level.WARNING, "ejb.add_cleanup_task_error", ex);
        }
    }

    public void setSFSBUUIDUtil(SFSBUUIDUtil util) {
        this.uuidGenerator = util;
    }

    public void setCheckpointPolicy(CheckpointPolicy policy) {
        this.checkpointPolicy = policy;
    }

    public void setSFSBStoreManager(SFSBStoreManager storeManager) {
        this.sfsbStoreManager = storeManager;
    }

    public void setSessionCache(LruSessionCache cache) {
        this.sessionBeanCache = cache;
    }

    public SFSBStoreManager getSFSBStoreManager() {
        return this.sfsbStoreManager;
    }

    public void setRemovalGracePeriodInSeconds(int val) {
        this.removalGracePeriodInSeconds = val;
    }

    public void removeExpiredSessions() {
        try {
            _logger.log(Level.FINE, "StatefulContainer Removing expired sessions....");
            long val = this.sfsbStoreManager.removeExpiredSessions();
            this.sfsbStoreMonitor.incrementExpiredSessionsRemoved(val);
            _logger.log(Level.FINE, "StatefulContainer Removed " + val + " sessions....");
        }
        catch (SFSBStoreManagerException sfsbEx) {
            _logger.log(Level.WARNING, "Got exception from store manager", sfsbEx);
        }
    }

    private void handleEndOfMethodCheckpoint(SessionContextImpl sc, Invocation inv) {
        int txAttr = inv.invocationInfo.txAttr;
        switch (txAttr) {
            case 1: 
            case 4: 
            case 7: {
                if (!inv.invocationInfo.checkpointEnabled) break;
                this.checkpointEJB(sc);
                break;
            }
            case 2: {
                if (!sc.isTxCheckpointDelayed() && !inv.invocationInfo.checkpointEnabled) break;
                this.checkpointEJB(sc);
                sc.setTxCheckpointDelayed(false);
                break;
            }
            default: {
                if (!inv.invocationInfo.isCreateHomeFinder || !inv.invocationInfo.checkpointEnabled) break;
                this.checkpointEJB(sc);
            }
        }
        if (sc.getState() != 5) {
            sc.setState(2);
            this.incrementMethodReadyStat();
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                this.logTraceInfo(inv, sc.getInstanceKey(), "Released context");
            }
        }
    }

    private void syncClientVersion(Invocation inv, SessionContextImpl sc) {
        EJBLocalRemoteObject ejbLRO = inv.ejbObject;
        if (ejbLRO != null) {
            ejbLRO.setSfsbClientVersion(sc.getVersion());
        }
        if (!inv.isLocal && this.checkpointPolicy.isHAEnabled()) {
            long version = sc.getVersion();
            SFSBVersionManager.setResponseClientVersion(version);
            SFSBClientVersionManager.setClientVersion(this.getContainerId(), sc.getInstanceKey(), version);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Added [synced] version: " + sc.getVersion() + " for key: " + sc.getInstanceKey());
            }
        }
    }

    public int getMaxCacheSize() {
        return this.sessionBeanCache.getMaxCacheSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkpointEJB(SessionContextImpl sc) {
        boolean checkpointed = false;
        try {
            if (this.containerState != 0 && this.containerState != 1) {
                _logger.log(Level.FINE, "passivateEJB() returning because containerState: " + this.containerState);
                return false;
            }
            if (sc.getState() == 5) {
                return false;
            }
            Object ejb = sc.getEJB();
            long checkpointStartTime = -1L;
            if (this.sfsbStoreMonitor.isMonitoringOn()) {
                checkpointStartTime = System.currentTimeMillis();
            }
            ComponentInvocation ci = new ComponentInvocation(ejb, this, sc);
            this.invocationManager.preInvoke(ci);
            SessionContextImpl sessionContextImpl = sc;
            synchronized (sessionContextImpl) {
                try {
                    if (sc.getState() != 2) {
                        boolean bl = false;
                        return bl;
                    }
                    sc.setState(1);
                    this.decrementMethodReadyStat();
                    this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE, sc);
                    sc.setLastPersistedAt(System.currentTimeMillis());
                    byte[] serializedState = null;
                    try {
                        long newCtxVersion = sc.incrementAndGetVersion();
                        serializedState = IOUtils.serializeObject(sc, true);
                        SFSBBeanState beanState = this.sfsbStoreManager.createSFSBBeanState(sc.getInstanceKey(), sc.getLastAccessTime(), !sc.existsInStore(), serializedState);
                        beanState.setVersion(newCtxVersion);
                        this.sfsbStoreManager.checkpointSave(beanState);
                        sc.setLastPersistedAt(System.currentTimeMillis());
                        sc.setExistsInStore(true);
                        checkpointed = true;
                    }
                    catch (EMNotSerializableException emNotSerEx) {
                        _logger.log(Level.WARNING, "Error during checkpoint(, but session not destroyed)", emNotSerEx);
                    }
                    catch (NotSerializableException notSerEx) {
                        throw notSerEx;
                    }
                    catch (Exception ignorableEx) {
                        _logger.log(Level.WARNING, "Error during checkpoint", ignorableEx);
                    }
                    this.interceptorManager.intercept(LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE, sc);
                    sc.setState(2);
                    this.incrementMethodReadyStat();
                    this.sfsbStoreMonitor.setCheckpointSize(serializedState.length);
                    this.sfsbStoreMonitor.incrementCheckpointCount(true);
                }
                catch (Throwable ex) {
                    this.sfsbStoreMonitor.incrementCheckpointCount(false);
                    _logger.log(Level.WARNING, "ejb.sfsb_checkpoint_error", new Object[]{this.ejbDescriptor.getName()});
                    _logger.log(Level.WARNING, "sfsb checkpoint error. Key: " + sc.getInstanceKey(), ex);
                    try {
                        this.forceDestroyBean(sc);
                    }
                    catch (Exception e) {
                        _logger.log(Level.FINE, "error destroying bean", e);
                    }
                }
                finally {
                    this.invocationManager.postInvoke(ci);
                    if (checkpointStartTime != -1L) {
                        long timeSpent = System.currentTimeMillis() - checkpointStartTime;
                        this.sfsbStoreMonitor.setCheckpointTime(timeSpent);
                    }
                }
                return checkpointed;
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ejb.sfsb_passivation_error", new Object[]{this.ejbDescriptor.getName()});
            _logger.log(Level.WARNING, "sfsb passivation error", ex);
        }
        return checkpointed;
    }

    public void incrementMethodReadyStat() {
        ++this.statMethodReadyCount;
    }

    public void decrementMethodReadyStat() {
        --this.statMethodReadyCount;
    }

    static /* synthetic */ Object access$500(StatefulSessionContainer x0) {
        return x0.asyncTaskSemaphore;
    }

    static /* synthetic */ int access$610(StatefulSessionContainer x0) {
        return x0.asyncTaskCount--;
    }

    static class EMNotSerializableException
    extends NotSerializableException {
        public EMNotSerializableException(String className, Throwable th) {
            super(className);
            super.initCause(th);
        }
    }

    static class EEMRefInfo
    implements IndirectlySerializable,
    SerializableObjectFactory {
        private transient int refCount = 0;
        private String unitName;
        private EEMRefInfoKey eemRefInfoKey;
        private byte[] serializedEEM;
        private transient EntityManager eem;
        private transient EntityManagerFactory emf;
        private int hc;

        EEMRefInfo(String emRefName, String uName, long containerID, Object instanceKey, EntityManager eem, EntityManagerFactory emf) {
            this.eemRefInfoKey = new EEMRefInfoKey(emRefName, containerID, instanceKey);
            this.eem = eem;
            this.emf = emf;
            this.unitName = uName;
        }

        EntityManager getEntityManager() {
            return this.eem;
        }

        EntityManagerFactory getEntityManagerFactory() {
            return this.emf;
        }

        EEMRefInfoKey getKey() {
            return this.eemRefInfoKey;
        }

        Object getSessionKey() {
            return this.eemRefInfoKey.instanceKey;
        }

        String getUnitName() {
            return this.unitName;
        }

        public SerializableObjectFactory getSerializableObjectFactory() throws IOException {
            ByteArrayOutputStream bos = null;
            ObjectOutputStream oos = null;
            try {
                bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(this.eem);
                oos.flush();
                bos.flush();
                this.serializedEEM = bos.toByteArray();
            }
            catch (NotSerializableException notSerEx) {
                throw new EMNotSerializableException(notSerEx.toString(), notSerEx);
            }
            catch (IOException ioEx) {
                throw new EMNotSerializableException(ioEx.toString(), ioEx);
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (Exception ex) {}
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception ex) {}
                }
            }
            return this;
        }

        public Object createObject() throws IOException {
            return this;
        }
    }

    static class EEMRefInfoKey
    implements Serializable {
        private String emRefName;
        private long containerID;
        private Object instanceKey;
        private int hc;

        EEMRefInfoKey(String en, long cid, Object ikey) {
            this.emRefName = en;
            this.containerID = cid;
            this.instanceKey = ikey;
            this.hc = this.instanceKey.hashCode();
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof EEMRefInfoKey) {
                EEMRefInfoKey other = (EEMRefInfoKey)obj;
                result = this.containerID == other.containerID && this.emRefName.equals(other.emRefName) && this.instanceKey.equals(other.instanceKey);
            }
            return result;
        }

        public String toString() {
            return "<" + this.instanceKey + ":" + this.emRefName + ":" + this.containerID + ">";
        }
    }

    private class ASyncPassivator
    implements Servicable {
        private ASyncPassivator() {
        }

        public void prolog() {
        }

        public void epilog() {
        }

        public void service() {
            this.run();
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

