/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Invocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.callflow.CallFlowInfo;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.util.io.FileUtils;
import java.lang.reflect.Method;
import java.security.Principal;

final class CallFlowInfoImpl
implements CallFlowInfo {
    private final BaseContainer container;
    private final EjbDescriptor ejbDescriptor;
    private final String appName;
    private final String modName;
    private final String ejbName;
    private final ComponentType componentType;
    private final InvocationManager invocationManager;
    private final J2EETransactionManager transactionManager;

    CallFlowInfoImpl(BaseContainer container, EjbDescriptor descriptor, ComponentType compType) {
        this.container = container;
        this.ejbDescriptor = descriptor;
        this.appName = this.ejbDescriptor.getApplication().isVirtual() ? null : this.ejbDescriptor.getApplication().getRegistrationName();
        String archiveuri = this.ejbDescriptor.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
        this.modName = FileUtils.makeFriendlyFilename(archiveuri);
        this.ejbName = this.ejbDescriptor.getName();
        this.componentType = compType;
        this.invocationManager = Switch.getSwitch().getInvocationManager();
        this.transactionManager = Switch.getSwitch().getTransactionManager();
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.modName;
    }

    public String getComponentName() {
        return this.ejbName;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public Method getMethod() {
        Invocation inv = (Invocation)this.invocationManager.getCurrentInvocation();
        return inv.method;
    }

    public String getTransactionId() {
        J2EETransaction tx = null;
        try {
            tx = (J2EETransaction)this.transactionManager.getTransaction();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tx == null ? null : tx.getTransactionId();
    }

    public String getCallerPrincipal() {
        Principal principal = this.container.getSecurityManager().getCallerPrincipal();
        return principal != null ? principal.getName() : null;
    }

    public Throwable getException() {
        return ((Invocation)this.invocationManager.getCurrentInvocation()).exception;
    }
}

