/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.stats;

import com.sun.ejb.base.stats.EJBMethodStatsImpl;
import com.sun.ejb.base.stats.MethodMonitor;
import com.sun.ejb.spi.stats.EJBMethodStatsManager;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.EJBMethodStats;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class EJBMethodStatsManagerImpl
implements EJBMethodStatsManager {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private MonitoringRegistry registry;
    private final String appName;
    private final String modName;
    private final String ejbName;
    private final MonitoredObjectType ejbType;
    private Method[] methods;
    private boolean methodMonitorOn;
    private MethodMonitor[] methodMonitors;
    private HashMap methodMonitorMap;
    private Object lock = new Object();
    private Object[] logParams = null;
    private boolean prefixWithClassName;

    EJBMethodStatsManagerImpl(MonitoringRegistry registry, MonitoredObjectType ejbType, String ejbName, String modName, String appName) {
        this.registry = registry;
        this.ejbType = ejbType;
        this.ejbName = ejbName;
        this.modName = modName;
        this.appName = appName;
        this.logParams = new Object[]{ejbName, modName, appName};
    }

    public final boolean isMethodMonitorOn() {
        return this.methodMonitorOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void preInvoke(Method method) {
        if (this.methodMonitorOn) {
            MethodMonitor monitor = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.methodMonitorOn) {
                    monitor = (MethodMonitor)this.methodMonitorMap.get(method);
                }
            }
            if (monitor != null) {
                monitor.preInvoke();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postInvoke(Method method, Throwable th) {
        if (this.methodMonitorOn) {
            MethodMonitor monitor = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.methodMonitorOn) {
                    monitor = (MethodMonitor)this.methodMonitorMap.get(method);
                }
            }
            if (monitor != null) {
                monitor.postInvoke(th);
            }
        }
    }

    public MethodMonitor[] getMethodMonitors() {
        return this.methodMonitors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        Object object = this.lock;
        synchronized (object) {
            this.methodMonitorOn = false;
        }
        this.deregisterStats();
        this.methods = null;
        this.methodMonitors = null;
        this.methodMonitorMap = null;
        this.registry = null;
    }

    void registerMethods(Method[] methods, boolean prefixWithClassName) {
        this.prefixWithClassName = prefixWithClassName;
        this.methods = methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMethodMonitorOn(boolean monitorOn) {
        if (this.methods == null) {
            _logger.log(Level.WARNING, "base.stats.method.nomethods", this.logParams);
            return;
        }
        int size = this.methods.length;
        if (monitorOn) {
            this.methodMonitors = new MethodMonitor[size];
            HashMap<Method, MethodMonitor> map = new HashMap<Method, MethodMonitor>();
            for (int i = 0; i < size; ++i) {
                Object[] params;
                this.methodMonitors[i] = new MethodMonitor(this.methods[i], this.prefixWithClassName);
                map.put(this.methods[i], this.methodMonitors[i]);
                EJBMethodStatsImpl impl = new EJBMethodStatsImpl(this.methodMonitors[i]);
                try {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Registering method: " + this.methodMonitors[i].getMethodName() + "; for " + this.appName + "; " + this.modName + "; " + this.ejbName);
                    }
                    this.registry.registerEJBMethodStats((EJBMethodStats)impl, this.methodMonitors[i].getMethodName(), this.ejbType, this.ejbName, this.modName, this.appName, null);
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "Registered method: " + this.methodMonitors[i].getMethodName() + "; for " + this.appName + "; " + this.modName + "; " + this.ejbName);
                    continue;
                }
                catch (MonitoringRegistrationException monRegEx) {
                    params = new Object[]{this.ejbName, this.modName, this.appName, this.methodMonitors[i].getMethodName()};
                    _logger.log(Level.WARNING, "base.stats.method.register.monreg.error", params);
                    _logger.log(Level.FINE, "", monRegEx);
                    continue;
                }
                catch (Exception ex) {
                    params = new Object[]{this.ejbName, this.modName, this.appName, this.methodMonitors[i].getMethodName()};
                    _logger.log(Level.WARNING, "base.stats.method.register.error", params);
                    _logger.log(Level.FINE, "", ex);
                }
            }
            this.methodMonitorMap = map;
            Object object = this.lock;
            synchronized (object) {
                this.methodMonitorOn = true;
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.methodMonitorOn = false;
        }
        this.deregisterStats();
        this.methodMonitorMap = null;
        this.methodMonitors = null;
    }

    void appendStats(StringBuffer sbuf) {
        if (this.methodMonitors != null) {
            int size = this.methods.length;
            for (int i = 0; i < size; ++i) {
                MethodMonitor monitor = this.methodMonitors[i];
                monitor.appendStats(sbuf);
            }
        }
    }

    private void deregisterStats() {
        if (this.methodMonitors == null) {
            return;
        }
        int size = this.methodMonitors.length;
        for (int i = 0; i < size; ++i) {
            Object[] params;
            try {
                this.registry.unregisterEJBMethodStats(this.methodMonitors[i].getMethodName(), this.ejbType, this.ejbName, this.modName, this.appName);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Unregistered method: " + this.methodMonitors[i].getMethodName() + "; for " + this.appName + "; " + this.modName + "; " + this.ejbName);
                continue;
            }
            catch (MonitoringRegistrationException monRegEx) {
                params = new Object[]{this.ejbName, this.modName, this.appName, this.methodMonitors[i].getMethodName()};
                _logger.log(Level.FINE, "base.stats.method.unregister.monreg.error", params);
                _logger.log(Level.FINE, "", monRegEx);
                continue;
            }
            catch (Exception ex) {
                params = new Object[]{this.ejbName, this.modName, this.appName, this.methodMonitors[i].getMethodName()};
                _logger.log(Level.WARNING, "base.stats.method.unregister.error", params);
                _logger.log(Level.FINE, "", ex);
            }
        }
        this.methodMonitors = null;
    }
}

