/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.file;

import com.sun.corba.ee.spi.orbutil.file.FileWrapper;
import com.sun.corba.ee.spi.orbutil.generic.UnaryBooleanFunction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scanner {
    private final List<File> roots;
    private final int verbose;
    private List<String> patternsToSkip;

    public Scanner(int verbose, List<File> files) {
        this.roots = files;
        this.verbose = verbose;
        this.patternsToSkip = new ArrayList<String>();
    }

    public Scanner(int verbose, File ... files) {
        this(verbose, Arrays.asList(files));
    }

    public void addDirectoryToSkip(String pattern) {
        this.patternsToSkip.add(pattern);
    }

    public boolean scan(Action action) throws IOException {
        boolean result = true;
        for (File file : this.roots) {
            if (file.isDirectory()) {
                if (!this.skipDirectory(file)) {
                    result = this.doScan(file, action);
                }
            } else {
                FileWrapper fw = new FileWrapper(file);
                result = action.evaluate(fw);
            }
            if (result) continue;
            break;
        }
        return result;
    }

    private boolean doScan(File file, Action action) throws IOException {
        boolean result = true;
        if (file.isDirectory()) {
            if (!this.skipDirectory(file)) {
                File f;
                File[] arr$ = file.listFiles();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (result = this.doScan(f = arr$[i$], action)); ++i$) {
                }
            }
        } else {
            FileWrapper fw = new FileWrapper(file);
            result = action.evaluate(fw);
        }
        return result;
    }

    private boolean skipDirectory(File file) {
        for (String pattern : this.patternsToSkip) {
            String absPath;
            if (!this.match(pattern, absPath = file.getAbsolutePath())) continue;
            if (this.verbose > 0) {
                System.out.println("Scanner: Skipping directory " + absPath + "(pattern " + pattern + ")");
            }
            return true;
        }
        if (this.verbose > 0) {
            System.out.println("Scanner: Not skipping directory " + file);
        }
        return false;
    }

    private boolean match(String pattern, String fname) {
        String separator = File.separator;
        StringTokenizer st = new StringTokenizer(fname, separator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!pattern.equals(token)) continue;
            if (this.verbose > 0) {
                System.out.println("fname " + fname + " matched on pattern " + pattern);
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Action
    extends UnaryBooleanFunction<FileWrapper> {
    }
}

