/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.impl.corba.ServerRequestImpl;
import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.encoding.MarshalInputStream;
import com.sun.corba.ee.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.logging.POASystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.RequestCanceledException;
import com.sun.corba.ee.impl.protocol.SpecialMethod;
import com.sun.corba.ee.pept.encoding.OutputObject;
import com.sun.corba.ee.pept.protocol.MessageMediator;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.oa.NullServant;
import com.sun.corba.ee.spi.oa.OADestroyed;
import com.sun.corba.ee.spi.oa.OAInvocationInfo;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.oa.ObjectAdapterFactory;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBVersion;
import com.sun.corba.ee.spi.orb.ORBVersionFactory;
import com.sun.corba.ee.spi.orb.ObjectKeyCacheEntry;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.protocol.CorbaServerRequestDispatcher;
import com.sun.corba.ee.spi.protocol.ForwardException;
import com.sun.corba.ee.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.ee.spi.servicecontext.CodeSetServiceContext;
import com.sun.corba.ee.spi.servicecontext.ORBVersionServiceContext;
import com.sun.corba.ee.spi.servicecontext.SendingContextServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContextDefaults;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import com.sun.corba.ee.spi.servicecontext.UEInfoServiceContext;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import javax.rmi.CORBA.Tie;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DynamicImplementation;
import org.omg.CORBA.ServerRequest;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.UnknownException;
import org.omg.PortableServer.Servant;

public class CorbaServerRequestDispatcherImpl
implements CorbaServerRequestDispatcher {
    protected ORB orb;
    private ORBUtilSystemException wrapper;
    private POASystemException poaWrapper;

    public CorbaServerRequestDispatcherImpl(ORB orb) {
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
        this.poaWrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_POA();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOR locate(ObjectKey okey) {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".locate->");
            }
            ObjectKeyTemplate oktemp = okey.getTemplate();
            try {
                this.checkServerId(okey);
            }
            catch (ForwardException fex) {
                IOR iOR = fex.getIOR();
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".locate<-");
                }
                return iOR;
            }
            this.findObjectAdapter(oktemp);
            IOR iOR = null;
            return iOR;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".locate<-");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(MessageMediator messageMediator) {
        CorbaMessageMediator request = (CorbaMessageMediator)messageMediator;
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".dispatch->: " + this.opAndId(request));
            }
            this.consumeServiceContexts(request);
            ((MarshalInputStream)((Object)request.getInputObject())).performORBVersionSpecificInit();
            ObjectKeyCacheEntry entry = request.getObjectKeyCacheEntry();
            ObjectKey okey = entry.getObjectKey();
            try {
                this.checkServerId(okey);
            }
            catch (ForwardException fex) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch: " + this.opAndId(request) + ": bad server id");
                }
                request.getProtocolHandler().createLocationForward(request, fex.getIOR(), null);
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch<-: " + this.opAndId(request));
                }
                return;
            }
            String operation = request.getOperationName();
            ObjectAdapter objectAdapter = entry.getObjectAdapter();
            try {
                byte[] objectId = okey.getId().getId();
                ObjectKeyTemplate oktemp = okey.getTemplate();
                if (objectAdapter == null) {
                    objectAdapter = this.findObjectAdapter(oktemp);
                    entry.setObjectAdapter(objectAdapter);
                }
                Object servant = this.getServantWithPI(request, objectAdapter, objectId, oktemp, operation);
                this.dispatchToServant(servant, request, objectId, objectAdapter);
            }
            catch (ForwardException ex) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch: " + this.opAndId(request) + ": ForwardException caught");
                }
                request.getProtocolHandler().createLocationForward(request, ex.getIOR(), null);
            }
            catch (OADestroyed ex) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch: " + this.opAndId(request) + ": OADestroyed exception caught");
                }
                entry.clearObjectAdapter();
                this.dispatch(request);
            }
            catch (RequestCanceledException ex) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch: " + this.opAndId(request) + ": RequestCanceledException caught");
                }
                throw ex;
            }
            catch (UnknownException ex) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch: " + this.opAndId(request) + ": UnknownException caught " + (Object)((Object)ex));
                }
                if (ex.originalEx instanceof RequestCanceledException) {
                    throw (RequestCanceledException)ex.originalEx;
                }
                ServiceContexts contexts = ServiceContextDefaults.makeServiceContexts(this.orb);
                UEInfoServiceContext usc = ServiceContextDefaults.makeUEInfoServiceContext(ex.originalEx);
                contexts.put(usc);
                UNKNOWN sysex = this.wrapper.unknownExceptionInDispatch(CompletionStatus.COMPLETED_MAYBE, ex);
                request.getProtocolHandler().createSystemExceptionResponse(request, (SystemException)((Object)sysex), contexts);
            }
            catch (Throwable ex) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatch: " + this.opAndId(request) + ": other exception " + ex);
                }
                request.getProtocolHandler().handleThrowableDuringServerDispatch(request, ex, CompletionStatus.COMPLETED_MAYBE);
            }
            return;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".dispatch<-: " + this.opAndId(request));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseServant(ObjectAdapter objectAdapter) {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".releaseServant->");
            }
            if (objectAdapter == null) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".releaseServant: null object adapter");
                }
                return;
            }
            try {
                objectAdapter.returnServant();
            }
            finally {
                objectAdapter.exit();
                this.orb.popInvocationInfo();
            }
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".releaseServant<-");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getServant(ObjectAdapter objectAdapter, byte[] objectId, String operation) throws OADestroyed {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".getServant->");
            }
            OAInvocationInfo info = objectAdapter.makeInvocationInfo(objectId);
            info.setOperation(operation);
            this.orb.pushInvocationInfo(info);
            objectAdapter.getInvocationServant(info);
            Object object = info.getServantContainer();
            return object;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".getServant<-");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getServantWithPI(CorbaMessageMediator request, ObjectAdapter objectAdapter, byte[] objectId, ObjectKeyTemplate oktemp, String operation) throws OADestroyed {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".getServantWithPI->");
            }
            this.orb.getPIHandler().initializeServerPIInfo(request, objectAdapter, objectId, oktemp);
            this.orb.getPIHandler().invokeServerPIStartingPoint();
            objectAdapter.enter();
            if (request != null) {
                request.setExecuteReturnServantInResponseConstructor(true);
            }
            Object servant = this.getServant(objectAdapter, objectId, operation);
            String mdi = "unknown";
            if (servant instanceof NullServant) {
                this.handleNullServant(operation, (NullServant)servant);
            } else {
                mdi = objectAdapter.getInterfaces(servant, objectId)[0];
            }
            this.orb.getPIHandler().setServerPIInfo(servant, mdi);
            if (servant != null && !(servant instanceof DynamicImplementation) && !(servant instanceof org.omg.PortableServer.DynamicImplementation) || SpecialMethod.getSpecialMethod(operation) != null) {
                this.orb.getPIHandler().invokeServerPIIntermediatePoint();
            }
            Object object = servant;
            return object;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".getServantWithPI<-");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkServerId(ObjectKey okey) {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".checkServerId->");
            }
            ObjectKeyTemplate oktemp = okey.getTemplate();
            int sId = oktemp.getServerId();
            int scid = oktemp.getSubcontractId();
            if (!this.orb.isLocalServerId(scid, sId)) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".checkServerId: bad server id");
                }
                this.orb.handleBadServerId(okey);
            }
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".checkServerId<-");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectAdapter findObjectAdapter(ObjectKeyTemplate oktemp) {
        try {
            int scid;
            RequestDispatcherRegistry scr;
            ObjectAdapterFactory oaf;
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".findObjectAdapter->");
            }
            if ((oaf = (scr = this.orb.getRequestDispatcherRegistry()).getObjectAdapterFactory(scid = oktemp.getSubcontractId())) == null) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".findObjectAdapter: failed to find ObjectAdapterFactory");
                }
                throw this.wrapper.noObjectAdapterFactory();
            }
            ObjectAdapterId oaid = oktemp.getObjectAdapterId();
            ObjectAdapter oa = oaf.find(oaid);
            if (oa == null) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".findObjectAdapter: failed to find ObjectAdaptor");
                }
                throw this.wrapper.badAdapterId();
            }
            ObjectAdapter objectAdapter = oa;
            return objectAdapter;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".findObjectAdapter<-");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNullServant(String operation, NullServant nserv) {
        try {
            SpecialMethod specialMethod;
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".handleNullServant->: " + operation);
            }
            if ((specialMethod = SpecialMethod.getSpecialMethod(operation)) == null || !specialMethod.isNonExistentMethod()) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".handleNullServant: " + operation + ": throwing OBJECT_NOT_EXIST");
                }
                throw nserv.getException();
            }
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".handleNullServant<-: " + operation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeServiceContexts(CorbaMessageMediator request) {
        try {
            ServiceContext sc;
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".consumeServiceContexts->: " + this.opAndId(request));
            }
            ServiceContexts ctxts = request.getRequestServiceContexts();
            GIOPVersion giopVersion = request.getGIOPVersion();
            boolean hasCodeSetContext = this.processCodeSetContext(request, ctxts);
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".consumeServiceContexts: " + this.opAndId(request) + ": GIOP version: " + giopVersion);
                this.dprint(".consumeServiceContexts: " + this.opAndId(request) + ": as code set context? " + hasCodeSetContext);
            }
            if ((sc = ctxts.get(6)) != null) {
                SendingContextServiceContext scsc = (SendingContextServiceContext)sc;
                IOR ior = scsc.getIOR();
                try {
                    ((CorbaConnection)request.getConnection()).setCodeBaseIOR(ior);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    throw this.wrapper.badStringifiedIor(t);
                }
            }
            boolean isForeignORB = false;
            if (giopVersion.equals(GIOPVersion.V1_0) && hasCodeSetContext) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".consumeServiceCOntexts: " + this.opAndId(request) + ": Determined to be an old Sun ORB");
                }
                this.orb.setORBVersion(ORBVersionFactory.getOLD());
            } else {
                isForeignORB = true;
            }
            sc = ctxts.get(1313165056);
            if (sc != null) {
                ORBVersionServiceContext ovsc = (ORBVersionServiceContext)sc;
                ORBVersion version = ovsc.getVersion();
                this.orb.setORBVersion(version);
                isForeignORB = false;
            }
            if (isForeignORB) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".consumeServiceContexts: " + this.opAndId(request) + ": Determined to be a foreign ORB");
                }
                this.orb.setORBVersion(ORBVersionFactory.getFOREIGN());
            }
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".consumeServiceContexts<-: " + this.opAndId(request));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CorbaMessageMediator dispatchToServant(Object servant, CorbaMessageMediator req, byte[] objectId, ObjectAdapter objectAdapter) {
        try {
            DynamicImplementation dynimpl;
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".dispatchToServant->: " + this.opAndId(req) + ": " + this.servantInfo(servant));
            }
            CorbaMessageMediator response = null;
            String operation = req.getOperationName();
            SpecialMethod method = SpecialMethod.getSpecialMethod(operation);
            if (method != null) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatchToServant: " + this.opAndId(req) + ": Handling special method: " + method.getName() + ": " + this.servantInfo(servant));
                }
                CorbaMessageMediator corbaMessageMediator = response = method.invoke(servant, req, objectId, objectAdapter);
                return corbaMessageMediator;
            }
            if (servant instanceof DynamicImplementation) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatchToServant: " + this.opAndId(req) + ": Handling old style DSI type servant: " + this.servantInfo(servant));
                }
                dynimpl = (DynamicImplementation)servant;
                ServerRequestImpl sreq = new ServerRequestImpl(req, this.orb);
                dynimpl.invoke((ServerRequest)sreq);
                response = this.handleDynamicResult(sreq, req);
            } else if (servant instanceof org.omg.PortableServer.DynamicImplementation) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatchToServant: " + this.opAndId(req) + ": Handling POA DSI type servant: " + this.servantInfo(servant));
                }
                dynimpl = (org.omg.PortableServer.DynamicImplementation)servant;
                ServerRequestImpl sreq = new ServerRequestImpl(req, this.orb);
                dynimpl.invoke((ServerRequest)sreq);
                response = this.handleDynamicResult(sreq, req);
            } else {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".dispatchToServant: " + this.opAndId(req) + ": Handling invoke handler type servant: " + this.servantInfo(servant));
                }
                InvokeHandler invhandle = (InvokeHandler)servant;
                OutputStream stream = null;
                try {
                    stream = invhandle._invoke(operation, (InputStream)req.getInputObject(), (ResponseHandler)req);
                }
                catch (BAD_OPERATION e) {
                    this.wrapper.badOperationFromInvoke(e, (Object)operation);
                    throw e;
                }
                response = (CorbaMessageMediator)((OutputObject)stream).getMessageMediator();
            }
            CorbaMessageMediator corbaMessageMediator = response;
            return corbaMessageMediator;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".dispatchToServant<-: " + this.opAndId(req) + ": " + this.servantInfo(servant));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CorbaMessageMediator handleDynamicResult(ServerRequestImpl sreq, CorbaMessageMediator req) {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".handleDynamicResult->: " + this.opAndId(req));
            }
            CorbaMessageMediator response = null;
            Any excany = sreq.checkResultCalled();
            if (excany == null) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".handleDynamicResult: " + this.opAndId(req) + ": handling normal result");
                }
                response = this.sendingReply(req);
                OutputStream os = (OutputStream)response.getOutputObject();
                sreq.marshalReplyParams(os);
            } else {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".handleDynamicResult: " + this.opAndId(req) + ": handling error");
                }
                response = this.sendingReply(req, excany);
            }
            CorbaMessageMediator corbaMessageMediator = response;
            return corbaMessageMediator;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".handleDynamicResult<-: " + this.opAndId(req));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CorbaMessageMediator sendingReply(CorbaMessageMediator req) {
        try {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".sendingReply->: " + this.opAndId(req));
            }
            ServiceContexts scs = ServiceContextDefaults.makeServiceContexts(this.orb);
            CorbaMessageMediator corbaMessageMediator = req.getProtocolHandler().createResponse(req, scs);
            return corbaMessageMediator;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".sendingReply<-: " + this.opAndId(req));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CorbaMessageMediator sendingReply(CorbaMessageMediator req, Any excany) {
        try {
            CorbaMessageMediator resp;
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".sendingReply/Any->: " + this.opAndId(req));
            }
            ServiceContexts scs = ServiceContextDefaults.makeServiceContexts(this.orb);
            String repId = null;
            try {
                repId = excany.type().id();
            }
            catch (BadKind e) {
                throw this.wrapper.problemWithExceptionTypecode(e);
            }
            if (ORBUtility.isSystemException(repId)) {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".sendingReply/Any: " + this.opAndId(req) + ": handling system exception");
                }
                InputStream in = excany.create_input_stream();
                SystemException ex = ORBUtility.readSystemException(in);
                resp = req.getProtocolHandler().createSystemExceptionResponse(req, ex, scs);
            } else {
                if (this.orb.subcontractDebugFlag) {
                    this.dprint(".sendingReply/Any: " + this.opAndId(req) + ": handling user exception");
                }
                resp = req.getProtocolHandler().createUserExceptionResponse(req, scs);
                OutputStream os = (OutputStream)resp.getOutputObject();
                excany.write_value(os);
            }
            CorbaMessageMediator corbaMessageMediator = resp;
            return corbaMessageMediator;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".sendingReply/Any<-: " + this.opAndId(req));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processCodeSetContext(CorbaMessageMediator request, ServiceContexts contexts) {
        try {
            ServiceContext sc;
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".processCodeSetContext->: " + this.opAndId(request));
            }
            if ((sc = contexts.get(1)) != null) {
                if (request.getConnection() == null) {
                    boolean bl = true;
                    return bl;
                }
                if (request.getGIOPVersion().equals(GIOPVersion.V1_0)) {
                    boolean bl = true;
                    return bl;
                }
                CodeSetServiceContext cssc = (CodeSetServiceContext)sc;
                CodeSetComponentInfo.CodeSetContext csctx = cssc.getCodeSetContext();
                if (((CorbaConnection)request.getConnection()).getCodeSetContext() == null) {
                    if (this.orb.subcontractDebugFlag) {
                        this.dprint(".processCodeSetContext: " + this.opAndId(request) + ": Setting code sets to: " + csctx);
                    }
                    ((CorbaConnection)request.getConnection()).setCodeSetContext(csctx);
                    if (csctx.getCharCodeSet() != OSFCodeSetRegistry.ISO_8859_1.getNumber()) {
                        ((MarshalInputStream)((Object)request.getInputObject())).resetCodeSetConverters();
                    }
                }
            }
            boolean bl = sc != null;
            return bl;
        }
        finally {
            if (this.orb.subcontractDebugFlag) {
                this.dprint(".processCodeSetContext<-: " + this.opAndId(request));
            }
        }
    }

    protected String servantInfo(Object servant) {
        String result = servant.toString();
        if (servant instanceof Servant) {
            Servant s = (Servant)servant;
            result = result + " " + s._all_interfaces(null, null)[0];
        }
        if (servant instanceof Tie) {
            Tie t = (Tie)servant;
            result = result + " " + t.getTarget();
        }
        return result;
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaServerRequestDispatcherImpl", msg);
    }

    protected String opAndId(CorbaMessageMediator mediator) {
        return ORBUtility.operationNameAndRequestId(mediator);
    }
}

