/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.fsm;

import com.sun.corba.ee.impl.orbutil.fsm.GuardedAction;
import com.sun.corba.ee.spi.orbutil.fsm.Action;
import com.sun.corba.ee.spi.orbutil.fsm.ActionBase;
import com.sun.corba.ee.spi.orbutil.fsm.FSM;
import com.sun.corba.ee.spi.orbutil.fsm.FSMImpl;
import com.sun.corba.ee.spi.orbutil.fsm.Guard;
import com.sun.corba.ee.spi.orbutil.fsm.Input;
import com.sun.corba.ee.spi.orbutil.fsm.State;
import com.sun.corba.ee.spi.orbutil.fsm.StateEngine;
import com.sun.corba.ee.spi.orbutil.fsm.StateImpl;
import java.util.Set;

public class StateEngineImpl
implements StateEngine {
    private static Action emptyAction = new ActionBase("Empty"){

        public void doIt(FSM fsm, Input in) {
        }
    };
    private boolean initializing = true;
    private Action defaultAction = new ActionBase("Invalid Transition"){

        public void doIt(FSM fsm, Input in) {
            throw new IllegalStateException("Invalid transition attempted from " + fsm.getState() + " under " + in);
        }
    };

    private void dprint(String msg) {
        System.out.println("StateEngineImpl: " + msg);
    }

    public StateEngine add(State oldState, Input input, Guard guard, Action action, State newState) throws IllegalArgumentException, IllegalStateException {
        this.mustBeInitializing();
        StateImpl oldStateImpl = (StateImpl)oldState;
        GuardedAction ga = new GuardedAction(guard, action, newState);
        oldStateImpl.addGuardedAction(input, ga);
        return this;
    }

    public StateEngine add(State oldState, Input input, Action action, State newState) throws IllegalArgumentException, IllegalStateException {
        this.mustBeInitializing();
        StateImpl oldStateImpl = (StateImpl)oldState;
        GuardedAction ta = new GuardedAction(action, newState);
        oldStateImpl.addGuardedAction(input, ta);
        return this;
    }

    public StateEngine setDefault(State oldState, Action action, State newState) throws IllegalArgumentException, IllegalStateException {
        this.mustBeInitializing();
        StateImpl oldStateImpl = (StateImpl)oldState;
        oldStateImpl.setDefaultAction(action);
        oldStateImpl.setDefaultNextState(newState);
        return this;
    }

    public StateEngine setDefault(State oldState, State newState) throws IllegalArgumentException, IllegalStateException {
        return this.setDefault(oldState, emptyAction, newState);
    }

    public StateEngine setDefault(State oldState) throws IllegalArgumentException, IllegalStateException {
        return this.setDefault(oldState, oldState);
    }

    public void done() throws IllegalStateException {
        this.mustBeInitializing();
        this.initializing = false;
    }

    public void setDefaultAction(Action act) throws IllegalStateException {
        this.mustBeInitializing();
        this.defaultAction = act;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(FSM fsm, Input in, boolean debug) {
        if (debug) {
            this.dprint("doIt enter: currentState = " + fsm.getState() + " in = " + in);
        }
        try {
            this.innerDoIt(fsm, in, debug);
        }
        finally {
            if (debug) {
                this.dprint("doIt exit");
            }
        }
    }

    private StateImpl getDefaultNextState(StateImpl currentState) {
        StateImpl nextState = (StateImpl)currentState.getDefaultNextState();
        if (nextState == null) {
            nextState = currentState;
        }
        return nextState;
    }

    private Action getDefaultAction(StateImpl currentState) {
        Action action = currentState.getDefaultAction();
        if (action == null) {
            action = this.defaultAction;
        }
        return action;
    }

    private void innerDoIt(FSM fsm, Input in, boolean debug) {
        if (debug) {
            this.dprint("Calling innerDoIt with input " + in);
        }
        StateImpl currentState = null;
        StateImpl nextState = null;
        Action action = null;
        boolean deferral = false;
        block0: do {
            Set gas;
            deferral = false;
            currentState = (StateImpl)fsm.getState();
            nextState = this.getDefaultNextState(currentState);
            action = this.getDefaultAction(currentState);
            if (debug) {
                this.dprint("currentState      = " + currentState);
                this.dprint("in                = " + in);
                this.dprint("default nextState = " + nextState);
                this.dprint("default action    = " + action);
            }
            if ((gas = currentState.getGuardedActions(in)) == null) continue;
            for (GuardedAction ga : gas) {
                Guard.Result gr = ga.getGuard().evaluate(fsm, in);
                if (debug) {
                    this.dprint("doIt: evaluated " + ga + " with result " + gr);
                }
                if (gr == Guard.Result.ENABLED) {
                    nextState = (StateImpl)ga.getNextState();
                    action = ga.getAction();
                    if (!debug) continue block0;
                    this.dprint("nextState = " + nextState);
                    this.dprint("action    = " + action);
                    continue block0;
                }
                if (gr != Guard.Result.DEFERED) continue;
                deferral = true;
                continue block0;
            }
        } while (deferral);
        this.performStateTransition(fsm, in, nextState, action, debug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performStateTransition(FSM fsm, Input in, StateImpl nextState, Action action, boolean debug) {
        boolean different;
        block17: {
            StateImpl currentState = (StateImpl)fsm.getState();
            boolean bl = different = !currentState.equals(nextState);
            if (different) {
                if (debug) {
                    this.dprint("doIt: executing postAction for state " + currentState);
                }
                try {
                    currentState.postAction(fsm);
                }
                catch (Throwable thr) {
                    if (debug) {
                        this.dprint("doIt: postAction threw " + thr);
                    }
                    if (!(thr instanceof ThreadDeath)) break block17;
                    throw (ThreadDeath)thr;
                }
            }
        }
        try {
            if (action != null) {
                action.doIt(fsm, in);
            }
        }
        finally {
            if (different) {
                block19: {
                    if (debug) {
                        this.dprint("doIt: executing preAction for state " + nextState);
                    }
                    try {
                        nextState.preAction(fsm);
                    }
                    catch (Throwable thr) {
                        if (debug) {
                            this.dprint("doIt: preAction threw " + thr);
                        }
                        if (!(thr instanceof ThreadDeath)) break block19;
                        throw (ThreadDeath)thr;
                    }
                }
                ((FSMImpl)fsm).internalSetState(nextState);
            }
            if (debug) {
                this.dprint("doIt: state is now " + nextState);
            }
        }
    }

    public FSM makeFSM(State startState) throws IllegalStateException {
        this.mustNotBeInitializing();
        return new FSMImpl(this, startState);
    }

    private void mustBeInitializing() throws IllegalStateException {
        if (!this.initializing) {
            throw new IllegalStateException("Invalid method call after initialization completed");
        }
    }

    private void mustNotBeInitializing() throws IllegalStateException {
        if (this.initializing) {
            throw new IllegalStateException("Invalid method call before initialization completed");
        }
    }
}

