/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class PLBootstrap {
    public static final String INSTALL_ROOT_PROPERTY_NAME = "com.sun.aas.installRoot";
    public static final String PROCESS_LAUCHER_PROPERTIES_FILE_NAME = "processLauncher.properties";
    public static final String PROCESS_LAUCHER_LIBRARIES = "processLauncher.libraries";
    public static final String PROCESS_LAUCHER_MAIN_CLASS = "processLauncher.main.class";
    public static final boolean bDebug = false;

    public static void main(String[] args) {
        try {
            String appservLibPath;
            File propertiesFile;
            Properties props = System.getProperties();
            String installRoot = System.getProperty(INSTALL_ROOT_PROPERTY_NAME);
            if (installRoot == null) {
                System.out.println("ERROR: The System property \"com.sun.aas.installRoot\" has to be set!");
                System.exit(1);
            }
            if (!(propertiesFile = new File((appservLibPath = installRoot + File.separator + "lib" + File.separator) + PROCESS_LAUCHER_PROPERTIES_FILE_NAME)).canRead()) {
                throw new FileNotFoundException(propertiesFile.getPath());
            }
            Properties properties = new Properties();
            FileInputStream fInput = new FileInputStream(propertiesFile);
            properties.load(fInput);
            fInput.close();
            URL[] classJars = PLBootstrap.stringToURLArray(appservLibPath, properties.getProperty(PROCESS_LAUCHER_LIBRARIES));
            URLClassLoader classLoader = new URLClassLoader(classJars, Thread.currentThread().getContextClassLoader());
            Class<?> plClass = classLoader.loadClass(properties.getProperty(PROCESS_LAUCHER_MAIN_CLASS));
            Method mainMethod = plClass.getDeclaredMethod("bootstrap", String[].class);
            mainMethod.invoke(null, new Object[]{args});
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private static URL[] stringToURLArray(String appservLibPath, String jarList) throws MalformedURLException {
        if (jarList == null || jarList.equals("")) {
            return new URL[0];
        }
        ArrayList<URL> jars = new ArrayList<URL>();
        StringTokenizer stJars = new StringTokenizer(jarList, ",");
        URL resultantURL = null;
        String jarName = null;
        String jarPath = null;
        while (stJars.hasMoreTokens()) {
            jarName = stJars.nextToken().trim();
            jarPath = jarName.startsWith("/") ? jarName : appservLibPath + jarName;
            resultantURL = new URL("file:" + jarPath);
            jars.add(resultantURL);
        }
        return jars.toArray(new URL[jars.size()]);
    }
}

