/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.HAManagerBase;
import com.sun.enterprise.ee.web.sessmgmt.HAStore;
import com.sun.enterprise.ee.web.sessmgmt.WebModuleStatistics;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Session;

public class HABackgroundManager
extends HAManagerBase {
    private static final String info = "HABackgroundManager/1.0";
    private static final String name = "HABackgroundManager";
    private static Logger _logger = null;

    public String getInfo() {
        return info;
    }

    public String getName() {
        return name;
    }

    public HABackgroundManager() {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    protected Session createNewSession() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN HABackgroundManager>>createNewSession");
        }
        Session sess = super.createNewSession();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("GOT SESSION VIA FACTORY: Class = " + sess.getClass().getName());
        }
        return sess;
    }

    public String getMonitorAttributeValues() {
        StringBuffer sb = new StringBuffer(500);
        WebModuleStatistics stats = this.getWebModuleStatistics();
        sb.append("\nBACKGROUND_SAVE_LOW=" + stats.getBackgroundSaveLow());
        sb.append("\nBACKGROUND_SAVE_HIGH=" + stats.getBackgroundSaveHigh());
        sb.append("\nBACKGROUND_SAVE_AVG=" + stats.getBackgroundSaveAverage());
        sb.append("\nSESSION_SIZE_LOW=" + stats.getSessionSizeLow());
        sb.append("\nSESSION_SIZE_HIGH=" + stats.getSessionSizeHigh());
        sb.append("\nSESSION_SIZE_AVG=" + stats.getSessionSizeAverage());
        long cacheHits = stats.getCacheHits();
        long cacheMisses = stats.getCacheMisses();
        long cacheTotal = cacheHits + cacheMisses;
        long ratio = -1L;
        if (cacheTotal != 0L) {
            ratio = cacheHits / cacheTotal;
        }
        sb.append("\nCACHE_HIT_RATIO=" + ratio);
        int numCachedSessions = this.sessions.size();
        sb.append("\nNUMBER_CACHED_SESSIONS=" + numCachedSessions);
        HAStore store = (HAStore)this.getStore();
        int numStoredSessions = -1;
        try {
            numStoredSessions = store.getSize();
        }
        catch (Exception ex) {
            // empty catch block
        }
        int activeSessions = 0;
        int passivatedSessions = 0;
        if (numStoredSessions >= numCachedSessions) {
            activeSessions = numStoredSessions;
            passivatedSessions = numStoredSessions - numCachedSessions;
        } else {
            activeSessions = numCachedSessions;
        }
        sb.append("\nNUMBER_ACTIVE_SESSIONS=" + activeSessions);
        sb.append("\nNUMBER_PASSIVATED_SESSIONS=" + passivatedSessions);
        stats.resetStats();
        return sb.toString();
    }
}

