/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.authenticator;

import com.sun.enterprise.ee.web.authenticator.HASSO;
import com.sun.enterprise.ee.web.authenticator.HASingleSignOnEntry;
import com.sun.enterprise.ee.web.authenticator.SSOStorePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.HASession;
import com.sun.enterprise.ee.web.sessmgmt.StorePool;
import com.sun.enterprise.ee.web.sessmgmt.StorePoolElement;
import com.sun.enterprise.security.web.SingleSignOn;
import com.sun.enterprise.security.web.SingleSignOnEntry;
import com.sun.enterprise.web.ShutdownCleanupCapable;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;

public class HASingleSignOn
extends SingleSignOn
implements ShutdownCleanupCapable,
HASSO {
    private static Logger _logger = null;
    protected StorePool _pool = null;
    protected String _passedInPersistenceType = null;
    private Thread thread = null;
    private boolean threadDone = false;
    private Map _connectionsMap = Collections.synchronizedMap(new WeakHashMap(50));

    public String getPassedInPersistenceType() {
        return this._passedInPersistenceType;
    }

    public void setPassedInPersistenceType(String persistenceType) {
        this._passedInPersistenceType = persistenceType;
    }

    public HASingleSignOn() {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public void setSSOStorePool(StorePool pool) {
        this._pool = pool;
    }

    public StorePool getSSOStorePool() {
        return this._pool;
    }

    public void doCloseCachedConnection() {
    }

    public int doShutdownCleanup() {
        return this.closeAllConnections();
    }

    public int closeAllConnections() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HASingleSignOn.closeAllConnections()");
        }
        int count = 0;
        Set connections = this._connectionsMap.keySet();
        for (Connection nextConn : connections) {
            if (nextConn == null) continue;
            try {
                nextConn.close();
                ++count;
            }
            catch (SQLException ex) {}
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HASingleSignOn closed " + count + " connections during shutdown");
        }
        return count;
    }

    public synchronized void putConnection(Connection conn) {
        this._connectionsMap.put(conn, null);
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HASingleSignOn.invoke()");
        }
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            return 1;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        if (hreq.getUserPrincipal() != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Principal '" + hreq.getUserPrincipal().getName() + "' has already been authenticated");
            }
            return 1;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"JSESSIONIDSSO".equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("SSO cookie not present");
            }
            return 1;
        }
        Realm realm = request.getContext().getRealm();
        if (realm == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" No realm configured for this application, SSO does not apply.");
            }
            return 1;
        }
        String realmName = realm.getRealmName();
        if (realmName == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" No realm configured for this application, SSO does not apply.");
            }
            return 1;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Checking for cached principal for " + cookie.getValue());
        }
        if ((entry = this.lookupEntry(cookie.getValue())) != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Cached SingleSignOnEntry: " + entry);
            }
            if (!realmName.equals(entry.realmName)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Ignoring SSO entry which does not match application realm '" + realmName + "'");
                }
                return 1;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                if (entry.principal != null) {
                    _logger.finest("Found cached principal '" + entry.principal.getName() + "' with auth type '" + entry.authType + "'");
                } else {
                    _logger.finest("No cached principal found");
                }
            }
            if (entry.principal == null && entry.username != null) {
                entry.principal = ((RealmAdapter)request.getContext().getRealm()).createFailOveredPrincipal(entry.username);
            }
            request.setNote("org.apache.catalina.request.SSOID", (Object)cookie.getValue());
            ((HttpRequest)request).setAuthType(entry.authType);
            ((HttpRequest)request).setUserPrincipal(entry.principal);
            entry.lastAccessTime = System.currentTimeMillis();
            ((HASingleSignOnEntry)entry).dirty = true;
        } else {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            cookie.setPath("/");
            hres.addCookie(cookie);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleSignOnEntry lookupEntry(String ssoId) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HASingleSignOn.lookupEntry(): ssoId=" + ssoId);
        }
        SingleSignOnEntry ssoEntry = null;
        long startTime = System.currentTimeMillis();
        SSOStorePoolElement store = null;
        try {
            store = (SSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            ssoEntry = super.lookupEntry(ssoId);
            if (ssoEntry != null) {
                SingleSignOnEntry singleSignOnEntry = ssoEntry;
                return singleSignOnEntry;
            }
            try {
                ssoEntry = store.loadSSO(ssoId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ssoEntry != null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("lookup before :- ssoID=" + ssoId + "   " + ssoEntry);
                    _logger.finest("container= " + this.container + " realm= " + this.container.getRealm());
                    _logger.finest("lookup after if :- ssoID=" + ssoId + "   " + ssoEntry);
                }
                this.registerInMemory(ssoId, ssoEntry);
            }
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
        }
        finally {
            if (store != null) {
                try {
                    this._pool.put((StorePoolElement)store);
                    if (_logger.isLoggable(Level.FINEST)) {
                        long endTime = System.currentTimeMillis();
                        _logger.finest("lookup_TIME MILLIS = " + (endTime - startTime));
                    }
                }
                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
        return ssoEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerInMemory(String ssoId, SingleSignOnEntry sso) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(ssoId, sso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String ssoId, Principal principal, String authType, String username, String password, String realmName) {
        long startTime = System.currentTimeMillis();
        SSOStorePoolElement store = null;
        try {
            store = (SSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            HASingleSignOnEntry ssoEntry = new HASingleSignOnEntry(principal, authType, username, password, realmName);
            this.registerInMemory(ssoId, (SingleSignOnEntry)ssoEntry);
            if (!authType.equals("FORM") && !authType.equals("BASIC")) {
                return;
            }
            try {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("HASingleSignOn.register(): About to save: ssoId=" + ssoId + " ssoEntry=" + ssoEntry);
                }
                store.save(ssoId, (SingleSignOnEntry)ssoEntry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
        }
        finally {
            if (store != null) {
                try {
                    this._pool.put((StorePoolElement)store);
                    if (_logger.isLoggable(Level.FINEST)) {
                        long endTime = System.currentTimeMillis();
                        _logger.finest("register_TIME MILLIS = " + (endTime - startTime));
                    }
                }
                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
    }

    protected void deregister(String ssoId) {
        this.deregister(ssoId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, boolean bgCall) {
        if (_logger.isLoggable(Level.FINEST)) {
            if (bgCall) {
                _logger.finest("BackGround : Deregistering ssoId '" + ssoId + "'");
            } else {
                _logger.finest("ForeGround : Deregistering ssoId '" + ssoId + "'");
            }
        }
        SingleSignOnEntry sso = null;
        long startTime = System.currentTimeMillis();
        SSOStorePoolElement store = null;
        try {
            store = (SSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                sso = (SingleSignOnEntry)this.cache.remove(ssoId);
            }
            try {
                store.remove(ssoId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (sso == null) {
                return;
            }
            Session[] sessions = sso.findSessions();
            for (int i = 0; i < sessions.length; ++i) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Invalidating session " + sessions[i]);
                }
                HashMap hashMap2 = this.reverse;
                synchronized (hashMap2) {
                    this.reverse.remove(sessions[i]);
                }
                sessions[i].expire();
            }
            try {
                store.removeInActiveSessions(ssoId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
        }
        finally {
            if (store != null) {
                try {
                    this._pool.put((StorePoolElement)store);
                    if (_logger.isLoggable(Level.FINEST)) {
                        long endTime = System.currentTimeMillis();
                        _logger.finest("deregister_TIME MILLIS = " + (endTime - startTime));
                    }
                }
                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associate(String ssoId, Session session) {
        if (!this.started) {
            return;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HASingleSignOn.associate(): Associate sso id " + ssoId + " with session " + session);
        }
        long startTime = System.currentTimeMillis();
        SSOStorePoolElement store = null;
        try {
            store = (SSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            SingleSignOnEntry sso = this.lookupEntry(ssoId);
            if (sso != null) {
                sso.addSession((SingleSignOn)this, session);
            }
            HashMap hashMap = this.reverse;
            synchronized (hashMap) {
                this.reverse.put(session, ssoId);
            }
            try {
                if (session != null && session instanceof HASession) {
                    ((HASession)session).setSsoId(ssoId);
                    store.associate((StandardSession)session, ssoId);
                }
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Exception in HASingleSignOn.associate()", e);
            }
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
        }
        finally {
            if (store != null) {
                try {
                    this._pool.put((StorePoolElement)store);
                    if (_logger.isLoggable(Level.FINEST)) {
                        long endTime = System.currentTimeMillis();
                        _logger.finest("associate_TIME MILLIS = " + (endTime - startTime));
                    }
                }
                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        long startTime = System.currentTimeMillis();
        SSOStorePoolElement store = null;
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        try {
            store = (SSOStorePoolElement)this._pool.take();
            store.setContainer(this.getContainer());
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                for (String key : this.cache.keySet()) {
                    SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                    if (!((HASingleSignOnEntry)sso).dirty) continue;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Stop: updating the SSO session " + key);
                    }
                    store.save(key, sso);
                    ((HASingleSignOnEntry)sso).dirty = false;
                }
            }
        }
        catch (InterruptedException iex) {
            iex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (store != null) {
                try {
                    this._pool.put((StorePoolElement)store);
                    if (_logger.isLoggable(Level.FINEST)) {
                        long endTime = System.currentTimeMillis();
                        _logger.finest("stop_TIME MILLIS = " + (endTime - startTime));
                    }
                }
                catch (InterruptedException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
        this.threadStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpires() {
        long tooOld = System.currentTimeMillis() - (long)(this.getMaxInactive() * 1000);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(tooOld + "SSO Expiration thread started. Current entries: " + this.cache.size());
        }
        ArrayList<String> removals = new ArrayList<String>(this.cache.size() / 2);
        try {
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                for (String key : this.cache.keySet()) {
                    SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest(tooOld + "*******************  " + sso.lastAccessTime + "   SSO Expiration thread started. Current entries: " + this.cache.size());
                    }
                    if (sso.sessions.length != 0 || sso.lastAccessTime >= tooOld) continue;
                    removals.add(key);
                }
            }
            int removalCount = removals.size();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("SSO cache will expire " + removalCount + " entries.");
            }
            for (int i = 0; i < removalCount; ++i) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("SSO Expiration removing entry: " + removals.get(i));
                }
                this.deregister((String)removals.get(i), true);
            }
        }
        catch (Throwable e) {
            _logger.log(Level.WARNING, "Exception in HASingleSignOn.processExpires()", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdateLat() {
        long startTime = System.currentTimeMillis();
        SSOStorePoolElement store = null;
        Hashtable<String, SingleSignOnEntry> updatedLats = new Hashtable<String, SingleSignOnEntry>(this.cache.size() / 2);
        try {
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                for (String key : this.cache.keySet()) {
                    SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("====" + sso.lastAccessTime + "   SSO Expiration/Updation thread started. Current cache entries: " + this.cache.size());
                    }
                    if (!((HASingleSignOnEntry)sso).dirty) continue;
                    updatedLats.put(key, sso);
                }
            }
            int updatedLatsCount = updatedLats.size();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("SSO table will updated " + updatedLatsCount + " entries.");
            }
            try {
                store = (SSOStorePoolElement)this._pool.take();
                store.setContainer(this.getContainer());
                for (String ssoId : updatedLats.keySet()) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("SSO LATupdation updating entry: " + ssoId);
                    }
                    store.updateLastAccessTime(ssoId, ((SingleSignOnEntry)updatedLats.get((Object)ssoId)).lastAccessTime);
                    ((HASingleSignOnEntry)updatedLats.get((Object)ssoId)).dirty = false;
                }
            }
            catch (InterruptedException iex) {
                iex.printStackTrace();
            }
            finally {
                if (store != null) {
                    try {
                        this._pool.put((StorePoolElement)store);
                        if (_logger.isLoggable(Level.FINEST)) {
                            long endTime = System.currentTimeMillis();
                            _logger.finest("processUpdateLat_TIME MILLIS = " + (endTime - startTime));
                        }
                    }
                    catch (InterruptedException ex1) {
                        ex1.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable e) {
            _logger.log(Level.WARNING, "Exception in HASingleSignOn.processUpdateLat()", e);
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.getReapInterval() * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        String threadName = "HASingleSignOnExpiration";
        this.thread = new Thread((Runnable)((Object)this), threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.thread = null;
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
            this.processUpdateLat();
        }
    }
}

