/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.ArrayUtil;
import com.sun.appserv.management.util.misc.CompareUtil;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;
import java.util.AbstractList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CircularList<T>
extends AbstractList<T> {
    private final T[] mObjects;
    private int mNumItems;
    private int mFirst;
    private OverflowHandler mOverflowHandler;

    public CircularList(Class<T> theClass, int size) {
        if (size == 0) {
            throw new IllegalArgumentException("list must have at least one item");
        }
        this.mObjects = ArrayUtil.newArray(theClass, size);
        this.mFirst = 0;
        this.mNumItems = 0;
        this.mOverflowHandler = null;
    }

    public void setOverflowHandler(OverflowHandler handler) {
        this.mOverflowHandler = handler;
    }

    public OverflowHandler getOverflowHandler() {
        return this.mOverflowHandler;
    }

    @Override
    public final int size() {
        return this.mNumItems;
    }

    public final int capacity() {
        return this.mObjects.length;
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, (T)null);
        }
        this.mNumItems = 0;
        ++this.modCount;
    }

    private final int getPhysicalIndex(int logicalIndex) {
        return (this.mFirst + logicalIndex) % this.capacity();
    }

    @Override
    public final T get(int i) {
        this.checkInBounds(i);
        return this.mObjects[this.getPhysicalIndex(i)];
    }

    @Override
    public final T set(int i, T item) {
        this.checkInBounds(i);
        int physicalIndex = this.getPhysicalIndex(i);
        T oldItem = this.mObjects[physicalIndex];
        this.mObjects[physicalIndex] = item;
        return oldItem;
    }

    protected void discardedObject(T o) {
        if (this.mOverflowHandler != null) {
            this.mOverflowHandler.handleBufferOverflow(o);
        }
    }

    private final void store(int logicalIndex, T item) {
        this.mObjects[this.getPhysicalIndex((int)logicalIndex)] = item;
    }

    @Override
    public final boolean add(T item) {
        int capacity = this.capacity();
        assert (this.mFirst < capacity);
        if (this.size() == capacity) {
            T overwrittenObject = this.get(0);
            this.mFirst = (this.mFirst + 1) % capacity;
            this.store(capacity - 1, item);
            this.discardedObject(overwrittenObject);
        } else {
            this.store(this.mNumItems, item);
            ++this.mNumItems;
        }
        ++this.modCount;
        return true;
    }

    @Override
    public final void add(int index, T item) {
        if (index != this.mNumItems) {
            throw new UnsupportedOperationException("add not at end");
        }
        this.add(item);
    }

    @Override
    public final T remove(int i) {
        T result = null;
        if (i == 0) {
            result = this.removeFirst();
        } else if (i == this.mNumItems - 1) {
            result = this.removeLast();
        } else {
            throw new UnsupportedOperationException();
        }
        ++this.modCount;
        return result;
    }

    private final void checkInBounds(int i) {
        if (i < 0 || i >= this.mNumItems) {
            throw new IndexOutOfBoundsException("" + i);
        }
    }

    @Override
    public final T removeFirst() {
        this.checkInBounds(0);
        T result = this.get(0);
        --this.mNumItems;
        this.mFirst = (this.mFirst + 1) % this.capacity();
        return result;
    }

    @Override
    public final T removeLast() {
        this.checkInBounds(0);
        T result = this.get(this.mNumItems - 1);
        --this.mNumItems;
        return result;
    }

    @Override
    public boolean equals(Object rhsIn) {
        boolean equal = false;
        if (rhsIn == this) {
            equal = true;
        } else if (!(rhsIn instanceof CircularList)) {
            equal = false;
        } else {
            CircularList rhs = (CircularList)rhsIn;
            boolean bl = equal = this.capacity() == rhs.capacity() && this.size() == rhs.size();
            if (equal) {
                int size = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (CompareUtil.objectsEqual(this.get(i), rhs.get(i))) continue;
                    equal = false;
                    break;
                }
            }
        }
        return equal;
    }

    @Override
    public String toString() {
        return ArrayStringifier.stringify(this.toArray(), ", ");
    }

    public static interface OverflowHandler {
        public void handleBufferOverflow(Object var1);
    }
}

