/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.util.jmx.NotificationListenerInfo;
import com.sun.appserv.management.util.jmx.NotificationListenerTracking;
import com.sun.appserv.management.util.misc.ListUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.relation.MBeanServerNotificationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationEmitterSupport
extends NotificationBroadcasterSupport {
    private final boolean mAsyncDelivery;
    private SenderThread mSenderThread;
    private final Map<String, Integer> mListenerTypeCounts;
    private final NotificationListenerTracking mListeners;
    private static final String[] NO_TYPES = new String[0];
    private static final String WILDCARD_TYPE = "***";
    private static final String[] ALL_TYPES = new String[]{"***"};
    private static final String[] ATTRIBUTE_CHANGE_TYPES = new String[]{"jmx.attribute.change"};
    private static final String[] MBEAN_SERVER_NOTIFICATION_TYPES = new String[]{"JMX.mbean.registered", "JMX.mbean.unregistered"};
    private final Integer COUNT_1 = new Integer(1);

    public NotificationEmitterSupport(boolean asyncDelivery) {
        this.mAsyncDelivery = asyncDelivery;
        this.mSenderThread = null;
        this.mListenerTypeCounts = Collections.synchronizedMap(new HashMap());
        this.mListeners = new NotificationListenerTracking(true);
    }

    private synchronized SenderThread getSenderThread() {
        if (this.mSenderThread == null) {
            SenderThread senderThread = this.mSenderThread = this.mAsyncDelivery ? new SenderThread() : null;
            if (this.mSenderThread != null) {
                this.mSenderThread.start();
            }
        }
        return this.mSenderThread;
    }

    public synchronized void cleanup() {
        if (this.mSenderThread != null) {
            this.mSenderThread.quit();
            this.mSenderThread = null;
        }
    }

    public void sendAll() {
        if (this.mSenderThread != null) {
            this.mSenderThread.sendAll();
        }
    }

    public int getListenerCount() {
        return this.mListeners.getListenerCount();
    }

    public int getNotificationTypeListenerCount(String type) {
        Integer allCount;
        Integer count = this.mListenerTypeCounts.get(type);
        int resultCount = 0;
        if (count == null && (allCount = this.mListenerTypeCounts.get(WILDCARD_TYPE)) != null) {
            resultCount = allCount;
        }
        return resultCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementListenerCountForType(String type) {
        Map<String, Integer> map = this.mListenerTypeCounts;
        synchronized (map) {
            Integer count = this.mListenerTypeCounts.get(type);
            Integer newCount = count == null ? this.COUNT_1 : new Integer(count + 1);
            this.mListenerTypeCounts.put(type, newCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementListenerCountForType(String type) {
        Map<String, Integer> map = this.mListenerTypeCounts;
        synchronized (map) {
            Integer count = this.mListenerTypeCounts.get(type);
            if (count == null) {
                throw new IllegalArgumentException(type);
            }
            int oldValue = count;
            if (oldValue == 1) {
                this.mListenerTypeCounts.remove(type);
            } else {
                this.mListenerTypeCounts.put(type, new Integer(oldValue - 1));
            }
        }
    }

    private String[] getTypes(NotificationFilter filter) {
        String[] types = NO_TYPES;
        if (filter instanceof NotificationFilterSupport) {
            NotificationFilterSupport fs = (NotificationFilterSupport)filter;
            types = ListUtil.toStringArray(fs.getEnabledTypes());
        } else {
            types = filter instanceof AttributeChangeNotificationFilter ? ATTRIBUTE_CHANGE_TYPES : (filter instanceof MBeanServerNotificationFilter ? MBEAN_SERVER_NOTIFICATION_TYPES : ALL_TYPES);
        }
        return types;
    }

    private void addFilterTypeCounts(NotificationFilter filter) {
        String[] types;
        for (String type : types = this.getTypes(filter)) {
            this.incrementListenerCountForType(type);
        }
    }

    private void removeFilterTypeCounts(NotificationFilter filter) {
        String[] types;
        for (String type : types = this.getTypes(filter)) {
            this.decrementListenerCountForType(type);
        }
    }

    private void removeFilterTypeCounts(List<NotificationListenerInfo> infos) {
        for (NotificationListenerInfo info : infos) {
            this.removeFilterTypeCounts(info.getFilter());
        }
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        super.addNotificationListener(listener, filter, handback);
        this.mListeners.addNotificationListener(listener, filter, handback);
        this.addFilterTypeCounts(filter);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        super.removeNotificationListener(listener);
        List<NotificationListenerInfo> infos = this.mListeners.removeNotificationListener(listener);
        this.removeFilterTypeCounts(infos);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        super.removeNotificationListener(listener, filter, handback);
        this.mListeners.removeNotificationListener(listener);
        if (filter != null) {
            this.removeFilterTypeCounts(filter);
        }
    }

    protected void internalSendNotification(Notification notif) {
        super.sendNotification(notif);
    }

    @Override
    public void sendNotification(Notification notif) {
        if (this.getListenerCount() != 0) {
            if (this.getSenderThread() != null) {
                this.mSenderThread.enqueue(notif);
            } else {
                this.internalSendNotification(notif);
            }
        }
    }

    private final class SenderThread
    extends Thread {
        private boolean mQuit = false;
        private List<Notification> mPendingNotifications = Collections.synchronizedList(new LinkedList());

        public void quit() {
            this.mQuit = true;
            this.notifySelf();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifySelf() {
            SenderThread senderThread = this;
            synchronized (senderThread) {
                this.notify();
            }
        }

        private void enqueue(Notification notif) {
            this.mPendingNotifications.add(notif);
            this.notifySelf();
        }

        public boolean sendAll() {
            Notification notif = null;
            boolean sentSomething = false;
            while (!this.mPendingNotifications.isEmpty()) {
                sentSomething = true;
                try {
                    notif = this.mPendingNotifications.remove(0);
                    NotificationEmitterSupport.this.internalSendNotification(notif);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            return sentSomething;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int INTERVAL = 5000;
            this.mQuit = false;
            while (!this.mQuit) {
                try {
                    SenderThread senderThread = this;
                    synchronized (senderThread) {
                        this.wait(5000L);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.mQuit) break;
                boolean sentSomething = this.sendAll();
                if (sentSomething) continue;
                NotificationEmitterSupport.this.cleanup();
                this.sendAll();
                break;
            }
        }
    }
}

