/*
 * BackupHelper.java
 *
 * Created on December 22, 2003, 10:04 PM
 */

package com.sun.enterprise.config.backup.utils;

//remove dependency. FIXME
import com.sun.enterprise.config.backup.status.BackupStatus;
import com.sun.enterprise.config.backup.status.RestoreStatus;
import com.sun.enterprise.config.backup.status.UndoRestoreStatus;


import com.sun.enterprise.config.backup.status.Status;
import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.pluggable.BackupEnvironment;
import com.sun.enterprise.config.backup.pluggable.EnvironmentFactory;
import com.sun.enterprise.config.backup.pluggable.BackupSynchronizer;
import com.sun.enterprise.config.backup.pluggable.BackupStorage;
import com.sun.enterprise.config.backup.HistoryManager;
import com.sun.enterprise.config.backup.EnvironmentConstants;
import com.sun.enterprise.config.backup.DefaultConstants;
import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.BackupStorageMonitor;
import com.sun.enterprise.config.backup.FeatureFactory;
import com.sun.enterprise.config.backup.utils.SystemPropsHelper;
import com.sun.enterprise.util.io.FileUtils;

import java.io.File;
/**
 *
 * @author  sridatta
 */
public class BackupHelper implements EnvironmentConstants {
    
    /** Creates a new instance of BackupHelper */
    public BackupHelper() {
    }
 
    public static void setExecutionTypeInEnvironment(String type) {
        SystemPropsHelper.setProperty(EXECUTION_TYPE, type);
    }

    public static String getExecutionTypeFromEnvironment() {
        return SystemPropsHelper.getProperty(EXECUTION_TYPE);
    }
    
      /**
     * Determine the next number to be created
     * Managed the max numbers.
     * Delete the oldest one if required
     * get the prefix
     * add timestamp
     * create fileName = dir/prefix + timestamp+ number
     *
     * Update BackupNumber, TargetFile in BackupStatus
     * update source files, etc
     */
    
    public static String getAbsoluteBackupFileName(long timestamp) { 
        String fileName =   getRelativeBackupFileName(timestamp);
        return getAbsoluteBackupFileName(fileName);
    }
    
    private static String getRelativeBackupFileName(long timestamp) {
        String prefix = FactoryHelper.getEnv().getBackupFileNamePrefix();
        return constructRelativeName(prefix, timestamp);
    }

    private static String constructRelativeName(String prefix, long timestamp) {
        return   prefix + 
                            DefaultConstants.INTRA_FILENAME_SEPARATOR +
                            timestamp;
    }
    
    public static String getRelativeSnapShotFileName(long timestamp) 
                                    throws BackupException {
        
        String prefix = FactoryHelper.getEnv().getSnapshotFileNamePrefix();
        return constructRelativeName(prefix, timestamp);
    }
    
    /**
     * only set the exception if not already set
     */
    public static void setExceptionInStatus(Status bs, Exception e) {
        try {
            bs.setStatusCode(StatusConstants.STATUS_FAILURE);
            if(bs.getException() == null) {
                bs.setException(e);
            }
        } catch(Exception ex) {
            //ignore
        }
    }
    public static String ArrayToString(String[] arr) {
        String res = "";
        if (arr == null || arr.length == 0) return res;
        
        for (int i = 0; i < arr.length ; i++ ) {
            if(res != "") res+=", ";
            res += arr[i]; 
        }
        return res;
    }
    
    public static BackupStatus createBackupStatus(String userInfo, boolean init) {   
          BackupStatus backupStatus = null;
          try {
              backupStatus = new BackupStatus(userInfo, init);
          } catch (Exception e) {
              LoggerHelper.warning("error_creating_backup_status");
              BackupStatus bs = new BackupStatus();
              BackupHelper.setExceptionInStatus(bs, e);                                    
              return bs;
          }
          return backupStatus;
    }
    
    public static String getAbsoluteBackupFileName(BackupStatus bs) {
        String targetFile = null;
        try {
            long timestamp = bs.getCreationTimeStamp();
              targetFile = getAbsoluteBackupFileName(timestamp);
          } catch (Exception e) {
              LoggerHelper.warning("error_getting_backup_filename");
              BackupHelper.setExceptionInStatus(bs, e);            
          }
		
		
			
        return targetFile;
    }
    
    public static void addHistoryEntrySafe(Status status) {
         try {
                FactoryHelper.getHistoryManager().addHistoryEntry(status);
              } catch(Exception ex1) {
                  //too late to do anything
                  LoggerHelper.warning("error_adding_history_entry");
                  LoggerHelper.fine("error_adding_history_entry", ex1);                  
              }
    }
    
    public static void releaseLockSafe() {
        try {
                  FactoryHelper.getSynchronizer().release();
               } catch(Exception ex1) {
                  //too late to do anything
                  LoggerHelper.warning("error_releasing_lock");
                  LoggerHelper.fine("error_releasing_lock", ex1);                  
              }
    }
    
    public static String getAbsoluteBackupFileName(String relativeName) 
    { //  throws BackupInitException {
        if(isAbsolute(relativeName)) {
            return relativeName;
        }
        String dir = FactoryHelper.getEnv().getDirectoryToStoreBackupFiles();
        File parent  = new File(dir);
		File ourfile = new File(parent, relativeName);
		return FileUtils.safeGetCanonicalPath(ourfile);
    }  
    
    private static boolean isAbsolute(String name) {
        return new File(name).isAbsolute();
    }
    
    //restore apis
    public static File getLastBackupFile() {
        File f = null;
        try {
            f = FactoryHelper.getBackupStorageMonitor().getLatestFile();
        } catch(Exception e) {
            //ignore
        }
        return f;
    }
    
    //restore apis
    public static File getLastSnapShotFile() {
        File f = null;
        try {
            f = FactoryHelper.getSnapShotStorageMonitor().getLatestFile();
        } catch(Exception e) {
            //ignore
        }
        return f;
    }
    
    
    public static RestoreStatus createRestoreStatus(File f) {
        
        if(f==null || !f.exists()) {
            RestoreStatus rs1 = new RestoreStatus();
            setExceptionInStatus(rs1, 
                            new BackupException(
                                "missing_backup_files",
                                LocalStringsHelper.getString("missing_backup_files", f)));
            return rs1;
        }
        RestoreStatus rs = null;
        try {
            rs = new RestoreStatus(f.getAbsolutePath());
        } catch(Exception e) {
            RestoreStatus rs1 = new RestoreStatus();
            setExceptionInStatus(rs1, 
                    new BackupException(
                        "error_creating_restore_status",
                        LocalStringsHelper.getString("error_creating_restore_status")));
            return rs1;
        }
        return rs;
    }
    
    
    public static UndoRestoreStatus createUndoRestoreStatus(File f) {
        
        if(f==null || !f.exists()) {
            UndoRestoreStatus rs1 = new UndoRestoreStatus();
            setExceptionInStatus(rs1, 
                new BackupException(
                    "missing_snapshot_file", 
                    LocalStringsHelper.getString("missing_snapshot_file",f)));
            return rs1;
        }
        UndoRestoreStatus rs = null;
        try {
            rs = new UndoRestoreStatus(f.getAbsolutePath());
        } catch(Exception e) {
            UndoRestoreStatus rs1 = new UndoRestoreStatus();
            setExceptionInStatus(rs1,
               new BackupException(
                    "error_creating_undorestore_status", 
                    LocalStringsHelper.getString("error_creating_undorestore_status",f)));
            return rs1;
        }
        return rs;
    }
    
     //restore apis
    public static String getAbsoluteSnapshotFileName(long ts) { // throws BackupInitException {
        String relativeName = FactoryHelper.getEnv().getSnapshotFileNamePrefix() + 
                            DefaultConstants.INTRA_FILENAME_SEPARATOR + ts;
        
        String dir = FactoryHelper.getEnv().getDirectoryToStoreSnapshotFile();
        return dir + File.separator + relativeName;        
    }
}
