#!/bin/sh

set -e

UPSTREAM_VERSION=`dpkg-parsechangelog \
    | grep ^Version \
    | awk '{print $2}' \
    | sed 's/+dfsg[[:digit:]]\+//' \
    | sed 's/-[[:digit:]]\+$//'`

UPSTREAM_TARBALL=frogatto-$UPSTREAM_VERSION.tar.bz2
UPSTREAM_URL=http://www.frogatto.com/files/frogatto-$UPSTREAM_VERSION.tar.bz2
DEBIAN_VERSION=`dpkg-parsechangelog \
    | grep ^Version \
    | awk '{print $2}' \
    | sed 's/-[[:digit:]]\+$//'`

FROGATTO_TARBALL=frogatto_$DEBIAN_VERSION.orig.tar.gz
FROGATTO_DATA_TARBALL=frogatto-data_$DEBIAN_VERSION.orig.tar.gz


FROGATTO_OBJECTS="INSTALL LICENSE CHANGELOG Makefile src"


if ! test -f ../$UPSTREAM_TARBALL; then
    if ! wget -P .. $UPSTREAM_URL; then
    	echo "Error downloading upstream tarball"
    	exit -1
    fi
fi

TEMP_DIR=`mktemp -d`
SRC_DIR=$TEMP_DIR/frogatto-$UPSTREAM_VERSION
FROGATTO_DIR=$TEMP_DIR/frogatto-$DEBIAN_VERSION
FROGATTO_DATA_DIR=$TEMP_DIR/frogatto-data-$DEBIAN_VERSION

trap "rm -fr $TEMP_DIR" INT
echo "Use temporary directory $TEMP_DIR"

echo -n "Unpacking tarball... "
if tar -xjf `pwd`/../$UPSTREAM_TARBALL -C $TEMP_DIR; then
    find $TEMP_DIR -type d -exec chmod 0755 '{}' +
    find $TEMP_DIR -type f -exec chmod 0644 '{}' +
    echo done
else
    echo fail
    rm -fr $TEMP_DIR
    exit -2
fi

echo -n "Patching Makefile..."
perl -pi -e 's/^(\s*)ccache\s+/$1/g' $SRC_DIR/Makefile 
echo done

echo -n "Clean tree... "
rm -r $SRC_DIR/DejaVuSans.ttf \
    $SRC_DIR/FreeMono.ttf \
    $SRC_DIR/deprecated \
    $SRC_DIR/Makefile?*
echo done

mkdir -v $FROGATTO_DIR $FROGATTO_DATA_DIR

echo -n "Split data in directories... "
for object in $FROGATTO_OBJECTS; do
    mv $SRC_DIR/$object $FROGATTO_DIR
done

mv $SRC_DIR/* $FROGATTO_DATA_DIR/
cp $FROGATTO_DIR/LICENSE $FROGATTO_DIR/CHANGELOG $FROGATTO_DATA_DIR/
echo done

echo -n "Packing frogatto ($FROGATTO_TARBALL)... "
tar -C $TEMP_DIR -czf `pwd`/../$FROGATTO_TARBALL frogatto-$DEBIAN_VERSION
echo done
echo -n "Packing frogatto-data ($FROGATTO_DATA_TARBALL)... "
tar -C $TEMP_DIR -czf `pwd`/../$FROGATTO_DATA_TARBALL \
    frogatto-data-$DEBIAN_VERSION
echo done
exec rm -fr $TEMP_DIR
