#!/usr/bin/env python

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from Envy import ui
import ui_qtabout
import qtcredits
import qtlicense
import os
import sys

class AboutDlg(QDialog, ui_qtabout.Ui_AboutDlg):
    def __init__(self, version, parent=None):
        super(AboutDlg, self).__init__(parent)
        self.setupUi(self)
        
        self.about_label.setText('EnvyNG %s' %(version))
        
        
        '''
        Translations
        '''
        self.translation = ui.AbstractUI()
        self.label_2.setText(self.translation.string_description)
        self.license_button.setText(self.translation.string_license_button)
        self.credits_button.setText(self.translation.string_credits_button)
        self.close_button.setText(self.translation.string_close_button)
    
    @pyqtSignature("")
    def on_credits_button_clicked(self):
        credits = qtcredits.CreditsDlg(self)
        credits.show()
    
    @pyqtSignature("")
    def on_license_button_clicked(self):
        license = qtlicense.LicenseDlg(self)
        license.show()

if __name__ == '__main__':
    import sys
    app = QApplication(sys.argv)
    form = AboutDlg('1.1.0')
    form.show()
    app.exec_()
