/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SnapshotDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Options;

public class CopySnapshot
extends BaseCmd {
    private static final String DESCRIPTION_DESC = "An optional description of the snapshot.";
    private static final String SOURCE_REGION_DESC = "The region from which to copy the snapshot.";
    private static final String SOURCE_SNAPSHOT_ID_DESC = "The snapshot to copy.";
    private static final String SOURCE_REGION = "source-region";
    private static final String SOURCE_SNAPSHOT_ID = "source-snapshot-id";

    public CopySnapshot(String[] args) {
        super("ec2cpsnap", "ec2-copy-snapshot");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption(CopySnapshot.createOptionWithArgs("d", "description", DESCRIPTION_DESC));
        options.addOption(CopySnapshot.createOptionWithArgs("r", SOURCE_REGION, SOURCE_REGION_DESC, "SOURCE_REGION"));
        options.addOption(CopySnapshot.createOptionWithArgs("s", SOURCE_SNAPSHOT_ID, SOURCE_SNAPSHOT_ID_DESC, "SOURCE_SNAPSHOT_ID"));
        return options;
    }

    @Override
    protected String getOptionString() {
        return "-r SOURCE_REGION -s SOURCE_SNAPSHOT_ID [-d DESCRIPTION]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Copies a snapshot to this region from another region.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("description");
        this.printOption(SOURCE_REGION);
        this.printOption(SOURCE_SNAPSHOT_ID);
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp;
        RequestResultPair snapDescs;
        this.assertOptionSet(SOURCE_REGION);
        this.assertOptionSet(SOURCE_SNAPSHOT_ID);
        String sourceRegion = this.getOptionValue(SOURCE_REGION);
        String sourceSnapshotId = this.getOptionValue(SOURCE_SNAPSHOT_ID);
        String sourceEndpoint = String.format("https://ec2.%s.amazonaws.com", sourceRegion);
        String destEndpoint = jec2.getEndpoint();
        try {
            jec2.setEndpoint(sourceEndpoint);
        }
        catch (MalformedURLException e) {
            throw new GeneralError("Invalid region specified: " + sourceRegion);
        }
        String[] sourceSnapshot = new String[]{sourceSnapshotId};
        try {
            snapDescs = jec2.describeSnapshots(sourceSnapshot, new ArrayList(0));
        }
        catch (AmazonServiceException e) {
            throw e;
        }
        catch (AmazonClientException e) {
            throw new GeneralError("Unable to connect to host: '" + sourceEndpoint + "'", (Exception)((Object)e));
        }
        String status = ((SnapshotDescription)((List)snapDescs.getResponse()).get((int)0)).status;
        if ("pending".equals(status) || "error".equals(status)) {
            throw new GeneralError("Preventing copy of source snapshot '" + sourceSnapshotId + "' because its status is '" + status + "'.");
        }
        jec2.setEndpoint(destEndpoint);
        String description = this.getOptionValue("description");
        if (description == null) {
            description = "[Copied " + sourceSnapshotId + " from " + sourceRegion.toLowerCase() + "]";
        }
        if ((rsp = jec2.copySnapshot(sourceRegion, sourceSnapshotId, description)).getResponse() != null) {
            out.outputSnapshot(System.out, (String)rsp.getResponse());
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new CopySnapshot(args).invoke();
    }
}

