/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.CreateImageRequest;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateImageRequestMarshaller
implements Marshaller<Request<CreateImageRequest>, CreateImageRequest> {
    public Request<CreateImageRequest> marshall(CreateImageRequest createImageRequest) {
        if (createImageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createImageRequest, "AmazonEC2");
        request.addParameter("Action", "CreateImage");
        request.addParameter("Version", "2012-07-20");
        if (createImageRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)createImageRequest.getInstanceId()));
        }
        if (createImageRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createImageRequest.getName()));
        }
        if (createImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createImageRequest.getDescription()));
        }
        if (createImageRequest.isNoReboot() != null) {
            request.addParameter("NoReboot", StringUtils.fromBoolean((Boolean)createImageRequest.isNoReboot()));
        }
        List<BlockDeviceMapping> blockDeviceMappingList = createImageRequest.getBlockDeviceMapping();
        int blockDeviceMappingListIndex = 1;
        for (BlockDeviceMapping blockDeviceMappingListValue : blockDeviceMappingList) {
            BlockDeviceMapping blockDeviceMappingMember = blockDeviceMappingListValue;
            if (blockDeviceMappingMember != null) {
                EbsBlockDevice ebsBlockDeviceEbs;
                if (blockDeviceMappingMember.getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingListIndex + ".VirtualName", StringUtils.fromString((String)blockDeviceMappingMember.getVirtualName()));
                }
                if (blockDeviceMappingMember.getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingListIndex + ".DeviceName", StringUtils.fromString((String)blockDeviceMappingMember.getDeviceName()));
                }
                if ((ebsBlockDeviceEbs = blockDeviceMappingMember.getEbs()) != null) {
                    if (ebsBlockDeviceEbs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebsBlockDeviceEbs.getSnapshotId()));
                    }
                    if (ebsBlockDeviceEbs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebsBlockDeviceEbs.getVolumeSize()));
                    }
                    if (ebsBlockDeviceEbs.isDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebsBlockDeviceEbs.isDeleteOnTermination()));
                    }
                    if (ebsBlockDeviceEbs.getVolumeType() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebsBlockDeviceEbs.getVolumeType()));
                    }
                    if (ebsBlockDeviceEbs.getIops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebsBlockDeviceEbs.getIops()));
                    }
                }
                if (blockDeviceMappingMember.getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingListIndex + ".NoDevice", StringUtils.fromString((String)blockDeviceMappingMember.getNoDevice()));
                }
            }
            ++blockDeviceMappingListIndex;
        }
        return request;
    }
}

