/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class AssignPrivateIpAddressesRequestMarshaller
implements Marshaller<Request<AssignPrivateIpAddressesRequest>, AssignPrivateIpAddressesRequest> {
    public Request<AssignPrivateIpAddressesRequest> marshall(AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest) {
        if (assignPrivateIpAddressesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)assignPrivateIpAddressesRequest, "AmazonEC2");
        request.addParameter("Action", "AssignPrivateIpAddresses");
        request.addParameter("Version", "2012-07-20");
        if (assignPrivateIpAddressesRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)assignPrivateIpAddressesRequest.getNetworkInterfaceId()));
        }
        List<String> privateIpAddressesList = assignPrivateIpAddressesRequest.getPrivateIpAddresses();
        int privateIpAddressesListIndex = 1;
        for (String privateIpAddressesListValue : privateIpAddressesList) {
            if (privateIpAddressesListValue != null) {
                request.addParameter("PrivateIpAddress." + privateIpAddressesListIndex, StringUtils.fromString((String)privateIpAddressesListValue));
            }
            ++privateIpAddressesListIndex;
        }
        if (assignPrivateIpAddressesRequest.getSecondaryPrivateIpAddressCount() != null) {
            request.addParameter("SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)assignPrivateIpAddressesRequest.getSecondaryPrivateIpAddressCount()));
        }
        if (assignPrivateIpAddressesRequest.isAllowReassignment() != null) {
            request.addParameter("AllowReassignment", StringUtils.fromBoolean((Boolean)assignPrivateIpAddressesRequest.isAllowReassignment()));
        }
        return request;
    }
}

