/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import java.util.ArrayList;
import org.jets3t.service.model.StorageBucket;

public class S3Bucket
extends StorageBucket {
    public static final String LOCATION_US = null;
    public static final String LOCATION_US_STANDARD = null;
    public static final String LOCATION_US_WEST = "us-west-1";
    public static final String LOCATION_EUROPE = "EU";
    public static final String LOCATION_ASIA_PACIFIC = "ap-southeast-1";
    private String location = LOCATION_US;
    private boolean isLocationKnown = false;
    private boolean requesterPays = false;
    private boolean isRequesterPaysKnown = false;

    public S3Bucket() {
    }

    public S3Bucket(String name) {
        super(name);
    }

    public S3Bucket(String name, String location) {
        this(name);
        this.location = location;
        this.isLocationKnown = true;
    }

    public String toString() {
        return "S3Bucket [name=" + this.getName() + ",location=" + this.getLocation() + ",creationDate=" + this.getCreationDate() + ",owner=" + this.getOwner() + "] Metadata=" + this.getMetadataMap();
    }

    public void setLocation(String location) {
        this.location = location;
        this.isLocationKnown = true;
    }

    public boolean isLocationKnown() {
        return this.isLocationKnown;
    }

    public String getLocation() {
        return this.location;
    }

    public void setRequesterPays(boolean requesterPays) {
        this.requesterPays = requesterPays;
        this.isRequesterPaysKnown = true;
    }

    public boolean isRequesterPaysKnown() {
        return this.isRequesterPaysKnown;
    }

    public boolean isRequesterPays() {
        return this.requesterPays;
    }

    public static S3Bucket[] cast(StorageBucket[] buckets) {
        ArrayList<S3Bucket> results = new ArrayList<S3Bucket>();
        for (StorageBucket bucket : buckets) {
            results.add((S3Bucket)bucket);
        }
        return results.toArray(new S3Bucket[results.size()]);
    }
}

