/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ConversionTaskDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.cmd.CreateConversionTask;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.vmconversion.InternalException;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ImportVolume
extends CreateConversionTask {
    public static final String TASK_TYPE = "ImportVolume";
    public static final String[] AVAILABILITYZONE_DESC = new String[]{"Specifies the availability zone for the imported disk-image. Run the", "'ec2-describe-availability-zones' command for a list of values, and", "see the latest Developer's Guide for their meanings. [REQUIRED]"};

    public ImportVolume(String[] args) {
        super("ec2ivol", new String[]{"ec2iv", "ec2-import-volume"});
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("format");
        this.printOption("volume-size");
        this.printOption("availability-zone");
        this.printOption("bucket");
        this.printOption("owner-akid");
        this.printOption("owner-sak");
        this.printOption("prefix");
        this.printOption("manifest-url");
        this.printOption("description");
        this.printOption("expires");
        this.printOption("ignore-region-affinity");
        this.printOption("dont-verify-format");
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Create a new import volume task using meta-data from the given disk");
        System.out.println("     image. The volume size for the imported disk-image will be calculated");
        System.out.println("     automatically, unless specified. The image may then be uploaded using");
        System.out.println("     ec2-upload-disk-image");
    }

    protected void validateParameters() throws GeneralError, VerificationException {
        super.validateParameters();
        this.assertOptionSet("availability-zone");
        this.az = this.getOptionValue("availability-zone");
    }

    protected Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"availability-zone");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"ZONE");
        OptionBuilder.withDescription((String)ImportVolume.joinDescription(AVAILABILITYZONE_DESC));
        options.addOption(OptionBuilder.create((String)"z"));
        return options;
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        try {
            this.validateParameters();
            this.createSignedManifestUrl();
            long diskImageSize = this.image.length();
            ConversionTaskDescription rsp = jec2.importVolume(this.az, this.description, this.diskImageFormat, this.signedManifestUrl, diskImageSize, this.volumeSize);
            out.output(System.out, rsp, rsp.getImportVolumeConversionTask(), false);
            return true;
        }
        catch (VerificationException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
        catch (InternalException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
    }

    public static void main(String[] args) {
        new ImportVolume(args).invoke();
    }
}

