/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.AuthRevBase;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeleteGroup
extends BaseCmd {
    public DeleteGroup(String[] args) {
        super("ec2delgrp", "ec2-delete-group");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    protected String getOptionString() {
        return "GROUP";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Delete an existing security group");
        System.out.println("     The GROUP parameter specifies the group name or group ID to delete.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String name = null;
        String groupId = null;
        this.assertNonOptionSet("GROUP");
        String nameOrId = this.getNonOptions()[0];
        this.warnIfTooManyNonOptions();
        if (AuthRevBase.isSecurityGroupId(nameOrId)) {
            groupId = nameOrId;
        } else {
            name = nameOrId;
        }
        RequestResultPair rsp = jec2.deleteSecurityGroup(name, groupId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.output(System.out, (Boolean)rsp.getResponse());
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new DeleteGroup(args).invoke();
    }
}

