/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.KeyPairInfo;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class CreateKeyPair
extends BaseCmd {
    public CreateKeyPair(String[] args) {
        super("ec2addkey", new String[]{"ec2-create-keypair", "ec2-add-keypair"});
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    protected String getOptionString() {
        return "KEY";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Generate a new keypair.");
        System.out.println("     The KEY parameter is the name of the new keypair.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("KEY");
        String keyName = this.getNonOptions()[0];
        this.warnIfTooManyNonOptions();
        RequestResultPair kp = jec2.createKeyPair(keyName);
        out.outputKeyPair(System.out, ((KeyPairInfo)kp.getResponse()).keyName, ((KeyPairInfo)kp.getResponse()).keyFingerprint, ((KeyPairInfo)kp.getResponse()).keyMaterial);
        out.printRequestId(System.out, (RequestResult)kp);
        return true;
    }

    public static void main(String[] args) {
        new CreateKeyPair(args).invoke();
    }
}

