/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.jaxb2;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.attachments.AttachmentUtil;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.ByteDataSource;
import org.codehaus.xfire.attachments.JavaMailAttachments;
import org.codehaus.xfire.attachments.SimpleAttachment;
import org.codehaus.xfire.util.UID;

public class AttachmentMarshaller
extends javax.xml.bind.attachment.AttachmentMarshaller {
    private static final Log log = LogFactory.getLog(AttachmentMarshaller.class);
    private MessageContext context;

    public AttachmentMarshaller(MessageContext context) {
        this.context = context;
    }

    public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String elementNamespace, String elementLocalName) {
        log.debug((Object)("Adding byte[] attachment {" + elementNamespace + "}" + elementLocalName));
        Attachments atts = this.context.getOutMessage().getAttachments();
        if (atts == null) {
            atts = new JavaMailAttachments();
            this.context.getOutMessage().setAttachments(atts);
        }
        ByteDataSource source = new ByteDataSource(data, offset, length);
        source.setContentType(mimeType);
        DataHandler handler = new DataHandler((DataSource)source);
        String id = AttachmentUtil.createContentID(elementNamespace);
        SimpleAttachment att = new SimpleAttachment(id, handler);
        att.setXOP(true);
        atts.addPart(att);
        return "cid:" + id;
    }

    public String addMtomAttachment(DataHandler handler, String elementNS, String elementLocalName) {
        log.debug((Object)("Adding DataHandler attachment {" + elementNS + "}" + elementLocalName));
        Attachments atts = this.context.getOutMessage().getAttachments();
        if (atts == null) {
            atts = new JavaMailAttachments();
            this.context.getOutMessage().setAttachments(atts);
        }
        String id = AttachmentUtil.createContentID(elementNS);
        SimpleAttachment att = new SimpleAttachment(id, handler);
        atts.addPart(att);
        att.setXOP(true);
        return "cid:" + id;
    }

    public String addSwaRefAttachment(DataHandler handler) {
        Attachments atts = this.context.getOutMessage().getAttachments();
        if (atts == null) {
            atts = new JavaMailAttachments();
            this.context.getOutMessage().setAttachments(atts);
        }
        String id = UID.generate() + "@" + handler.getName();
        SimpleAttachment att = new SimpleAttachment(id, handler);
        atts.addPart(att);
        return id;
    }

    public boolean isXOPPackage() {
        String mtomEnabled = (String)this.context.getContextualProperty("mtom-enabled");
        if (mtomEnabled == null) {
            return false;
        }
        return Boolean.valueOf(mtomEnabled);
    }
}

