/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.parser.processors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.Binding;
import org.apache.ws.security.policy.model.PolicyEngineData;
import org.apache.ws.security.policy.model.SymmetricBinding;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;
import org.apache.ws.security.policy.parser.processors.AlgorithmSuiteProcessor;
import org.apache.ws.security.policy.parser.processors.LayoutProcessor;
import org.apache.ws.security.policy.parser.processors.SignEncProtectTokenProcessor;

public class SymmetricBindingProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean initializedSymmetricBinding = false;

    private void initializeSymmetricBinding(SecurityPolicyToken spt) throws NoSuchMethodException {
        SignEncProtectTokenProcessor sept = new SignEncProtectTokenProcessor();
        SecurityPolicyToken tmpSpt = SecurityPolicy.encryptionToken.copy();
        tmpSpt.setProcessTokenMethod(sept);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.signatureToken.copy();
        tmpSpt.setProcessTokenMethod(sept);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.protectionToken.copy();
        tmpSpt.setProcessTokenMethod(sept);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.algorithmSuite.copy();
        tmpSpt.setProcessTokenMethod(new AlgorithmSuiteProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.layout.copy();
        tmpSpt.setProcessTokenMethod(new LayoutProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.includeTimestamp.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.encryptBeforeSigning.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.signBeforeEncrypting.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.encryptSignature.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.protectTokens.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.onlySignEntireHeadersAndBody.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
    }

    public Object doSymmetricBinding(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.initializedSymmetricBinding) break;
                try {
                    this.initializeSymmetricBinding(spt);
                    this.initializedSymmetricBinding = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doIncludeTimestamp(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((Binding)spc.readCurrentPolicyEngineData()).setIncludeTimestamp(true);
        }
        return new Boolean(true);
    }

    public Object doEncryptBeforeSigning(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            try {
                ((SymmetricBinding)spc.readCurrentPolicyEngineData()).setProtectionOrder(spc.getAssertion().getName().getLocalPart());
            }
            catch (WSSPolicyException e) {
                return new Boolean(false);
            }
        }
        return new Boolean(true);
    }

    public Object doSignBeforeEncrypting(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            try {
                ((SymmetricBinding)spc.readCurrentPolicyEngineData()).setProtectionOrder(spc.getAssertion().getName().getLocalPart());
            }
            catch (WSSPolicyException e) {
                return new Boolean(false);
            }
        }
        return new Boolean(true);
    }

    public Object doEncryptSignature(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            PolicyEngineData readCurrentPolicyEngineData = spc.readCurrentPolicyEngineData();
            ((SymmetricBinding)readCurrentPolicyEngineData).setSignatureProtection(true);
        }
        return new Boolean(true);
    }

    public Object doProtectTokens(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((SymmetricBinding)spc.readCurrentPolicyEngineData()).setTokenProtection(true);
        }
        return new Boolean(true);
    }

    public Object doOnlySignEntireHeadersAndBody(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((SymmetricBinding)spc.readCurrentPolicyEngineData()).setEntireHeaderAndBodySignatures(true);
        }
        return new Boolean(true);
    }
}

